package com.transsion.ad.util

import android.view.View

/**
 * @author shmizhangxinbing
 * @date : 2025/9/8 11:48
 * @description: 在 Android 开发中，防抖点击（防止按钮短时间内被连续点击多次）是很常见的需求。
 */
class DebounceClickListener(
    private val interval: Long = 1000L, private val onDebounceClick: (View) -> Unit
) : View.OnClickListener {
    companion object {
        private const val KEY_LAST_CLICK_TIME = -1001
    }

    override fun onClick(v: View?) {
        v?.let {
            val lastClickTime = it.getTag(KEY_LAST_CLICK_TIME) as? Long ?: 0
            val currentTime = System.currentTimeMillis()
            if (currentTime - lastClickTime > interval) {
                it.setTag(KEY_LAST_CLICK_TIME, currentTime)
                onDebounceClick(it)
            }
        }
    }
}
