/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.util;

import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import com.transsion.ad.util.TextWithDividerConfig;
import com.transsion.ad.util.VerticalLineSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/transsion/ad/util/TextWithDividerHelper;", "", "<init>", "()V", "create", "Landroid/text/SpannableString;", "leftText", "", "rightText", "config", "Lcom/transsion/ad/util/TextWithDividerConfig;", "lib_ad_release"})
public final class TextWithDividerHelper {
    @NotNull
    public static final TextWithDividerHelper INSTANCE = new TextWithDividerHelper();

    private TextWithDividerHelper() {
    }

    @NotNull
    public final SpannableString create(@NotNull String leftText, @NotNull String rightText, @NotNull TextWithDividerConfig config) {
        SpannableString spannableString;
        block1: {
            int color2;
            Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
            Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String separator = !StringsKt.isBlank((CharSequence)leftText) && !StringsKt.isBlank((CharSequence)rightText) ? " " : "";
            String combinedText = leftText + separator + rightText;
            spannableString = new SpannableString((CharSequence)combinedText);
            int linePosition = leftText.length();
            spannableString.setSpan((Object)new VerticalLineSpan(config), linePosition, linePosition + 1, 17);
            Integer n = config.getLeftTextColor();
            if (n != null) {
                color2 = ((Number)n).intValue();
                boolean bl = false;
                spannableString.setSpan((Object)new ForegroundColorSpan(color2), 0, leftText.length(), 17);
            }
            Integer n2 = config.getRightTextColor();
            if (n2 == null) break block1;
            color2 = ((Number)n2).intValue();
            boolean bl = false;
            int rightTextStart = leftText.length() + 1;
            int rightTextEnd = rightTextStart + rightText.length();
            spannableString.setSpan((Object)new ForegroundColorSpan(color2), rightTextStart, rightTextEnd, 17);
        }
        return spannableString;
    }

    public static /* synthetic */ SpannableString create$default(TextWithDividerHelper textWithDividerHelper, String string2, String string3, TextWithDividerConfig textWithDividerConfig, int n, Object object) {
        if ((n & 4) != 0) {
            textWithDividerConfig = new TextWithDividerConfig(0, 0, 0, null, null, 31, null);
        }
        return textWithDividerHelper.create(string2, string3, textWithDividerConfig);
    }
}

