/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.web.cct;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import androidx.browser.customtabs.CustomTabsIntent;
import com.transsion.ad.web.cct.CustomTabFallback;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/transsion/ad/web/cct/CustomTabsHelper;", "", "<init>", "()V", "Companion", "lib_ad_release"})
public final class CustomTabsHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ACTION_CUSTOM_TABS_CONNECTION = "android.support.customtabs.action.CustomTabsService";
    @Nullable
    private static String sPackageNameToUse;

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/transsion/ad/web/cct/CustomTabsHelper$Companion;", "", "<init>", "()V", "ACTION_CUSTOM_TABS_CONNECTION", "", "sPackageNameToUse", "openCustomTab", "", "activity", "Landroid/app/Activity;", "customTabsIntent", "Landroidx/browser/customtabs/CustomTabsIntent;", "uri", "Landroid/net/Uri;", "fallback", "Lcom/transsion/ad/web/cct/CustomTabFallback;", "mode", "Lcom/transsion/ad/web/cct/CustomTabsHelper$Companion$Mode;", "getPreferredCustomTabPackage", "context", "Landroid/content/Context;", "getPackageNameToUse", "hasSpecializedHandlerIntents", "", "intent", "Landroid/content/Intent;", "Mode", "lib_ad_release"})
    @SourceDebugExtension(value={"SMAP\nCustomTabsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomTabsHelper.kt\ncom/transsion/ad/web/cct/CustomTabsHelper$Companion\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,178:1\n29#2:179\n*S KotlinDebug\n*F\n+ 1 CustomTabsHelper.kt\ncom/transsion/ad/web/cct/CustomTabsHelper$Companion\n*L\n121#1:179\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void openCustomTab(@NotNull Activity activity, @NotNull CustomTabsIntent customTabsIntent, @NotNull Uri uri, @Nullable CustomTabFallback fallback, @NotNull Mode mode) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)customTabsIntent, (String)"customTabsIntent");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            String packageName = switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1 -> this.getPreferredCustomTabPackage((Context)activity);
                case 2 -> this.getPackageNameToUse((Context)activity);
                default -> throw new NoWhenBranchMatchedException();
            };
            if (packageName == null) {
                CustomTabFallback customTabFallback = fallback;
                if (customTabFallback != null) {
                    customTabFallback.openUri(activity, uri);
                }
            } else {
                customTabsIntent.intent.setPackage(packageName);
                customTabsIntent.launchUrl((Context)activity, uri);
            }
        }

        public static /* synthetic */ void openCustomTab$default(Companion companion, Activity activity, CustomTabsIntent customTabsIntent, Uri uri, CustomTabFallback customTabFallback, Mode mode, int n, Object object) {
            if ((n & 0x10) != 0) {
                mode = Mode.PRIORITY_CHROME;
            }
            companion.openCustomTab(activity, customTabsIntent, uri, customTabFallback, mode);
        }

        @Nullable
        public final String getPreferredCustomTabPackage(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PackageManager pm = context.getPackageManager();
            Intent serviceIntent = new Intent(CustomTabsHelper.ACTION_CUSTOM_TABS_CONNECTION);
            serviceIntent.setPackage("com.android.chrome");
            if (pm.resolveService(serviceIntent, 0) != null) {
                return "com.android.chrome";
            }
            String[] stringArray = new String[]{"com.chrome.beta", "com.chrome.dev", "com.chrome.canary"};
            List chromePackages = CollectionsKt.listOf((Object[])stringArray);
            for (String pkg : chromePackages) {
                serviceIntent.setPackage(pkg);
                if (pm.resolveService(serviceIntent, 0) == null) continue;
                return pkg;
            }
            return this.getPackageNameToUse(context);
        }

        @SuppressLint(value={"QueryPermissionsNeeded"})
        @Nullable
        public final String getPackageNameToUse(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (sPackageNameToUse != null) {
                return sPackageNameToUse;
            }
            PackageManager pm = context.getPackageManager();
            String $this$toUri$iv = "http://www.example.com";
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
            Intent activityIntent = new Intent("android.intent.action.VIEW", uri);
            ResolveInfo defaultViewHandlerInfo = pm.resolveActivity(activityIntent, 0);
            String defaultViewHandlerPackageName = null;
            if (defaultViewHandlerInfo != null) {
                defaultViewHandlerPackageName = defaultViewHandlerInfo.activityInfo.packageName;
            }
            List list = pm.queryIntentActivities(activityIntent, 0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
            List resolvedActivityList = list;
            List packagesSupportingCustomTabs = new ArrayList();
            for (ResolveInfo info : resolvedActivityList) {
                Intent serviceIntent = new Intent();
                serviceIntent.setAction(CustomTabsHelper.ACTION_CUSTOM_TABS_CONNECTION);
                serviceIntent.setPackage(info.activityInfo.packageName);
                if (pm.resolveService(serviceIntent, 0) == null) continue;
                packagesSupportingCustomTabs.add(info.activityInfo.packageName);
            }
            sPackageNameToUse = packagesSupportingCustomTabs.isEmpty() ? null : (!TextUtils.isEmpty((CharSequence)defaultViewHandlerPackageName) && !this.hasSpecializedHandlerIntents(context, activityIntent) && packagesSupportingCustomTabs.contains(defaultViewHandlerPackageName) ? defaultViewHandlerPackageName : (String)packagesSupportingCustomTabs.get(0));
            return sPackageNameToUse;
        }

        @SuppressLint(value={"QueryPermissionsNeeded"})
        private final boolean hasSpecializedHandlerIntents(Context context, Intent intent) {
            try {
                PackageManager pm = context.getPackageManager();
                List list = pm.queryIntentActivities(intent, 64);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
                List handlers = list;
                if (handlers.isEmpty()) {
                    return false;
                }
                for (ResolveInfo resolveInfo : handlers) {
                    IntentFilter filter;
                    if (resolveInfo.filter == null || filter.countDataAuthorities() == 0 || filter.countDataPaths() == 0 || resolveInfo.activityInfo == null) continue;
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/transsion/ad/web/cct/CustomTabsHelper$Companion$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "PRIORITY_CHROME", "DEFAULT_BROWSER", "lib_ad_release"})
        public static final class Mode
        extends Enum<Mode> {
            public static final /* enum */ Mode PRIORITY_CHROME = new Mode();
            public static final /* enum */ Mode DEFAULT_BROWSER = new Mode();
            private static final /* synthetic */ Mode[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Mode[] values() {
                return (Mode[])$VALUES.clone();
            }

            public static Mode valueOf(String value) {
                return Enum.valueOf(Mode.class, value);
            }

            @NotNull
            public static EnumEntries<Mode> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = modeArray = new Mode[]{Mode.PRIORITY_CHROME, Mode.DEFAULT_BROWSER};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.PRIORITY_CHROME.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.DEFAULT_BROWSER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

