/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.platform.admob;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.zero.iad.core.R;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.constants.AdSource;
import com.zero.iad.core.http.request.LogRequest;
import com.zero.iad.core.impl.IAd;
import com.zero.iad.core.impl.IAdBanner;
import com.zero.iad.core.impl.IAdPlatform;
import com.zero.iad.core.impl.TAdListener;
import com.zero.iad.core.platform.BasePlatform;
import com.zero.iad.core.stat.EventTrackerHelper;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.PlatformUtil;
import java.util.HashMap;

public class AdBannerAdmob
extends BasePlatform
implements IAdBanner,
IAdPlatform {
    private String r = "";
    private int aR = 0;
    private AdView aS;
    private TAdListener aT = null;
    private AdItem f;
    private long aU;

    public AdBannerAdmob(IAd iAd) {
        super(iAd);
    }

    @Override
    public void setBannerSize(int n) {
        this.aR = n;
    }

    @Override
    public View getBannerView(Context context) {
        this.aS = new AdView(context);
        this.aS.setAdUnitId(this.r);
        switch (this.aR) {
            case 0: 
            case 3: {
                this.aS.setAdSize(AdSize.BANNER);
                break;
            }
            case 1: {
                this.aS.setAdSize(AdSize.LARGE_BANNER);
                break;
            }
            case 2: {
                this.aS.setAdSize(AdSize.MEDIUM_RECTANGLE);
                break;
            }
            default: {
                this.aS.setAdSize(AdSize.BANNER);
            }
        }
        this.aS.setAdListener(new AdListener(){

            public void onAdClosed() {
                super.onAdClosed();
                if (AdBannerAdmob.this.aT != null) {
                    AdBannerAdmob.this.aT.onAdClosed();
                }
            }

            public void onAdFailedToLoad(int n) {
                super.onAdFailedToLoad(n);
                if (AdBannerAdmob.this.isNotTimeOut()) {
                    HashMap<String, String> hashMap = AdBannerAdmob.this.getEvevtMap();
                    hashMap.put("type_code", "1");
                    hashMap.put("status", String.valueOf(n));
                    EventTrackerHelper.trackthirdEvent(AdBannerAdmob.this.parent, hashMap, true);
                    TAdError tAdError = PlatformUtil.getAdError(n);
                    AdLogUtil.Log().e("AdBannerAdmob", tAdError.getErrorMessage());
                    if (AdBannerAdmob.this.aT != null) {
                        AdBannerAdmob.this.aT.onError(tAdError);
                    }
                }
            }

            public void onAdLeftApplication() {
                long l = System.currentTimeMillis();
                if (l - AdBannerAdmob.this.aU > 2000L) {
                    if (AdBannerAdmob.this.f != null && AdBannerAdmob.this.f.getClkUrlsList() != null) {
                        LogRequest.syncUpdateCLKLogRequest("", AdBannerAdmob.this.f.getClkUrlsList(), AdBannerAdmob.this.f.getCacheNum());
                    }
                    if (AdBannerAdmob.this.aT != null) {
                        AdBannerAdmob.this.aT.onAdClicked();
                    }
                    AdBannerAdmob.this.aU = l;
                }
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                if (AdBannerAdmob.this.isNotTimeOut()) {
                    HashMap<String, String> hashMap = AdBannerAdmob.this.getEvevtMap();
                    hashMap.put("type_code", "1");
                    hashMap.put("status", "200");
                    EventTrackerHelper.trackthirdEvent(AdBannerAdmob.this.parent, hashMap, true);
                    if (AdBannerAdmob.this.aT != null) {
                        AdBannerAdmob.this.aT.onAdLoaded();
                    }
                }
            }
        });
        this.startTime = System.currentTimeMillis();
        return this.aS;
    }

    @Override
    public boolean isPlatformExists() {
        return false;
    }

    @Override
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd() {
        if (this.aS != null) {
            AdLogUtil.Log().d("AdBannerAdmob", R.string.request_google_banner);
            AdRequest adRequest = new AdRequest.Builder().build();
            this.aS.loadAd(adRequest);
        }
    }

    @Override
    public boolean isAdAccepted(AdItem adItem) {
        this.f = adItem;
        return adItem != null && adItem.getAdSource() == AdSource.AD_ADMOB;
    }

    @Override
    public void setPlacementId(String string2) {
        this.r = string2;
    }

    @Override
    public void setAdListener(TAdListener tAdListener) {
        this.aT = tAdListener;
    }

    @Override
    public void destroy() {
        if (this.aS != null) {
            this.aS.setAdListener(null);
            this.aS.destroy();
            this.aS = null;
        }
        AdLogUtil.Log().d("AdBannerAdmob", "destroy");
    }
}

