/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.platform.facebook;

import android.content.Context;
import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.zero.iad.core.R;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.constants.AdSource;
import com.zero.iad.core.http.request.LogRequest;
import com.zero.iad.core.impl.IAd;
import com.zero.iad.core.impl.IAdBanner;
import com.zero.iad.core.impl.IAdPlatform;
import com.zero.iad.core.impl.TAdListener;
import com.zero.iad.core.platform.BasePlatform;
import com.zero.iad.core.stat.EventTrackerHelper;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.PlatformUtil;
import java.util.HashMap;

public class AdBannerFacebook
extends BasePlatform
implements IAdBanner,
IAdPlatform {
    private TAdListener ba;
    private String r;
    private int aR;
    private AdView br;
    private AdSize bs;
    private AdItem f;
    private long aU;

    public AdBannerFacebook(IAd iAd) {
        super(iAd);
    }

    @Override
    public void setBannerSize(int n) {
        this.aR = n;
    }

    @Override
    public View getBannerView(Context context) {
        switch (this.aR) {
            case 0: {
                this.bs = AdSize.BANNER_HEIGHT_50;
                break;
            }
            case 1: {
                this.bs = AdSize.BANNER_HEIGHT_90;
                break;
            }
            case 2: {
                this.bs = AdSize.INTERSTITIAL;
                break;
            }
        }
        this.br = new AdView(context, this.r, this.bs);
        this.br.setAdListener(new AdListener(){

            public void onError(Ad ad, AdError adError) {
                if (AdBannerFacebook.this.isNotTimeOut()) {
                    AdLogUtil.Log().e("AdBannerFacebook", adError.getErrorMessage());
                    HashMap<String, String> hashMap = AdBannerFacebook.this.getEvevtMap();
                    hashMap.put("type_code", "2");
                    hashMap.put("status", String.valueOf(adError.getErrorCode()));
                    EventTrackerHelper.trackthirdEvent(AdBannerFacebook.this.parent, hashMap, true);
                    TAdError tAdError = PlatformUtil.getAdError(adError.getErrorCode());
                    if (AdBannerFacebook.this.ba != null) {
                        AdBannerFacebook.this.ba.onError(tAdError);
                    }
                }
            }

            public void onAdLoaded(Ad ad) {
                if (AdBannerFacebook.this.isNotTimeOut()) {
                    HashMap<String, String> hashMap = AdBannerFacebook.this.getEvevtMap();
                    hashMap.put("type_code", "2");
                    hashMap.put("status", "200");
                    EventTrackerHelper.trackthirdEvent(AdBannerFacebook.this.parent, hashMap, true);
                    if (AdBannerFacebook.this.ba != null) {
                        AdBannerFacebook.this.ba.onAdLoaded();
                    }
                }
            }

            public void onAdClicked(Ad ad) {
                long l = System.currentTimeMillis();
                if (l - AdBannerFacebook.this.aU > 2000L) {
                    if (AdBannerFacebook.this.f != null && AdBannerFacebook.this.f.getClkUrlsList() != null) {
                        LogRequest.syncUpdateCLKLogRequest("", AdBannerFacebook.this.f.getClkUrlsList(), AdBannerFacebook.this.f.getCacheNum());
                    }
                    if (AdBannerFacebook.this.ba != null) {
                        AdBannerFacebook.this.ba.onAdClicked();
                    }
                    AdBannerFacebook.this.aU = l;
                }
            }

            public void onLoggingImpression(Ad ad) {
            }
        });
        this.startTime = System.currentTimeMillis();
        return this.br;
    }

    @Override
    public boolean isPlatformExists() {
        return false;
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d("AdBannerFacebook", R.string.request_fb_banner);
        this.br.loadAd();
    }

    @Override
    public boolean isAdAccepted(AdItem adItem) {
        this.f = adItem;
        return this.f != null && this.f.getAdSource() == AdSource.AD_FAN;
    }

    @Override
    public void setPlacementId(String string2) {
        this.r = string2;
    }

    @Override
    public void setAdListener(TAdListener tAdListener) {
        this.ba = tAdListener;
    }

    @Override
    public void destroy() {
        if (this.br != null) {
            this.br.setAdListener(null);
            this.br.destroy();
            this.br = null;
        }
        AdLogUtil.Log().d("AdBannerFacebook", "destroy");
    }
}

