/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.platform.facebook;

import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.NativeAd;
import com.transsion.core.CoreUtil;
import com.zero.iad.core.R;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.bean.TAdNativeInfo;
import com.zero.iad.core.config.MediaControl;
import com.zero.iad.core.constants.AdSource;
import com.zero.iad.core.http.request.LogRequest;
import com.zero.iad.core.impl.IAd;
import com.zero.iad.core.impl.IAdNativePlatform;
import com.zero.iad.core.impl.TAdListener;
import com.zero.iad.core.platform.BasePlatform;
import com.zero.iad.core.stat.EventTrackerHelper;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.PlatformUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AdNativeFacebook
extends BasePlatform
implements IAdNativePlatform {
    private AdItem f;
    private TAdListener ba;
    private String r;
    private NativeAd bw;

    public AdNativeFacebook(IAd iAd) {
        super(iAd);
    }

    @Override
    public boolean isPlatformExists() {
        return false;
    }

    public NativeAd getNativeAd() {
        return this.bw;
    }

    @Override
    public void loadAd() {
        if (this.f != null) {
            this.bw = new NativeAd(CoreUtil.getContext(), this.r);
            AdLogUtil.Log().d("AdNativeFacebook", R.string.request_fb_native);
            this.bw.setAdListener(new AdListener(){

                public void onError(Ad ad, AdError adError) {
                    AdLogUtil.Log().e("AdNativeFacebook", adError.getErrorMessage());
                    TAdError tAdError = PlatformUtil.getAdError(adError.getErrorCode());
                    if (AdNativeFacebook.this.isNotTimeOut()) {
                        HashMap<String, String> hashMap = AdNativeFacebook.this.getEvevtMap();
                        hashMap.put("type_code", "2");
                        hashMap.put("status", String.valueOf(adError.getErrorCode()));
                        EventTrackerHelper.trackthirdEvent(AdNativeFacebook.this.parent, hashMap, true);
                        if (AdNativeFacebook.this.ba != null) {
                            AdNativeFacebook.this.ba.onError(tAdError);
                        }
                    }
                }

                public void onAdLoaded(Ad ad) {
                    if (AdNativeFacebook.this.isNotTimeOut()) {
                        String string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis()));
                        AdLogUtil.Log().d("AdNativeFacebook", string2 + " : facebook nativeAd onAdLoaded");
                        if (ad != null) {
                            AdLogUtil.Log().d("AdNativeFacebook", R.string.request_fb_complete);
                            TAdNativeInfo tAdNativeInfo = PlatformUtil.getTAdNativeInfo(ad);
                            if (!MediaControl.isSensitive(tAdNativeInfo.getTitle()) && !MediaControl.isSensitive(tAdNativeInfo.getDescription())) {
                                HashMap<String, String> hashMap = AdNativeFacebook.this.getEvevtMap();
                                hashMap.put("type_code", "2");
                                hashMap.put("status", "200");
                                EventTrackerHelper.trackthirdEvent(AdNativeFacebook.this.parent, hashMap, true);
                                if (AdNativeFacebook.this.ba != null) {
                                    AdNativeFacebook.this.ba.onAdLoaded(tAdNativeInfo);
                                }
                            } else {
                                HashMap<String, String> hashMap = AdNativeFacebook.this.getEvevtMap();
                                hashMap.put("type_code", "2");
                                hashMap.put("status", String.valueOf(TAdError.SENSITIVE_ERROR.getErrorCode()));
                                EventTrackerHelper.trackthirdEvent(AdNativeFacebook.this.parent, hashMap, true);
                                if (AdNativeFacebook.this.ba != null) {
                                    AdNativeFacebook.this.ba.onError(TAdError.SENSITIVE_ERROR);
                                }
                            }
                        }
                    }
                }

                public void onAdClicked(Ad ad) {
                    String string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis()));
                    AdLogUtil.Log().d("AdNativeFacebook", string2 + " : facebook nativeAd onAdClicked");
                    if (AdNativeFacebook.this.f != null && AdNativeFacebook.this.f.getClkUrlsList() != null) {
                        LogRequest.syncUpdateCLKLogRequest("", AdNativeFacebook.this.f.getClkUrlsList(), AdNativeFacebook.this.f.getCacheNum());
                    }
                    if (AdNativeFacebook.this.ba != null) {
                        AdNativeFacebook.this.ba.onAdClicked();
                    }
                }

                public void onLoggingImpression(Ad ad) {
                }
            });
            AdLogUtil.Log().d("AdNativeFacebook", "facebook nativeAd called loadAd");
            this.startTime = System.currentTimeMillis();
            this.bw.loadAd();
        }
    }

    @Override
    public void registerViewForInteraction(View view, List<View> list, TAdNativeInfo tAdNativeInfo) {
        if (view != null && this.bw != null && this.bw.isAdLoaded()) {
            this.bw.registerViewForInteraction(view, list);
            if (this.f != null && this.f.getImptrackers() != null) {
                LogRequest.syncUpdateLogRequest("", this.f.getImptrackers(), this.f.getCacheNum());
            }
            if (this.ba != null) {
                this.ba.onAdShow();
            }
        }
    }

    @Override
    public void unregisterView() {
        if (this.bw != null) {
            this.bw.unregisterView();
        }
    }

    @Override
    public void unregisterView(TAdNativeInfo tAdNativeInfo) {
        if (this.bw != null) {
            this.bw.destroy();
        }
    }

    @Override
    public boolean isAdAccepted(AdItem adItem) {
        this.f = adItem;
        return this.f != null && this.f.getAdSource() == AdSource.AD_FAN;
    }

    @Override
    public void setPlacementId(String string2) {
        this.r = string2;
    }

    @Override
    public void setAdListener(TAdListener tAdListener) {
        this.ba = tAdListener;
    }

    @Override
    public void destroy() {
        if (this.bw != null) {
            this.bw.destroy();
        }
        if (this.f != null) {
            this.f = null;
        }
        if (this.ba != null) {
            this.ba = null;
        }
        AdLogUtil.Log().d("AdNativeFacebook", "destroy");
    }
}

