/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.zero.iad.core.R;
import com.zero.iad.core.service.CountDownTimer;

public class CountTimeView
extends View
implements View.OnClickListener {
    private Paint dA;
    private Paint dB;
    private long mStartTime = 6L;
    private CountDownTimer dC;
    private int dD;
    private String dE = "5s";
    private CountDownTimerListener dF;
    private Bitmap bitmap;
    private Rect rect = new Rect();

    public CountTimeView(Context context) {
        this(context, null);
    }

    public CountTimeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CountTimeView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setOnClickListener(this);
        this.dD = context.getResources().getDimensionPixelSize(R.dimen.skip_text_size);
        this.M();
    }

    private void M() {
        this.dA = new Paint();
        this.dA.setAntiAlias(true);
        this.dA.setDither(true);
        this.dA.setStyle(Paint.Style.FILL);
        this.dB = new Paint();
        this.dB.setAntiAlias(true);
        this.dB.setColor(-1);
        this.dB.setTextSize((float)this.dD);
        this.dB.setStrokeWidth(8.0f);
        this.dB.setTextAlign(Paint.Align.CENTER);
    }

    public void setStartTime(int n) {
        this.mStartTime = (long)(n * 1000) + 400L;
        this.N();
    }

    public void setCountDownTimerListener(CountDownTimerListener countDownTimerListener) {
        this.dF = countDownTimerListener;
    }

    private void N() {
        this.dC = new CountDownTimer(this.mStartTime, 1000L){

            @Override
            public void onTick(long l) {
                CountTimeView.this.dE = "SKIP " + l / 1000L;
                CountTimeView.this.invalidate();
            }

            @Override
            public void onFinish() {
                if (CountTimeView.this.dF != null) {
                    CountTimeView.this.dF.onFinish();
                }
            }
        };
    }

    public void start() {
        this.dC.start();
        if (this.dF != null) {
            this.dF.onStart();
        }
    }

    public void cancel() {
        if (this.dC != null) {
            this.dC.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.dE)) {
            if (this.bitmap == null) {
                this.bitmap = this.getBg();
            }
            Rect rect = new Rect(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
            canvas.drawBitmap(this.bitmap, rect, rect, this.dA);
            Paint.FontMetrics fontMetrics = this.dB.getFontMetrics();
            int n = (int)((float)(this.rect.bottom + this.rect.top) - fontMetrics.bottom - fontMetrics.top) / 2;
            canvas.drawText(this.dE, (float)this.rect.centerX(), (float)n, this.dB);
        }
    }

    private Bitmap getBg() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.skip_button);
        if (drawable2 instanceof BitmapDrawable) {
            this.bitmap = ((BitmapDrawable)drawable2).getBitmap();
        } else {
            this.bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return this.bitmap;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.rect.set(0, 0, this.getWidth(), this.getHeight());
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void onClick(View view) {
        if (this.dF != null) {
            this.dF.onClick();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.dC.start();
        if (this.dF != null) {
            this.dF.onStart();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.dC != null) {
            this.dC.cancel();
        }
    }

    public static interface CountDownTimerListener {
        public void onStart();

        public void onFinish();

        public void onClick();
    }
}

