/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.config;

import android.os.Build;
import android.text.TextUtils;
import com.zero.iad.core.bean.MediaConfig;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.http.callback.CommonResponseListener;
import com.zero.iad.core.http.request.MediaConfigRequest;
import com.zero.iad.core.http.request.RequestBase;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.PreferencesHelper;

public class MediaControl {
    public static final String AD_FLAG = "ad_flag";
    public static final String SK_KEY_UPDATE_TIME = "config_update_time";

    public static void mediaConfigRequest() {
        AdLogUtil.Log().d("MediaControl", "mediaConfigRequest() be called");
        MediaConfigRequest mediaConfigRequest = (MediaConfigRequest)new MediaConfigRequest().setListener(new CommonResponseListener<MediaConfig>(){

            @Override
            protected void onRequestError(TAdError tAdError) {
                AdLogUtil.Log().e("MediaControl", tAdError.getErrorMessage());
            }

            protected void a(int n, MediaConfig mediaConfig, RequestBase requestBase, String string2) {
                if (mediaConfig != null) {
                    AdLogUtil.Log().d("MediaControl", "MediaConfig is+" + mediaConfig.toString());
                    if (mediaConfig.getSuc() == 1) {
                        PreferencesHelper.getInstance().putLong("config_last_time", System.currentTimeMillis());
                        PreferencesHelper.getInstance().putInt(MediaControl.AD_FLAG, mediaConfig.getAdFlag());
                    }
                    if (mediaConfig.getData() != null) {
                        if (mediaConfig.getData().getAd_config() != null) {
                            PreferencesHelper.getInstance().putInt("fan", mediaConfig.getData().getAd_config().getFan());
                            PreferencesHelper.getInstance().putInt("admob", mediaConfig.getData().getAd_config().getAdmob());
                            PreferencesHelper.getInstance().putInt("self", mediaConfig.getData().getAd_config().getSelf());
                        }
                        if (mediaConfig.getData().getMsg() != null) {
                            for (int i = 0; i < mediaConfig.getData().getMsg().size(); ++i) {
                                MediaConfig.AdMsg adMsg = mediaConfig.getData().getMsg().get(i);
                                if (adMsg == null) continue;
                                if (!TextUtils.isEmpty((CharSequence)adMsg.getItel()) && Build.BRAND.toLowerCase().trim().contains("itel")) {
                                    PreferencesHelper.getInstance().putString("keywords", adMsg.getItel());
                                    return;
                                }
                                if (!TextUtils.isEmpty((CharSequence)adMsg.getInfinix()) && Build.BRAND.toLowerCase().trim().contains("infinix")) {
                                    PreferencesHelper.getInstance().putString("keywords", adMsg.getInfinix());
                                    return;
                                }
                                if (!TextUtils.isEmpty((CharSequence)adMsg.getTecno()) && Build.BRAND.toLowerCase().trim().contains("tecno")) {
                                    PreferencesHelper.getInstance().putString("keywords", adMsg.getTecno());
                                    return;
                                }
                                if (TextUtils.isEmpty((CharSequence)adMsg.getOther())) continue;
                                PreferencesHelper.getInstance().putString("keywords", adMsg.getOther());
                            }
                        }
                    }
                }
            }

            @Override
            protected /* synthetic */ void onRequestSuccess(int n, Object object, RequestBase requestBase, String string2) {
                this.a(n, (MediaConfig)object, requestBase, string2);
            }
        });
        mediaConfigRequest.setParams(mediaConfigRequest.createServerRequestParams());
        mediaConfigRequest.netRequestPreExecute();
    }

    public static boolean isExpires() {
        long l;
        long l2 = PreferencesHelper.getInstance().getLong(SK_KEY_UPDATE_TIME, 60L) * 60L * 1000L;
        long l3 = System.currentTimeMillis();
        return l3 - (l = PreferencesHelper.getInstance().getLong("config_last_time", 0L)) > l2;
    }

    public static boolean isSensitive(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        String string3 = PreferencesHelper.getInstance().getString("keywords", "");
        AdLogUtil.Log().d("MediaControl", "Sensitive keywords is:=" + string3);
        if (string3.length() > 0) {
            String[] stringArray;
            for (String string4 : stringArray = string3.split(",")) {
                if (TextUtils.isEmpty((CharSequence)string4) || !string2.toLowerCase().trim().contains(string4.toLowerCase().trim())) continue;
                AdLogUtil.Log().e("MediaControl", "is sensitive ,word is: " + string4);
                AdLogUtil.Log().e("MediaControl", "is sensitive ,content is: " + string2);
                return true;
            }
        }
        AdLogUtil.Log().d("MediaControl", "sensitive check is pass");
        return false;
    }
}

