/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.platform.admob;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.transsion.core.CoreUtil;
import com.zero.iad.core.R;
import com.zero.iad.core.ad.request.TAdRequest;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.bean.TAdNativeInfo;
import com.zero.iad.core.config.MediaControl;
import com.zero.iad.core.impl.AdmobTadListener;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.PlatformUtil;
import java.util.ArrayList;

public class AdNativeAdmobLoadUtil {
    private AdmobTadListener bl;
    private AdLoader bm;
    private int G = 1;

    public AdNativeAdmobLoadUtil(AdmobTadListener admobTadListener, int n) {
        this.bl = admobTadListener;
        this.G = n;
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(final String string2, @NonNull AdItem adItem, TAdRequest tAdRequest) {
        final ArrayList arrayList = new ArrayList();
        AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "real start load admob ad ,mPlacementId is:=" + string2);
        AdLoader.Builder builder = new AdLoader.Builder(CoreUtil.getContext(), string2);
        builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                if (AdNativeAdmobLoadUtil.this.bm != null) {
                    TAdNativeInfo tAdNativeInfo = PlatformUtil.getTAdNativeInfo(unifiedNativeAd);
                    AdLogUtil.Log().d("AdNativeAdmobLoadUtil", R.string.request_google_native_unified);
                    AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "AdmodAd title : " + tAdNativeInfo.getTitle() + "\nAdmodAd description : " + tAdNativeInfo.getDescription() + " mPlacementId:=" + string2);
                    if (!MediaControl.isSensitive(tAdNativeInfo.getTitle()) && !MediaControl.isSensitive(tAdNativeInfo.getDescription())) {
                        arrayList.add(tAdNativeInfo);
                    }
                    if (!AdNativeAdmobLoadUtil.this.bm.isLoading()) {
                        if (AdNativeAdmobLoadUtil.this.bl != null) {
                            if (!arrayList.isEmpty()) {
                                AdNativeAdmobLoadUtil.this.bl.onAdLoaded(arrayList, string2);
                            } else {
                                AdNativeAdmobLoadUtil.this.bl.onError(TAdError.SENSITIVE_ERROR);
                            }
                        } else {
                            this.q();
                        }
                    }
                } else {
                    AdLogUtil.Log().e("AdNativeAdmobLoadUtil", "adLoader is null");
                    if (arrayList != null && !arrayList.isEmpty()) {
                        this.q();
                    }
                    if (AdNativeAdmobLoadUtil.this.bl != null) {
                        AdNativeAdmobLoadUtil.this.bl.onError(TAdError.ADMOB_ADLOADER_IS_NULL);
                    }
                }
            }

            private void q() {
                if (arrayList != null && !arrayList.isEmpty()) {
                    for (TAdNativeInfo tAdNativeInfo : arrayList) {
                        tAdNativeInfo.onDestroy();
                    }
                    arrayList.clear();
                }
            }
        });
        this.bm = builder.withAdListener(new AdListener(){

            public void onAdFailedToLoad(int n) {
                if (!AdNativeAdmobLoadUtil.this.bm.isLoading()) {
                    if (!arrayList.isEmpty()) {
                        if (AdNativeAdmobLoadUtil.this.bl != null) {
                            AdNativeAdmobLoadUtil.this.bl.onAdLoaded(arrayList, string2);
                        } else if (arrayList != null && !arrayList.isEmpty()) {
                            for (TAdNativeInfo tAdNativeInfo : arrayList) {
                                tAdNativeInfo.onDestroy();
                            }
                            arrayList.clear();
                        }
                    } else if (AdNativeAdmobLoadUtil.this.bl != null) {
                        AdNativeAdmobLoadUtil.this.bl.onError(new TAdError(n, ""), string2);
                    }
                }
            }

            public void onAdLeftApplication() {
                super.onAdLeftApplication();
                if (AdNativeAdmobLoadUtil.this.bl != null) {
                    AdNativeAdmobLoadUtil.this.bl.onAdClicked(string2);
                }
            }
        }).withNativeAdOptions(new NativeAdOptions.Builder().setReturnUrlsForImageAssets(tAdRequest != null && tAdRequest.isUrlsForImage()).build()).build();
        if (this.bm != null && !this.bm.isLoading()) {
            this.bm.loadAds(new AdRequest.Builder().build(), this.G);
        }
    }

    public void destroy() {
        this.bl = null;
        AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "AdNativeAdmobLoadUtil destroy");
    }
}

