/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.service;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.CacheAdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.bean.response.AdBean;
import com.zero.iad.core.bean.response.Response;
import com.zero.iad.core.data.local.AdCacheRepository;
import com.zero.iad.core.http.callback.CommonResponseListener;
import com.zero.iad.core.http.request.AdServerRequest;
import com.zero.iad.core.http.request.RequestBase;
import com.zero.iad.core.impl.TAdListener;
import com.zero.iad.core.stat.EventTracker;
import com.zero.iad.core.stat.EventTrackerImpl;
import com.zero.iad.core.utils.AdImageHelper;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.AdNetUtil;
import com.zero.iad.core.utils.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class SplashAdLoadServer
extends Service {
    private AdServerRequest i;
    private boolean cl = false;
    private long startTime;
    private String placementId;
    private TAdListener cm;
    private EventTracker m = new EventTrackerImpl();
    AdCacheRepository M = new AdCacheRepository();

    public void onCreate() {
        super.onCreate();
        AdLogUtil.Log().d("SplashAdLoadServer", "onCreate");
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        AdLogUtil.Log().d("SplashAdLoadServer", "onStart");
        this.placementId = intent.getStringExtra("placementId");
        if (this.i != null && this.cl) {
            this.i.cancelRequest();
            this.i = null;
        }
        this.m.trackClearEvent();
        this.m.trackSelfSlotId(this.placementId, false);
        this.i = ((AdServerRequest)((AdServerRequest)new AdServerRequest().setListener(new CommonResponseListener<AdBean>(){

            @Override
            public void onRequestStart(String string2) {
                SplashAdLoadServer.this.cl = true;
                AdLogUtil.Log().d("SplashAdLoadServer", "onServerRequestStart");
            }

            protected void a(int n, AdBean adBean, RequestBase requestBase, String string2) {
                SplashAdLoadServer.this.cl = false;
                if (adBean != null && requestBase != null && requestBase instanceof AdServerRequest) {
                    Response response = JsonUtil.parseToResponse(adBean, ((AdServerRequest)requestBase).getRequest());
                    AdLogUtil.Log().d("SplashAdLoadServer", "response = " + response.toString());
                    if (response.getAdItems() != null && response.getAdItems().size() > 0) {
                        AdItem adItem = response.getAdItems().get(0);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("net_type", AdNetUtil.getNetType());
                        hashMap.put("during", String.valueOf(System.currentTimeMillis() - SplashAdLoadServer.this.startTime));
                        hashMap.put("tid", response.getResponse_id());
                        hashMap.put("status", "200");
                        hashMap.put("data_type", ((AdServerRequest)requestBase).isSync() ? "1" : "2");
                        SplashAdLoadServer.this.m.trackSelfEvent(hashMap, true);
                        if (SplashAdLoadServer.this.cm != null) {
                            SplashAdLoadServer.this.cm.selfServeResponse(hashMap);
                        }
                        if (SplashAdLoadServer.this.M != null) {
                            CacheAdItem cacheAdItem = SplashAdLoadServer.this.M.loadCacheAd("ad_cache");
                            if (cacheAdItem != null) {
                                if (SplashAdLoadServer.this.placementId.equals(cacheAdItem.ad.getPlacementId())) {
                                    SplashAdLoadServer.this.c(cacheAdItem.ad);
                                } else {
                                    SplashAdLoadServer.this.c(adItem);
                                }
                            } else {
                                SplashAdLoadServer.this.c(adItem);
                            }
                        }
                    } else {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("net_type", AdNetUtil.getNetType());
                        hashMap.put("during", String.valueOf(System.currentTimeMillis() - SplashAdLoadServer.this.startTime));
                        hashMap.put("status", "1001");
                        SplashAdLoadServer.this.m.trackSelfEvent(hashMap, true);
                        AdLogUtil.Log().d("SplashAdLoadServer", "request new splash ad:no ads");
                        if (SplashAdLoadServer.this.cm != null) {
                            SplashAdLoadServer.this.cm.onError(new TAdError(response.getNbr(), response.getCustomdata()));
                        }
                    }
                }
                SplashAdLoadServer.this.stopSelf();
            }

            @Override
            protected void onRequestError(TAdError tAdError) {
                SplashAdLoadServer.this.cl = false;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("net_type", AdNetUtil.getNetType());
                hashMap.put("during", String.valueOf(System.currentTimeMillis() - SplashAdLoadServer.this.startTime));
                hashMap.put("status", String.valueOf(tAdError.getErrorCode()));
                SplashAdLoadServer.this.m.trackSelfEvent(hashMap, true);
                AdLogUtil.Log().d("SplashAdLoadServer", "request new splash ad error:" + tAdError.toString());
                SplashAdLoadServer.this.stopSelf();
            }

            @Override
            protected /* synthetic */ void onRequestSuccess(int n, Object object, RequestBase requestBase, String string2) {
                this.a(n, (AdBean)object, requestBase, string2);
            }
        })).setPlacementid(this.placementId)).setAd_type(3);
        this.startTime = System.currentTimeMillis();
        this.i.netRequestPreExecute();
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        this.m.trackDestroyEvent();
        AdLogUtil.Log().d("SplashAdLoadServer", "Splash Ad Service onDestroy");
    }

    private void c(final AdItem adItem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = adItem.getMatType();
        if (n == 1) {
            String string2 = adItem.getIurl();
            arrayList.add(string2);
        } else if (n == 3) {
            String string3 = adItem.getIcon().getUrl();
            String string4 = adItem.getImage().getUrl();
            arrayList.add(string3);
            arrayList.add(string4);
        }
        AdImageHelper.preCacheImages(arrayList, new AdImageHelper.ImageListener(){

            @Override
            public void onImagesCached() {
                CacheAdItem cacheAdItem = new CacheAdItem(adItem, true, System.currentTimeMillis());
                SplashAdLoadServer.this.M.addCache("ad_cache", cacheAdItem);
            }

            @Override
            public void onImagesFailedToCache(TAdError tAdError) {
                CacheAdItem cacheAdItem = new CacheAdItem(adItem, false, System.currentTimeMillis());
                SplashAdLoadServer.this.M.addCache("ad_cache", cacheAdItem);
            }
        });
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return new InnerBinder();
    }

    public void setAdListener(TAdListener tAdListener) {
        this.cm = tAdListener;
    }

    public class InnerBinder
    extends Binder {
        public SplashAdLoadServer getService() {
            return SplashAdLoadServer.this;
        }
    }
}

