/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.platform.admob;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.transsion.core.CoreUtil;
import com.zero.iad.core.ad.request.TAdRequest;
import com.zero.iad.core.bean.AdItem;
import com.zero.iad.core.bean.TAdError;
import com.zero.iad.core.bean.TAdNativeInfo;
import com.zero.iad.core.config.MediaControl;
import com.zero.iad.core.impl.AdmobTadListener;
import com.zero.iad.core.utils.AdLogUtil;
import com.zero.iad.core.utils.PlatformUtil;
import java.util.ArrayList;

public class AdNativeAdmobLoadUtil {
    private AdmobTadListener bn;
    private AdLoader bo;
    private int G = 1;

    public AdNativeAdmobLoadUtil(AdmobTadListener admobTadListener, int n) {
        this.bn = admobTadListener;
        this.G = n;
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(final String string2, @NonNull AdItem adItem, TAdRequest tAdRequest) {
        final ArrayList arrayList = new ArrayList();
        AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native \u5f00\u59cb\u52a0\u8f7d, mPlacementId:" + string2);
        AdLoader.Builder builder = new AdLoader.Builder(CoreUtil.getContext(), string2);
        builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                if (AdNativeAdmobLoadUtil.this.bo != null) {
                    AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native \u5f00\u59cb\u6210\u529f");
                    TAdNativeInfo tAdNativeInfo = PlatformUtil.getTAdNativeInfo(unifiedNativeAd);
                    AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native \u5e7f\u544a\u57fa\u672c\u4fe1\u606f\uff0ctitle : " + tAdNativeInfo.getTitle() + "\nAdmodAd description : " + tAdNativeInfo.getDescription() + " mPlacementId:=" + string2);
                    if (!MediaControl.isSensitive(tAdNativeInfo.getTitle()) && !MediaControl.isSensitive(tAdNativeInfo.getDescription())) {
                        arrayList.add(tAdNativeInfo);
                    }
                    AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native \u52a0\u8f7d\u6210\u529f\u5c4f\u853d\u540e\u6761\u6570\uff1a" + arrayList.size());
                    if (!AdNativeAdmobLoadUtil.this.bo.isLoading()) {
                        if (AdNativeAdmobLoadUtil.this.bn != null) {
                            if (!arrayList.isEmpty()) {
                                AdNativeAdmobLoadUtil.this.bn.onAdLoaded(arrayList, string2);
                            } else {
                                AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native \u88ab\u5c4f\u853d");
                                AdNativeAdmobLoadUtil.this.bn.onError(TAdError.SENSITIVE_ERROR);
                            }
                        } else {
                            this.v();
                        }
                    }
                } else {
                    AdLogUtil.Log().e("AdNativeAdmobLoadUtil", "admob native \u5f00\u59cb\u6210\u529f, \u4f46adLoader\u4e3a\u7a7a");
                    if (arrayList != null && !arrayList.isEmpty()) {
                        this.v();
                    }
                    if (AdNativeAdmobLoadUtil.this.bn != null) {
                        AdNativeAdmobLoadUtil.this.bn.onError(TAdError.ADMOB_ADLOADER_IS_NULL);
                    }
                }
            }

            private void v() {
                AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native \u6e05\u7406\u5e7f\u544a\u4fe1\u606f");
                if (arrayList != null && !arrayList.isEmpty()) {
                    for (TAdNativeInfo tAdNativeInfo : arrayList) {
                        tAdNativeInfo.onDestroy();
                    }
                    arrayList.clear();
                }
            }
        });
        this.bo = builder.withAdListener(new AdListener(){

            public void onAdFailedToLoad(int n) {
                AdLogUtil.Log().e("AdNativeAdmobLoadUtil", "admob native \u52a0\u8f7d\u5931\u8d25\uff0cerrorCode:" + n);
                if (!AdNativeAdmobLoadUtil.this.bo.isLoading()) {
                    if (!arrayList.isEmpty()) {
                        if (AdNativeAdmobLoadUtil.this.bn != null) {
                            AdNativeAdmobLoadUtil.this.bn.onAdLoaded(arrayList, string2);
                        } else if (arrayList != null && !arrayList.isEmpty()) {
                            for (TAdNativeInfo tAdNativeInfo : arrayList) {
                                tAdNativeInfo.onDestroy();
                            }
                            arrayList.clear();
                        }
                    } else if (AdNativeAdmobLoadUtil.this.bn != null) {
                        AdNativeAdmobLoadUtil.this.bn.onError(new TAdError(n, ""), string2);
                    }
                }
            }

            public void onAdLeftApplication() {
                super.onAdLeftApplication();
                AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native \u70b9\u51fb");
                if (AdNativeAdmobLoadUtil.this.bn != null) {
                    AdNativeAdmobLoadUtil.this.bn.onAdClicked(string2);
                }
            }
        }).withNativeAdOptions(new NativeAdOptions.Builder().setReturnUrlsForImageAssets(tAdRequest != null && tAdRequest.isUrlsForImage()).build()).build();
        if (this.bo != null && !this.bo.isLoading()) {
            this.bo.loadAds(new AdRequest.Builder().build(), this.G);
        }
    }

    public void destroy() {
        this.bn = null;
        AdLogUtil.Log().d("AdNativeAdmobLoadUtil", "admob native util destroy");
    }
}

