/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.utils.cache;

import com.zero.iad.core.utils.AdLogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DiskLruCache
implements Closeable {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File dg;
    private final File dh;
    private final File di;
    private final int dj;
    private final long dk;
    private final int dl;
    private long size = 0L;
    private Writer dm;
    private final LinkedHashMap<String, a> dn = new LinkedHashMap(0, 0.75f, true);
    private int do;
    private long dp = 0L;
    private final ExecutorService dq = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> dr = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void Q() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.dm == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.N()) {
                    DiskLruCache.this.M();
                    DiskLruCache.this.do = 0;
                }
            }
            return null;
        }

        @Override
        public /* synthetic */ Object call() {
            return this.Q();
        }
    };

    private static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        int n3 = TArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4);
        System.arraycopy(TArray, n, objectArray, 0, n5);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string2 = stringWriter.toString();
            return string2;
        }
        finally {
            reader.close();
        }
    }

    public static String readAsciiLine(InputStream inputStream) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(80);
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new EOFException();
            }
            if (n == 10) break;
            stringBuilder.append((char)n);
        }
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '\r') {
            stringBuilder.setLength(n - 1);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteContents(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            AdLogUtil.Log().d("DiskLruCache", "not a directory: " + file);
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                DiskLruCache.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete file: " + file2);
        }
    }

    private DiskLruCache(File file, int n, int n2, long l) {
        this.dg = file;
        this.dj = n;
        this.dh = new File(file, "journal");
        this.di = new File(file, "journal.tmp");
        this.dl = n2;
        this.dk = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        DiskLruCache diskLruCache = new DiskLruCache(file, n, n2, l);
        if (diskLruCache.dh.exists()) {
            try {
                diskLruCache.K();
                diskLruCache.L();
                diskLruCache.dm = new BufferedWriter(new FileWriter(diskLruCache.dh, true), 8192);
                return diskLruCache;
            }
            catch (IOException iOException) {
                diskLruCache.delete();
            }
        }
        file.mkdirs();
        diskLruCache = new DiskLruCache(file, n, n2, l);
        diskLruCache.M();
        return diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void K() {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.dh), 8192);
        try {
            String string2 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string3 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string4 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string5 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string6 = DiskLruCache.readAsciiLine(bufferedInputStream);
            if (!("libcore.io.DiskLruCache".equals(string2) && "1".equals(string3) && Integer.toString(this.dj).equals(string4) && Integer.toString(this.dl).equals(string5) && "".equals(string6))) {
                throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            }
            try {
                while (true) {
                    this.g(DiskLruCache.readAsciiLine(bufferedInputStream));
                }
            }
            catch (EOFException eOFException) {
                DiskLruCache.closeQuietly(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            DiskLruCache.closeQuietly(bufferedInputStream);
            throw throwable;
        }
    }

    private void g(String string2) {
        String[] stringArray = string2.split(" ");
        if (stringArray.length < 2) {
            throw new IOException("unexpected journal line: " + string2);
        }
        String string3 = stringArray[1];
        if (stringArray[0].equals("REMOVE") && stringArray.length == 2) {
            this.dn.remove(string3);
            return;
        }
        a a2 = this.dn.get(string3);
        if (a2 == null) {
            a2 = new a(string3);
            this.dn.put(string3, a2);
        }
        if (stringArray[0].equals("CLEAN") && stringArray.length == 2 + this.dl) {
            a2.dx = true;
            a2.dy = null;
            a2.a(DiskLruCache.copyOfRange(stringArray, 2, stringArray.length));
        } else if (stringArray[0].equals("DIRTY") && stringArray.length == 2) {
            a2.dy = new Editor(a2);
        } else if (!stringArray[0].equals("READ") || stringArray.length != 2) {
            throw new IOException("unexpected journal line: " + string2);
        }
    }

    private void L() {
        DiskLruCache.a(this.di);
        Iterator<a> iterator = this.dn.values().iterator();
        while (iterator.hasNext()) {
            int n;
            a a2 = iterator.next();
            if (a2.dy == null) {
                for (n = 0; n < this.dl; ++n) {
                    this.size += a2.dw[n];
                }
                continue;
            }
            a2.dy = null;
            for (n = 0; n < this.dl; ++n) {
                DiskLruCache.a(a2.h(n));
                DiskLruCache.a(a2.i(n));
            }
            iterator.remove();
        }
    }

    private synchronized void M() {
        if (this.dm != null) {
            this.dm.close();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.di), 8192);
        bufferedWriter.write("libcore.io.DiskLruCache");
        bufferedWriter.write("\n");
        bufferedWriter.write("1");
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.dj));
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.dl));
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        for (a a2 : this.dn.values()) {
            if (a2.dy != null) {
                bufferedWriter.write("DIRTY " + a2.key + '\n');
                continue;
            }
            bufferedWriter.write("CLEAN " + a2.key + a2.R() + '\n');
        }
        ((Writer)bufferedWriter).close();
        this.di.renameTo(this.dh);
        this.dm = new BufferedWriter(new FileWriter(this.dh, true), 8192);
    }

    private static void a(File file) {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public synchronized Snapshot get(String string2) {
        this.O();
        this.h(string2);
        a a2 = this.dn.get(string2);
        if (a2 == null) {
            return null;
        }
        if (!a2.dx) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.dl];
        try {
            for (int i = 0; i < this.dl; ++i) {
                inputStreamArray[i] = new FileInputStream(a2.h(i));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        ++this.do;
        this.dm.append("READ " + string2 + '\n');
        if (this.N()) {
            this.dq.submit(this.dr);
        }
        return new Snapshot(string2, a2.dz, inputStreamArray);
    }

    public Editor edit(String string2) {
        return this.a(string2, -1L);
    }

    private synchronized Editor a(String string2, long l) {
        this.O();
        this.h(string2);
        a a2 = this.dn.get(string2);
        if (l != -1L && (a2 == null || a2.dz != l)) {
            return null;
        }
        if (a2 == null) {
            a2 = new a(string2);
            this.dn.put(string2, a2);
        } else if (a2.dy != null) {
            return null;
        }
        Editor editor = new Editor(a2);
        a2.dy = editor;
        this.dm.write("DIRTY " + string2 + '\n');
        this.dm.flush();
        return editor;
    }

    public File getDirectory() {
        return this.dg;
    }

    public long maxSize() {
        return this.dk;
    }

    public synchronized long size() {
        return this.size;
    }

    private synchronized void a(Editor editor, boolean bl) {
        int n;
        a a2 = editor.dt;
        if (a2.dy != editor) {
            throw new IllegalStateException();
        }
        if (bl && !a2.dx) {
            for (n = 0; n < this.dl; ++n) {
                if (a2.i(n).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n = 0; n < this.dl; ++n) {
            File file = a2.i(n);
            if (bl) {
                long l;
                if (!file.exists()) continue;
                File file2 = a2.h(n);
                file.renameTo(file2);
                long l2 = a2.dw[n];
                ((a)a2).dw[n] = l = file2.length();
                this.size = this.size - l2 + l;
                continue;
            }
            DiskLruCache.a(file);
        }
        ++this.do;
        a2.dy = null;
        if (a2.dx | bl) {
            a2.dx = true;
            this.dm.write("CLEAN " + a2.key + a2.R() + '\n');
            if (bl) {
                a2.dz = this.dp++;
            }
        } else {
            this.dn.remove(a2.key);
            this.dm.write("REMOVE " + a2.key + '\n');
        }
        if (this.size > this.dk || this.N()) {
            this.dq.submit(this.dr);
        }
    }

    private boolean N() {
        int n = 2000;
        return this.do >= 2000 && this.do >= this.dn.size();
    }

    public synchronized boolean remove(String string2) {
        this.O();
        this.h(string2);
        a a2 = this.dn.get(string2);
        if (a2 == null || a2.dy != null) {
            return false;
        }
        for (int i = 0; i < this.dl; ++i) {
            File file = a2.h(i);
            if (!file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.size -= a2.dw[i];
            ((a)a2).dw[i] = 0L;
        }
        ++this.do;
        this.dm.append("REMOVE " + string2 + '\n');
        this.dn.remove(string2);
        if (this.N()) {
            this.dq.submit(this.dr);
        }
        return true;
    }

    public boolean isClosed() {
        return this.dm == null;
    }

    private void O() {
        if (this.dm == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() {
        this.O();
        this.trimToSize();
        this.dm.flush();
    }

    @Override
    public synchronized void close() {
        if (this.dm == null) {
            return;
        }
        for (a a2 : new ArrayList<a>(this.dn.values())) {
            if (a2.dy == null) continue;
            a2.dy.abort();
        }
        this.trimToSize();
        this.dm.close();
        this.dm = null;
    }

    private void trimToSize() {
        while (this.size > this.dk) {
            Map.Entry<String, a> entry = this.dn.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() {
        this.close();
        DiskLruCache.deleteContents(this.dg);
    }

    private void h(String string2) {
        if (string2.contains(" ") || string2.contains("\n") || string2.contains("\r")) {
            throw new IllegalArgumentException("keys must not contain spaces or newlines: \"" + string2 + "\"");
        }
    }

    private static String a(InputStream inputStream) {
        return DiskLruCache.readFully(new InputStreamReader(inputStream, UTF_8));
    }

    private final class a {
        private final String key;
        private final long[] dw;
        private boolean dx;
        private Editor dy;
        private long dz;

        private a(String string2) {
            this.key = string2;
            this.dw = new long[DiskLruCache.this.dl];
        }

        public String R() {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : this.dw) {
                stringBuilder.append(' ').append(l);
            }
            return stringBuilder.toString();
        }

        private void a(String[] stringArray) {
            if (stringArray.length != DiskLruCache.this.dl) {
                throw this.b(stringArray);
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.dw[i] = Long.parseLong(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.b(stringArray);
            }
        }

        private IOException b(String[] stringArray) {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File h(int n) {
            return new File(DiskLruCache.this.dg, this.key + "." + n);
        }

        public File i(int n) {
            return new File(DiskLruCache.this.dg, this.key + "." + n + ".tmp");
        }
    }

    public final class Editor {
        private final com.zero.iad.core.utils.cache.DiskLruCache$a dt;
        private boolean du;

        private Editor(com.zero.iad.core.utils.cache.DiskLruCache$a a2) {
            this.dt = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.dt.dy != this) {
                    throw new IllegalStateException();
                }
                if (!this.dt.dx) {
                    return null;
                }
                return new FileInputStream(this.dt.h(n));
            }
        }

        public String getString(int n) {
            InputStream inputStream = this.newInputStream(n);
            return inputStream != null ? DiskLruCache.a(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.dt.dy != this) {
                    throw new IllegalStateException();
                }
                return new a(new FileOutputStream(this.dt.i(n)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n, String string2) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n), UTF_8);
                outputStreamWriter.write(string2);
            }
            catch (Throwable throwable) {
                DiskLruCache.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            DiskLruCache.closeQuietly(outputStreamWriter);
        }

        public void commit() {
            if (this.du) {
                DiskLruCache.this.a(this, false);
                DiskLruCache.this.remove(this.dt.key);
            } else {
                DiskLruCache.this.a(this, true);
            }
        }

        public void abort() {
            DiskLruCache.this.a(this, false);
        }

        private class a
        extends FilterOutputStream {
            private a(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                }
                catch (IOException iOException) {
                    Editor.this.du = true;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    Editor.this.du = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    Editor.this.du = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    Editor.this.du = true;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long dz;
        private final InputStream[] dA;

        private Snapshot(String string2, long l, InputStream[] inputStreamArray) {
            this.key = string2;
            this.dz = l;
            this.dA = inputStreamArray;
        }

        public Editor edit() {
            return DiskLruCache.this.a(this.key, this.dz);
        }

        public InputStream getInputStream(int n) {
            return this.dA[n];
        }

        public String getString(int n) {
            return DiskLruCache.a(this.getInputStream(n));
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.dA) {
                DiskLruCache.closeQuietly(inputStream);
            }
        }
    }
}

