/*
 * Decompiled with CFR 0.152.
 */
package com.zero.iad.core.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.zero.iad.core.R;
import com.zero.iad.core.service.CountDownTimer;

public class CountTimeView
extends View
implements View.OnClickListener {
    private Paint dB;
    private Paint dC;
    private long mStartTime = 6L;
    private CountDownTimer dD;
    private int dE;
    private String dF = "5s";
    private CountDownTimerListener dG;
    private Bitmap bitmap;
    private Rect rect = new Rect();

    public CountTimeView(Context context) {
        this(context, null);
    }

    public CountTimeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CountTimeView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setOnClickListener(this);
        this.dE = context.getResources().getDimensionPixelSize(R.dimen.skip_text_size);
        this.S();
    }

    private void S() {
        this.dB = new Paint();
        this.dB.setAntiAlias(true);
        this.dB.setDither(true);
        this.dB.setStyle(Paint.Style.FILL);
        this.dC = new Paint();
        this.dC.setAntiAlias(true);
        this.dC.setColor(-1);
        this.dC.setTextSize((float)this.dE);
        this.dC.setStrokeWidth(8.0f);
        this.dC.setTextAlign(Paint.Align.CENTER);
    }

    public void setStartTime(int n) {
        this.mStartTime = (long)(n * 1000) + 400L;
        this.T();
    }

    public void setCountDownTimerListener(CountDownTimerListener countDownTimerListener) {
        this.dG = countDownTimerListener;
    }

    private void T() {
        this.dD = new CountDownTimer(this.mStartTime, 1000L){

            @Override
            public void onTick(long l) {
                CountTimeView.this.dF = "SKIP " + l / 1000L;
                CountTimeView.this.invalidate();
            }

            @Override
            public void onFinish() {
                if (CountTimeView.this.dG != null) {
                    CountTimeView.this.dG.onFinish();
                }
            }
        };
    }

    public void start() {
        this.dD.start();
        if (this.dG != null) {
            this.dG.onStart();
        }
    }

    public void cancel() {
        if (this.dD != null) {
            this.dD.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.dF)) {
            if (this.bitmap == null) {
                this.bitmap = this.getBg();
            }
            Rect rect = new Rect(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
            canvas.drawBitmap(this.bitmap, rect, rect, this.dB);
            Paint.FontMetrics fontMetrics = this.dC.getFontMetrics();
            int n = (int)((float)(this.rect.bottom + this.rect.top) - fontMetrics.bottom - fontMetrics.top) / 2;
            canvas.drawText(this.dF, (float)this.rect.centerX(), (float)n, this.dC);
        }
    }

    private Bitmap getBg() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.skip_button);
        if (drawable2 instanceof BitmapDrawable) {
            this.bitmap = ((BitmapDrawable)drawable2).getBitmap();
        } else {
            this.bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return this.bitmap;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.rect.set(0, 0, this.getWidth(), this.getHeight());
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void onClick(View view) {
        if (this.dG != null) {
            this.dG.onClick();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.dD.start();
        if (this.dG != null) {
            this.dG.onStart();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.dD != null) {
            this.dD.cancel();
        }
    }

    public static interface CountDownTimerListener {
        public void onStart();

        public void onFinish();

        public void onClick();
    }
}

