/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.ad;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.transsion.core.utils.NetUtil;
import com.zero.adx.R;
import com.zero.adx.ad.request.TAdRequest;
import com.zero.adx.bean.request.ImpBean;
import com.zero.adx.bean.response.AdBean;
import com.zero.adx.bean.response.AdResponseBody;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.event.AdxEventTracker;
import com.zero.adx.event.AthenaTracker;
import com.zero.adx.http.callback.CommonResponseListener;
import com.zero.adx.http.request.AdServerRequest;
import com.zero.adx.impl.IAd;
import com.zero.adx.impl.TAdListener;
import com.zero.adx.platform.AdxBannerGemini;
import com.zero.adx.platform.PlatformUtil;
import com.zero.adx.util.AdLogUtil;
import com.zero.adx.util.MitNetUtil;
import com.zero.adx.util.RunTimer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class TAdBannerView
extends RelativeLayout
implements IAd {
    private static final String TAG = "TAdBannerView";
    private String mSelfPlacementId = "";
    private int mAdBannerSize = 0;
    private TAdRequest tAdRequest = new TAdRequest.TAdRequestBuild().build();
    private AdServerRequest adServerRequest;
    private boolean isSetedWH = false;
    private RunTimer runTimer = new RunTimer();
    private boolean isTimeout = false;
    private int width;
    private int height;
    AdxBannerGemini mBannerPlatform = null;
    private Long startTime = 0L;
    private AdBean mAdBean = null;
    private int BANNER_MAX_REFRESH_TIME = 120;
    private BannerLoopHandler mBannerLoopHandler = new BannerLoopHandler(this);
    private TAdListener mBannerListener = new TAdListener(){

        @Override
        public void onAdLoaded() {
            if (TAdBannerView.this.isTimeout) {
                AdLogUtil.Log().e(TAdBannerView.TAG, "Request time out");
                return;
            }
            if (TAdBannerView.this.runTimer != null) {
                TAdBannerView.this.runTimer.resetTimerTask();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdBannerView.this.mSelfPlacementId);
            hashMap.put("ad_type", "1");
            AthenaTracker.getInstance().fill(hashMap);
            TAdBannerView.this.showAd();
            if (TAdBannerView.this.tAdRequest != null && TAdBannerView.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdBannerView.TAG, "onAdLoaded");
                TAdBannerView.this.tAdRequest.getListener().onAdLoaded();
            }
        }

        @Override
        public void onError(TAdErrorCode tAdErrorCode) {
            if (TAdBannerView.this.isTimeout) {
                AdLogUtil.Log().e(TAdBannerView.TAG, "Request time out");
                return;
            }
            if (TAdBannerView.this.runTimer != null) {
                TAdBannerView.this.runTimer.resetTimerTask();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdBannerView.this.mSelfPlacementId);
            hashMap.put("during", System.currentTimeMillis() - TAdBannerView.this.startTime + "");
            hashMap.put("ad_type", "1");
            hashMap.put("result", "0");
            hashMap.put("reason", tAdErrorCode.getErrorCode() + "");
            AthenaTracker.getInstance().loadResult(hashMap);
            if (TAdBannerView.this.tAdRequest != null && TAdBannerView.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().e(TAdBannerView.TAG, "adError\uff1a=" + tAdErrorCode.getErrorMessage());
                TAdBannerView.this.tAdRequest.getListener().onError(tAdErrorCode);
            }
        }

        @Override
        public void onAdClicked() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdBannerView.this.mSelfPlacementId);
            hashMap.put("net_type", MitNetUtil.getNetType() + "");
            hashMap.put("ad_type", "1");
            AthenaTracker.getInstance().click(hashMap);
            TAdBannerView.this.clickAd();
            if (TAdBannerView.this.tAdRequest != null && TAdBannerView.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdBannerView.TAG, "onAdClicked");
                TAdBannerView.this.tAdRequest.getListener().onAdClicked();
            }
        }

        @Override
        public void onAdClosed() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdBannerView.this.mSelfPlacementId);
            hashMap.put("ad_type", "1");
            AthenaTracker.getInstance().close(hashMap);
            if (TAdBannerView.this.tAdRequest != null && TAdBannerView.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdBannerView.TAG, "onAdClosed");
                TAdBannerView.this.tAdRequest.getListener().onAdClosed();
            }
        }

        @Override
        public void onAdShow() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdBannerView.this.mSelfPlacementId);
            hashMap.put("net_type", MitNetUtil.getNetType() + "");
            hashMap.put("ad_type", "1");
            AthenaTracker.getInstance().impression(hashMap);
            if (TAdBannerView.this.tAdRequest != null && TAdBannerView.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdBannerView.TAG, "onAdShow");
                TAdBannerView.this.tAdRequest.getListener().onAdShow();
            }
        }

        @Override
        public void onTimeOut() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdBannerView.this.mSelfPlacementId);
            hashMap.put("during", System.currentTimeMillis() - TAdBannerView.this.startTime + "");
            hashMap.put("ad_type", "1");
            hashMap.put("result", "0");
            hashMap.put("reason", "9007");
            AthenaTracker.getInstance().loadResult(hashMap);
            if (TAdBannerView.this.tAdRequest != null && TAdBannerView.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().e(TAdBannerView.TAG, "onTimeOut");
                TAdBannerView.this.tAdRequest.getListener().onTimeOut();
            }
        }
    };
    private RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        @Override
        public void isTimeOut() {
            TAdBannerView.this.isTimeout = true;
            if (TAdBannerView.this.mBannerListener != null) {
                TAdBannerView.this.mBannerListener.onTimeOut();
            }
        }
    };

    public TAdBannerView(Context context, String string) {
        this(context, null, 0);
        this.mSelfPlacementId = string;
        AdLogUtil.Log().d(TAG, "placementId=" + string);
    }

    public TAdBannerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TAdBannerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TAdBannerView);
        for (int i = 0; i < typedArray.getIndexCount(); ++i) {
            int n2 = typedArray.getIndex(i);
            if (n2 != R.styleable.TAdBannerView_placementId) continue;
            this.mSelfPlacementId = typedArray.getString(n2);
        }
        if (typedArray.getIndexCount() > 0) {
            AdLogUtil.Log().d(TAG, "placementId=" + this.mSelfPlacementId + ",bannerSize=" + this.mAdBannerSize);
        }
        typedArray.recycle();
    }

    public void setPlacementId(String string) {
        this.mSelfPlacementId = string;
    }

    @Deprecated
    public void setBannerWH(boolean bl, int n, int n2) {
        this.isSetedWH = bl;
        this.width = n;
        this.height = n2;
    }

    @Deprecated
    public void setAdBannerSize(int n) {
        this.mAdBannerSize = n;
    }

    @Override
    public void setAdRequest(@NonNull TAdRequest tAdRequest) {
        this.tAdRequest = tAdRequest;
    }

    @Override
    public TAdRequest getAdRequest() {
        return this.tAdRequest;
    }

    @Override
    public void loadAd() {
        if (!NetUtil.checkNetworkState()) {
            if (this.mBannerListener != null) {
                this.mBannerListener.onError(TAdErrorCode.NETWORK_ERROR);
            }
            return;
        }
        AdLogUtil.Log().d(TAG, "start load ad...");
        ArrayList<ImpBean> arrayList = new ArrayList<ImpBean>();
        ImpBean impBean = new ImpBean();
        impBean.setId(1);
        impBean.setAdt(1);
        impBean.setPmid(this.mSelfPlacementId);
        arrayList.add(impBean);
        this.reset();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sdk_v", "1.1.5.5");
        hashMap.put("net_type", MitNetUtil.getNetType() + "");
        hashMap.put("pid", this.mSelfPlacementId);
        hashMap.put("ad_type", "1");
        AthenaTracker.getInstance().load(hashMap);
        this.adServerRequest = ((AdServerRequest)((AdServerRequest)new AdServerRequest().setPlacementid(this.mSelfPlacementId)).setListener(new CommonResponseListener<AdResponseBody>(){

            @Override
            protected void onRequestSuccess(int n, AdResponseBody adResponseBody) {
                if (TAdBannerView.this.isTimeout()) {
                    return;
                }
                if (adResponseBody != null && adResponseBody.getCode() == 0) {
                    AdLogUtil.Log().d(TAdBannerView.TAG, "got data from net, response is :" + adResponseBody.toString());
                    if (adResponseBody.getAds() != null && adResponseBody.getAds().size() > 0) {
                        TAdBannerView.this.mAdBean = adResponseBody.getAds().get(0);
                        TAdBannerView.this.mAdBean.setRid(adResponseBody.getRid());
                        if (!TAdBannerView.this.mAdBean.getPmid().equals(TAdBannerView.this.mSelfPlacementId)) {
                            AdLogUtil.Log().e(TAdBannerView.TAG, "request's pmid is diffrent with response's");
                            if (TAdBannerView.this.mBannerListener != null) {
                                TAdBannerView.this.mBannerListener.onError(TAdErrorCode.RESPONSE_PMID_DIFFRENT_ERROR);
                            }
                            return;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("sdk_v", "1.1.5.5");
                        hashMap.put("pid", TAdBannerView.this.mSelfPlacementId);
                        hashMap.put("during", System.currentTimeMillis() - TAdBannerView.this.startTime + "");
                        hashMap.put("ad_type", "1");
                        hashMap.put("result", "1");
                        hashMap.put("reason", "");
                        AthenaTracker.getInstance().loadResult(hashMap);
                        TAdBannerView.this.loadPlatformAd();
                    } else {
                        AdLogUtil.Log().w(TAdBannerView.TAG, "a ds list is empty");
                        if (TAdBannerView.this.mBannerListener != null) {
                            TAdBannerView.this.mBannerListener.onError(TAdErrorCode.RESPONSE_AD_IS_EMPTY);
                        }
                    }
                } else {
                    AdLogUtil.Log().w(TAdBannerView.TAG, adResponseBody != null ? "error,response code is :" + adResponseBody.getCode() + ",response msg is " + adResponseBody.getMsg() : "error, response is null");
                    if (TAdBannerView.this.mBannerListener != null) {
                        if (adResponseBody != null) {
                            TAdBannerView.this.mBannerListener.onError(new TAdErrorCode(adResponseBody.getCode(), adResponseBody.getMsg()));
                        } else {
                            TAdBannerView.this.mBannerListener.onError(new TAdErrorCode(10000, "response is null"));
                        }
                    }
                }
            }

            @Override
            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                if (TAdBannerView.this.isTimeout()) {
                    return;
                }
                if (TAdBannerView.this.mBannerListener != null) {
                    TAdBannerView.this.mBannerListener.onError(tAdErrorCode);
                }
            }
        })).setImpList(arrayList).setAd_type(1);
        this.startTime = System.currentTimeMillis();
        this.adServerRequest.netRequestPreExecute();
        this.runTimerTask();
    }

    private void loadPlatformAd() {
        this.reset();
        this.mBannerPlatform = new AdxBannerGemini();
        this.mBannerPlatform.setAdListener(this.mBannerListener);
        this.mBannerPlatform.setAdBean(this.mAdBean);
        try {
            View view = this.mBannerPlatform.getBannerView(this.getContext());
            AdLogUtil.Log().d(TAG, "start load ad");
            if (view != null) {
                if (this.isSetedWH) {
                    this.addView(view, this.width, this.height);
                    this.setVisibility(0);
                } else {
                    this.addView(view, -1, -1);
                    this.setVisibility(0);
                }
                return;
            }
            AdLogUtil.Log().e(TAG, "no ad show, set visible gone");
            this.setVisibility(8);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(TAG, exception.getMessage());
        }
    }

    private void showAd() {
        if (this.mAdBean.getRefresh() > 0) {
            AdLogUtil.Log().d(TAG, "send loop message,interval is :" + this.mAdBean.getRefresh());
            this.mBannerLoopHandler.sendEmptyMessageDelayed(1, this.mAdBean.getRefresh() * 1000);
        }
        if (this.mBannerPlatform != null) {
            if (this.mBannerListener != null) {
                AdLogUtil.Log().d(TAG, "Request onAdShow");
                this.mBannerListener.onAdShow();
            }
            AdLogUtil.Log().d(TAG, "ad banner show...");
            AdxEventTracker.getInstance().adShow(this.mAdBean);
            if (this.mAdBean != null && this.mAdBean.getImptk() != null && this.mAdBean.getImptk().size() > 0) {
                for (String string : this.mAdBean.getImptk()) {
                    AdxEventTracker.getInstance().reportToThirdUrl("imp_result", this.mSelfPlacementId, 1, string);
                }
            }
        }
    }

    private void clickAd() {
        this.clickToLandingPage(this.getContext(), this.mAdBean);
        AdxEventTracker.getInstance().adClick(this.mAdBean);
        if (this.mAdBean != null && this.mAdBean.getClktk() != null && this.mAdBean.getClktk().size() > 0) {
            for (String string : this.mAdBean.getClktk()) {
                AdxEventTracker.getInstance().reportToThirdUrl("click_result", this.mSelfPlacementId, 1, string);
            }
        }
    }

    private void clickToLandingPage(Context context, AdBean adBean) {
        if (adBean != null && context != null) {
            PlatformUtil.startActivity(context, adBean);
        } else {
            AdLogUtil.Log().e(TAG, "both deeplink and landpage is empty");
        }
    }

    @Override
    public void runTimerTask() {
        if (this.tAdRequest != null && this.runTimer != null) {
            int n = this.tAdRequest.getScheduleTime();
            this.isTimeout = false;
            this.runTimer.resetTimerTask();
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
            this.runTimer.setScheduleTime(n);
            this.runTimer.runTimerTask();
        }
    }

    @Override
    public boolean isTimeout() {
        return this.isTimeout;
    }

    private void reset() {
        if (this.adServerRequest != null) {
            AdLogUtil.Log().d(TAG, "Called TAdBannerView more than once. Auto reset request.");
            this.adServerRequest.cancelRequest();
            this.adServerRequest = null;
        }
        if (this.mBannerLoopHandler != null) {
            AdLogUtil.Log().d(TAG, "Called TAdBannerView more than once. clear bannerLoopHandler");
            this.mBannerLoopHandler.removeCallbacksAndMessages(null);
        }
        this.removeAllViews();
        if (this.mBannerPlatform != null) {
            this.mBannerPlatform.destroy();
            this.mBannerPlatform = null;
        }
        AdLogUtil.Log().d(TAG, "reset");
    }

    @Override
    public String getPlacementId() {
        return this.mSelfPlacementId;
    }

    @Override
    public void destroy() {
        this.reset();
        this.timeOutCallback = null;
        if (this.tAdRequest != null) {
            this.tAdRequest = null;
        }
        if (this.mBannerListener != null) {
            this.mBannerListener = null;
        }
        if (this.runTimer != null) {
            this.runTimer.resetTimerTask();
            this.runTimer = null;
        }
        if (this.adServerRequest != null) {
            this.adServerRequest.cancelRequest();
            this.adServerRequest = null;
        }
        if (this.mBannerLoopHandler != null) {
            this.mBannerLoopHandler.removeCallbacksAndMessages(null);
            this.mBannerLoopHandler = null;
        }
        AdLogUtil.Log().d(TAG, "TAdBannerView destroy");
    }

    static class BannerLoopHandler
    extends Handler {
        WeakReference<TAdBannerView> mBannerView;

        BannerLoopHandler(TAdBannerView tAdBannerView) {
            this.mBannerView = new WeakReference<TAdBannerView>(tAdBannerView);
        }

        public void handleMessage(Message message) {
            if (this.mBannerView == null) {
                return;
            }
            TAdBannerView tAdBannerView = (TAdBannerView)this.mBannerView.get();
            if (tAdBannerView != null) {
                AdLogUtil.Log().d(TAdBannerView.TAG, "start banner loop...");
                tAdBannerView.loadAd();
            }
        }
    }
}

