/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.ad;

import android.content.Context;
import android.support.annotation.NonNull;
import com.transsion.core.utils.NetUtil;
import com.zero.adx.ad.request.TAdRequest;
import com.zero.adx.bean.request.ImpBean;
import com.zero.adx.bean.response.AdBean;
import com.zero.adx.bean.response.AdResponseBody;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.event.AthenaTracker;
import com.zero.adx.http.callback.CommonResponseListener;
import com.zero.adx.http.request.AdServerRequest;
import com.zero.adx.impl.IAd;
import com.zero.adx.impl.TAdListener;
import com.zero.adx.platform.AdxInterstitialGemini;
import com.zero.adx.util.AdLogUtil;
import com.zero.adx.util.MitNetUtil;
import com.zero.adx.util.RunTimer;
import java.util.ArrayList;
import java.util.HashMap;

public class TAdInterstitial
implements IAd {
    private static final String TAG = "TAdInterstitial";
    private Context mContext;
    private String mSelfPlacementId = "";
    private AdxInterstitialGemini platform;
    private AdServerRequest adServerRequest;
    private TAdRequest tAdRequest = new TAdRequest.TAdRequestBuild().build();
    private RunTimer runTimer = new RunTimer();
    private boolean isTimeout = false;
    private Long startTime = 0L;
    private AdBean mAdBean;
    private TAdListener mIntersListener = new TAdListener(){

        @Override
        public void onAdLoaded() {
            if (TAdInterstitial.this.isTimeout) {
                AdLogUtil.Log().d(TAdInterstitial.TAG, "Request time out");
                return;
            }
            if (TAdInterstitial.this.runTimer != null) {
                TAdInterstitial.this.runTimer.resetTimerTask();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdInterstitial.this.mSelfPlacementId);
            hashMap.put("ad_type", "2");
            AthenaTracker.getInstance().fill(hashMap);
            if (TAdInterstitial.this.tAdRequest != null && TAdInterstitial.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdInterstitial.TAG, "onAdLoaded");
                TAdInterstitial.this.tAdRequest.getListener().onAdLoaded();
            }
            if (TAdInterstitial.this.tAdRequest != null && !TAdInterstitial.this.tAdRequest.isShowByApk()) {
                TAdInterstitial.this.show();
            }
        }

        @Override
        public void onError(TAdErrorCode tAdErrorCode) {
            if (TAdInterstitial.this.isTimeout) {
                AdLogUtil.Log().e(TAdInterstitial.TAG, "Request time out");
                return;
            }
            if (TAdInterstitial.this.runTimer != null) {
                TAdInterstitial.this.runTimer.resetTimerTask();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdInterstitial.this.mSelfPlacementId);
            hashMap.put("during", System.currentTimeMillis() - TAdInterstitial.this.startTime + "");
            hashMap.put("ad_type", "2");
            hashMap.put("result", "0");
            hashMap.put("reason", tAdErrorCode.getErrorCode() + "");
            AthenaTracker.getInstance().loadResult(hashMap);
            if (TAdInterstitial.this.tAdRequest != null && TAdInterstitial.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().e(TAdInterstitial.TAG, "onError");
                TAdInterstitial.this.tAdRequest.getListener().onError(tAdErrorCode);
            }
        }

        @Override
        public void onAdClicked() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdInterstitial.this.mSelfPlacementId);
            hashMap.put("net_type", MitNetUtil.getNetType() + "");
            hashMap.put("ad_type", "2");
            AthenaTracker.getInstance().click(hashMap);
            if (TAdInterstitial.this.tAdRequest != null && TAdInterstitial.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdInterstitial.TAG, "onAdClicked");
                TAdInterstitial.this.tAdRequest.getListener().onAdClicked();
            }
        }

        @Override
        public void onAdClosed() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdInterstitial.this.mSelfPlacementId);
            hashMap.put("ad_type", "2");
            AthenaTracker.getInstance().close(hashMap);
            if (TAdInterstitial.this.tAdRequest != null && TAdInterstitial.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdInterstitial.TAG, "onAdClosed");
                TAdInterstitial.this.tAdRequest.getListener().onAdClosed();
            }
        }

        @Override
        public void onAdShow() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdInterstitial.this.mSelfPlacementId);
            hashMap.put("net_type", MitNetUtil.getNetType() + "");
            hashMap.put("ad_type", "2");
            AthenaTracker.getInstance().impression(hashMap);
            if (TAdInterstitial.this.tAdRequest != null && TAdInterstitial.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdInterstitial.TAG, "onAdShow");
                TAdInterstitial.this.tAdRequest.getListener().onAdShow();
            }
        }

        @Override
        public void onTimeOut() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdInterstitial.this.mSelfPlacementId);
            hashMap.put("during", System.currentTimeMillis() - TAdInterstitial.this.startTime + "");
            hashMap.put("ad_type", "2");
            hashMap.put("result", "0");
            hashMap.put("reason", "9007");
            AthenaTracker.getInstance().loadResult(hashMap);
            if (TAdInterstitial.this.tAdRequest != null && TAdInterstitial.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().e(TAdInterstitial.TAG, "onTimeOut");
                TAdInterstitial.this.tAdRequest.getListener().onTimeOut();
            }
        }
    };
    RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        @Override
        public void isTimeOut() {
            TAdInterstitial.this.isTimeout = true;
            if (TAdInterstitial.this.mIntersListener != null) {
                TAdInterstitial.this.mIntersListener.onTimeOut();
            }
        }
    };

    public TAdInterstitial(Context context) {
        this.mContext = context;
    }

    public TAdInterstitial(Context context, String string) {
        this.mSelfPlacementId = string;
        this.mContext = context;
    }

    public void setPlacementId(String string) {
        this.mSelfPlacementId = string;
    }

    @Override
    public void setAdRequest(@NonNull TAdRequest tAdRequest) {
        this.tAdRequest = tAdRequest;
    }

    @Override
    public TAdRequest getAdRequest() {
        return this.tAdRequest;
    }

    @Override
    public void loadAd() {
        if (!NetUtil.checkNetworkState()) {
            if (this.mIntersListener != null) {
                this.mIntersListener.onError(TAdErrorCode.NETWORK_ERROR);
            }
            return;
        }
        AdLogUtil.Log().d(TAG, "start load ad...");
        ArrayList<ImpBean> arrayList = new ArrayList<ImpBean>();
        ImpBean impBean = new ImpBean();
        impBean.setId(1);
        impBean.setAdt(2);
        impBean.setPmid(this.mSelfPlacementId);
        arrayList.add(impBean);
        if (this.adServerRequest != null) {
            AdLogUtil.Log().d(TAG, "Called TAdInterstitial.loadAd() more than once. Auto reset request.");
            this.adServerRequest.cancelRequest();
            this.adServerRequest = null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sdk_v", "1.1.5.5");
        hashMap.put("net_type", MitNetUtil.getNetType() + "");
        hashMap.put("pid", this.mSelfPlacementId);
        hashMap.put("ad_type", "2");
        AthenaTracker.getInstance().load(hashMap);
        this.adServerRequest = ((AdServerRequest)((AdServerRequest)new AdServerRequest().setListener(new CommonResponseListener<AdResponseBody>(){

            @Override
            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                if (TAdInterstitial.this.isTimeout()) {
                    return;
                }
                if (TAdInterstitial.this.mIntersListener != null) {
                    TAdInterstitial.this.mIntersListener.onError(tAdErrorCode);
                }
            }

            @Override
            protected void onRequestSuccess(int n, AdResponseBody adResponseBody) {
                if (TAdInterstitial.this.isTimeout()) {
                    return;
                }
                if (adResponseBody != null && adResponseBody.getCode() == 0) {
                    AdLogUtil.Log().d(TAdInterstitial.TAG, "got data from net, response is :" + adResponseBody.toString());
                    if (adResponseBody.getAds() != null && adResponseBody.getAds().size() > 0) {
                        TAdInterstitial.this.mAdBean = adResponseBody.getAds().get(0);
                        TAdInterstitial.this.mAdBean.setRid(adResponseBody.getRid());
                        if (!TAdInterstitial.this.mAdBean.getPmid().equals(TAdInterstitial.this.mSelfPlacementId)) {
                            AdLogUtil.Log().e(TAdInterstitial.TAG, "request's pmid is diffrent with response's");
                            TAdInterstitial.this.mIntersListener.onError(TAdErrorCode.RESPONSE_PMID_DIFFRENT_ERROR);
                            return;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("sdk_v", "1.1.5.5");
                        hashMap.put("pid", TAdInterstitial.this.mSelfPlacementId);
                        hashMap.put("during", System.currentTimeMillis() - TAdInterstitial.this.startTime + "");
                        hashMap.put("ad_type", "2");
                        hashMap.put("result", "1");
                        hashMap.put("reason", "");
                        AthenaTracker.getInstance().loadResult(hashMap);
                        TAdInterstitial.this.loadPlatformAd();
                    } else {
                        AdLogUtil.Log().w(TAdInterstitial.TAG, "ads list is empty");
                        if (TAdInterstitial.this.mIntersListener != null) {
                            TAdInterstitial.this.mIntersListener.onError(TAdErrorCode.RESPONSE_AD_IS_EMPTY);
                        }
                    }
                } else {
                    AdLogUtil.Log().w(TAdInterstitial.TAG, adResponseBody != null ? "error,response code is :" + adResponseBody.getCode() + ",response msg is " + adResponseBody.getMsg() : "error, response is null");
                    if (TAdInterstitial.this.mIntersListener != null) {
                        if (adResponseBody != null) {
                            TAdInterstitial.this.mIntersListener.onError(new TAdErrorCode(adResponseBody.getCode(), adResponseBody.getMsg()));
                        } else {
                            TAdInterstitial.this.mIntersListener.onError(new TAdErrorCode(10000, "response is null"));
                        }
                    }
                }
            }
        })).setPlacementid(this.mSelfPlacementId)).setImpList(arrayList).setAd_type(2);
        this.adServerRequest.netRequestPreExecute();
        this.startTime = System.currentTimeMillis();
        this.runTimerTask();
    }

    @Override
    public String getPlacementId() {
        return this.mSelfPlacementId;
    }

    private void loadPlatformAd() {
        if (this.platform != null) {
            this.platform.destroy();
            this.platform = null;
        }
        try {
            this.platform = new AdxInterstitialGemini(this.mAdBean);
            if (this.platform != null) {
                this.platform.setPlacementId(this.mSelfPlacementId);
                this.platform.setAdListener(this.mIntersListener);
                AdLogUtil.Log().d(TAG, "loadPlatformAd on start load ad ");
                this.platform.loadAd();
                return;
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(TAG, exception.getMessage());
        }
    }

    @Override
    public void runTimerTask() {
        if (this.tAdRequest != null && this.runTimer != null) {
            int n = this.tAdRequest.getScheduleTime();
            this.isTimeout = false;
            this.runTimer.resetTimerTask();
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
            this.runTimer.setScheduleTime(n);
            this.runTimer.runTimerTask();
        }
    }

    @Override
    public boolean isTimeout() {
        return this.isTimeout;
    }

    public void show() {
        if (this.platform != null && this.mContext != null) {
            this.platform.setContext(this.mContext);
            this.platform.show();
        }
    }

    public boolean isLoaded() {
        if (this.platform != null) {
            return this.platform.isLoaded();
        }
        return false;
    }

    @Override
    public void destroy() {
        this.timeOutCallback = null;
        if (this.platform != null) {
            this.platform.destroy();
            this.platform = null;
        }
        if (this.adServerRequest != null) {
            this.adServerRequest.cancelRequest();
        }
        if (this.tAdRequest != null) {
            this.tAdRequest = null;
        }
        if (this.runTimer != null) {
            this.runTimer.resetTimerTask();
            this.runTimer = null;
        }
        this.mIntersListener = null;
        this.mContext = null;
        AdLogUtil.Log().d(TAG, "destroy");
    }
}

