/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.ad;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.transsion.core.utils.NetUtil;
import com.zero.adx.ad.request.TAdRequest;
import com.zero.adx.bean.TAdNativeInfo;
import com.zero.adx.bean.request.ImpBean;
import com.zero.adx.bean.response.AdBean;
import com.zero.adx.bean.response.AdResponseBody;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.event.AthenaTracker;
import com.zero.adx.http.callback.CommonResponseListener;
import com.zero.adx.http.request.AdServerRequest;
import com.zero.adx.impl.IAd;
import com.zero.adx.impl.TAdListener;
import com.zero.adx.platform.AdxNativeGemini;
import com.zero.adx.util.AdLogUtil;
import com.zero.adx.util.MitNetUtil;
import com.zero.adx.util.RunTimer;
import com.zero.adx.util.ThreadUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TAdNative
implements IAd {
    private static final String TAG = "AdxNative";
    private static final int DEFAULT_COUNT = 1;
    private int mAdsCount = 1;
    private String mSelfPlacementId = "";
    private boolean isAdLoaded = false;
    private boolean isRegisterView = false;
    private AdServerRequest adServerRequest = null;
    private boolean isTimeout = false;
    private RunTimer runTimer = new RunTimer();
    private TAdRequest tAdRequest = new TAdRequest.TAdRequestBuild().build();
    private List<AdBean> mAdBeans;
    private Long startTime = 0L;
    private AdxNativeGemini mPlatform;
    private TAdListener mNativeListener = new TAdListener(){

        @Override
        public void onAdLoaded(TAdNativeInfo tAdNativeInfo) {
            if (TAdNative.this.isTimeout) {
                AdLogUtil.Log().d(TAdNative.TAG, "Request time out");
                return;
            }
            if (TAdNative.this.runTimer != null) {
                TAdNative.this.runTimer.resetTimerTask();
            }
            TAdNative.this.isAdLoaded = true;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdNative.this.mSelfPlacementId);
            hashMap.put("ad_type", "3");
            AthenaTracker.getInstance().fill(hashMap);
            if (TAdNative.this.tAdRequest != null && TAdNative.this.tAdRequest.getListener() != null && tAdNativeInfo != null) {
                AdLogUtil.Log().d(TAdNative.TAG, "onAdLoaded TAdNativeInfo is:=" + tAdNativeInfo.toString());
                TAdNative.this.tAdRequest.getListener().onAdLoaded(tAdNativeInfo);
            }
        }

        @Override
        public void onAdLoaded(List<TAdNativeInfo> list) {
            if (TAdNative.this.mAdsCount == 1) {
                if (list != null && list.size() > 0) {
                    this.onAdLoaded(list.get(0));
                }
            } else {
                if (TAdNative.this.runTimer != null) {
                    TAdNative.this.runTimer.resetTimerTask();
                }
                TAdNative.this.isAdLoaded = true;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("sdk_v", "1.1.5.5");
                hashMap.put("pid", TAdNative.this.mSelfPlacementId);
                hashMap.put("ad_type", "3");
                AthenaTracker.getInstance().fill(hashMap);
                if (TAdNative.this.tAdRequest != null && TAdNative.this.tAdRequest.getListener() != null && list != null) {
                    AdLogUtil.Log().d(TAdNative.TAG, "onAdLoaded TadNativeInfos size is:=" + list.size());
                    TAdNative.this.tAdRequest.getListener().onAdLoaded(list);
                }
            }
        }

        @Override
        public void onError(TAdErrorCode tAdErrorCode) {
            if (TAdNative.this.isTimeout) {
                AdLogUtil.Log().e(TAdNative.TAG, "Request time out");
                return;
            }
            if (TAdNative.this.runTimer != null) {
                TAdNative.this.runTimer.resetTimerTask();
            }
            TAdNative.this.isAdLoaded = false;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdNative.this.mSelfPlacementId);
            hashMap.put("during", System.currentTimeMillis() - TAdNative.this.startTime + "");
            hashMap.put("ad_type", "3");
            hashMap.put("result", "0");
            hashMap.put("reason", tAdErrorCode.getErrorCode() + "");
            AthenaTracker.getInstance().loadResult(hashMap);
            if (TAdNative.this.tAdRequest != null && TAdNative.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().e(TAdNative.TAG, "native onError");
                TAdNative.this.tAdRequest.getListener().onError(tAdErrorCode);
            }
        }

        @Override
        public void onAdClicked() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdNative.this.mSelfPlacementId);
            hashMap.put("net_type", MitNetUtil.getNetType() + "");
            hashMap.put("ad_type", "3");
            AthenaTracker.getInstance().click(hashMap);
            if (TAdNative.this.tAdRequest != null && TAdNative.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdNative.TAG, "onAdClicked");
                TAdNative.this.tAdRequest.getListener().onAdClicked();
            }
        }

        @Override
        public void onAdShow() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdNative.this.mSelfPlacementId);
            hashMap.put("net_type", MitNetUtil.getNetType() + "");
            hashMap.put("ad_type", "3");
            AthenaTracker.getInstance().impression(hashMap);
            if (TAdNative.this.tAdRequest != null && TAdNative.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().d(TAdNative.TAG, "onAdShow");
                TAdNative.this.tAdRequest.getListener().onAdShow();
            }
        }

        @Override
        public void onTimeOut() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdk_v", "1.1.5.5");
            hashMap.put("pid", TAdNative.this.mSelfPlacementId);
            hashMap.put("during", System.currentTimeMillis() - TAdNative.this.startTime + "");
            hashMap.put("ad_type", "3");
            hashMap.put("result", "0");
            hashMap.put("reason", "9007");
            AthenaTracker.getInstance().loadResult(hashMap);
            if (TAdNative.this.tAdRequest != null && TAdNative.this.tAdRequest.getListener() != null) {
                AdLogUtil.Log().e(TAdNative.TAG, "onTimeOut");
                if (TAdNative.this.mPlatform != null && TAdNative.this.mPlatform.getNativeInfos() != null && TAdNative.this.mPlatform.getNativeInfos().size() > 0) {
                    TAdNative.this.tAdRequest.getListener().onAdLoaded(TAdNative.this.mPlatform.getNativeInfos());
                } else {
                    TAdNative.this.tAdRequest.getListener().onTimeOut();
                }
            }
        }

        @Override
        public void onAdClosed() {
            if (TAdNative.this.tAdRequest != null && TAdNative.this.tAdRequest.getListener() != null) {
                TAdNative.this.tAdRequest.getListener().onAdClosed();
            }
        }
    };
    private RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        @Override
        public void isTimeOut() {
            TAdNative.this.isTimeout = true;
            if (TAdNative.this.mNativeListener != null) {
                TAdNative.this.mNativeListener.onTimeOut();
            }
        }
    };

    public TAdNative(Context context, String string) {
        this.mSelfPlacementId = string;
    }

    public TAdNative(Context context, String string, int n) {
        this.mSelfPlacementId = string;
        this.setAdCount(n);
    }

    public void setAdCount(int n) {
        int n2 = 5;
        this.mAdsCount = n > n2 ? n2 : (n < 1 ? 1 : n);
    }

    public void setPlacementId(String string) {
        this.mSelfPlacementId = string;
    }

    @Override
    public void setAdRequest(@NonNull TAdRequest tAdRequest) {
        this.tAdRequest = tAdRequest;
    }

    @Override
    public TAdRequest getAdRequest() {
        return this.tAdRequest;
    }

    @Override
    public String getPlacementId() {
        return this.mSelfPlacementId;
    }

    @Override
    public void loadAd() {
        if (!NetUtil.checkNetworkState()) {
            if (this.mNativeListener != null) {
                this.mNativeListener.onError(TAdErrorCode.NETWORK_ERROR);
            }
            return;
        }
        AdLogUtil.Log().d(TAG, "start load ad...");
        ArrayList<ImpBean> arrayList = new ArrayList<ImpBean>();
        for (int i = 0; i < this.mAdsCount; ++i) {
            ImpBean impBean = new ImpBean();
            impBean.setId(i + 1);
            impBean.setAdt(3);
            impBean.setPmid(this.mSelfPlacementId);
            arrayList.add(impBean);
        }
        this.resetRequest();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sdk_v", "1.1.5.5");
        hashMap.put("net_type", MitNetUtil.getNetType() + "");
        hashMap.put("pid", this.mSelfPlacementId);
        hashMap.put("ad_type", "3");
        AthenaTracker.getInstance().load(hashMap);
        this.adServerRequest = ((AdServerRequest)((AdServerRequest)new AdServerRequest().setPlacementid(this.mSelfPlacementId)).setListener(new CommonResponseListener<AdResponseBody>(){

            @Override
            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                if (TAdNative.this.isTimeout()) {
                    return;
                }
                if (TAdNative.this.mNativeListener != null) {
                    TAdNative.this.mNativeListener.onError(tAdErrorCode);
                }
            }

            @Override
            protected void onRequestSuccess(int n, AdResponseBody adResponseBody) {
                if (TAdNative.this.isTimeout()) {
                    return;
                }
                if (adResponseBody != null && adResponseBody.getCode() == 0) {
                    if (adResponseBody.getAds() != null && adResponseBody.getAds().size() > 0) {
                        TAdNative.this.mAdBeans = adResponseBody.getAds();
                        ((AdBean)TAdNative.this.mAdBeans.get(0)).setRid(adResponseBody.getRid());
                        if (!((AdBean)TAdNative.this.mAdBeans.get(0)).getPmid().equals(TAdNative.this.mSelfPlacementId)) {
                            AdLogUtil.Log().e(TAdNative.TAG, "request's pmid is diffrent with response's");
                            TAdNative.this.mNativeListener.onError(TAdErrorCode.RESPONSE_PMID_DIFFRENT_ERROR);
                            return;
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("sdk_v", "1.1.5.5");
                        hashMap.put("pid", TAdNative.this.mSelfPlacementId);
                        hashMap.put("during", System.currentTimeMillis() - TAdNative.this.startTime + "");
                        hashMap.put("ad_type", "3");
                        hashMap.put("result", "1");
                        hashMap.put("reason", "");
                        AthenaTracker.getInstance().loadResult(hashMap);
                        TAdNative.this.loadPlatformAd();
                    } else {
                        AdLogUtil.Log().w(TAdNative.TAG, "ads list is empty");
                        if (TAdNative.this.mNativeListener != null) {
                            TAdNative.this.mNativeListener.onError(TAdErrorCode.RESPONSE_AD_IS_EMPTY);
                        }
                    }
                } else if (TAdNative.this.mNativeListener != null) {
                    if (adResponseBody != null) {
                        TAdNative.this.mNativeListener.onError(new TAdErrorCode(adResponseBody.getCode(), adResponseBody.getMsg()));
                    } else {
                        TAdNative.this.mNativeListener.onError(new TAdErrorCode(10000, "response is null"));
                    }
                }
            }
        })).setImpList(arrayList).setAd_type(3);
        this.startTime = System.currentTimeMillis();
        this.adServerRequest.netRequestPreExecute();
    }

    private void resetRequest() {
        if (this.adServerRequest != null) {
            AdLogUtil.Log().d(TAG, "Called TAdNative.loadAd() more than once. Auto reset request.");
            this.adServerRequest.cancelRequest();
            this.adServerRequest = null;
        }
        if (this.mPlatform != null) {
            this.mPlatform.clearNativeInfos();
        }
        this.runTimerTask();
        this.isAdLoaded = false;
    }

    @Override
    public void runTimerTask() {
        if (this.tAdRequest != null && this.runTimer != null) {
            int n = this.tAdRequest.getScheduleTime();
            this.isTimeout = false;
            this.runTimer.resetTimerTask();
            this.runTimer.setScheduleTime(n);
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
            this.runTimer.runTimerTask();
        }
    }

    @Override
    public boolean isTimeout() {
        return this.isTimeout;
    }

    private void loadPlatformAd() {
        if (this.mPlatform != null) {
            this.mPlatform.destroy();
            this.mPlatform = null;
        }
        try {
            this.mPlatform = new AdxNativeGemini(this.mAdBeans);
            if (this.mPlatform != null) {
                this.mPlatform.setPlacementId(this.mSelfPlacementId);
                this.mPlatform.setAdListener(this.mNativeListener);
                AdLogUtil.Log().d(TAG, "loadPlatformAd start load ad");
                this.mPlatform.loadAd();
                return;
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(TAG, exception.getMessage());
        }
    }

    public boolean isAdLoaded() {
        return this.isAdLoaded;
    }

    private boolean isRegisterView() {
        return this.isRegisterView;
    }

    public void unregisterView() {
        if (!ThreadUtil.isMainThread()) {
            AdLogUtil.Log().e(TAG, "You must call this method in Main Thread");
            return;
        }
        if (this.isRegisterView()) {
            if (this.mPlatform != null) {
                this.mPlatform.unregisterView();
            }
            this.isRegisterView = false;
            AdLogUtil.Log().d(TAG, "View unregister");
        } else {
            AdLogUtil.Log().d(TAG, "View not registered with this NativeAd");
        }
    }

    private void setRegisterViews(List<View> list, View view) {
        if (list != null) {
            list.add(view);
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    this.setRegisterViews(list, viewGroup.getChildAt(i));
                }
            }
        }
    }

    public void registerView(@NonNull View view, TAdNativeInfo tAdNativeInfo) {
        if (!ThreadUtil.isMainThread()) {
            AdLogUtil.Log().e(TAG, "You must call this method in Main Thread");
            return;
        }
        ArrayList<View> arrayList = new ArrayList<View>();
        this.setRegisterViews(arrayList, view);
        this.registerViews(view, arrayList, tAdNativeInfo);
    }

    public void registerViews(@NonNull View view, List<View> list, TAdNativeInfo tAdNativeInfo) {
        if (!ThreadUtil.isMainThread()) {
            AdLogUtil.Log().e(TAG, "You must call this method in Main Thread");
            return;
        }
        if (list != null && list.size() != 0) {
            if (!this.isAdLoaded()) {
                AdLogUtil.Log().e(TAG, "Ad is not finish load.");
                return;
            }
            if (this.isRegisterView()) {
                AdLogUtil.Log().d(TAG, "Native Ad was already registered with a View. Auto unregistering and proceeding.");
                this.unregisterView();
            }
            if (this.mPlatform != null) {
                this.mPlatform.registerViewForInteraction(view, list, tAdNativeInfo);
                AdLogUtil.Log().d(TAG, "Native Ad start registered");
            }
            if (8 == view.getVisibility()) {
                view.setVisibility(0);
            }
            this.isRegisterView = true;
        }
    }

    @Override
    public void destroy() {
        this.timeOutCallback = null;
        if (this.mPlatform != null) {
            this.mPlatform.destroy();
            this.mPlatform = null;
        }
        if (this.runTimer != null) {
            this.runTimer.resetTimerTask();
            this.runTimer = null;
        }
        if (this.adServerRequest != null) {
            this.adServerRequest.cancelRequest();
            this.adServerRequest = null;
        }
        this.tAdRequest = null;
        this.mNativeListener = null;
        AdLogUtil.Log().d(TAG, "destroy");
    }
}

