/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.cache;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.zero.adx.bean.response.NativeBean;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.event.AthenaTracker;
import com.zero.adx.http.callback.DrawableResponseListener;
import com.zero.adx.http.request.DownLoadRequest;
import com.zero.adx.util.AdLogUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AdImageHelper {
    public static void loadImageView(@NonNull String string, final @NonNull ImageView imageView) {
        DownLoadRequest downLoadRequest = ((DownLoadRequest)new DownLoadRequest().setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, Drawable drawable) {
                AdLogUtil.Log().d("AdImageHelper", "image cache success");
                if (drawable != null) {
                    imageView.setImageDrawable(drawable);
                }
            }

            @Override
            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                AdLogUtil.Log().e("AdImageHelper", "image load fail," + tAdErrorCode.toString());
            }
        })).setUrl(string);
        downLoadRequest.netRequestPreExecute();
    }

    public static void preCacheAdImage(final String string, final @NonNull NativeBean.Image image, final ImageListener imageListener) {
        final String string2 = image.getImg();
        AdLogUtil.Log().d("AdImageHelper", "request url:" + string2);
        DownLoadRequest downLoadRequest = ((DownLoadRequest)new DownLoadRequest().setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int n, Drawable drawable) {
                AdLogUtil.Log().d("AdImageHelper", "image cache success");
                if (drawable != null) {
                    image.setCached(true);
                    AdImageHelper.a(string, string2, "1");
                    if (imageListener != null) {
                        imageListener.onImagesCached();
                    }
                }
            }

            @Override
            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                AdLogUtil.Log().e("AdImageHelper", "image load fail," + tAdErrorCode.toString());
                AdImageHelper.a(string, string2, "0");
                if (imageListener != null) {
                    imageListener.onImagesFailedToCache(tAdErrorCode);
                }
            }
        })).setUrl(string2);
        downLoadRequest.netRequestPreExecute();
    }

    private static void a(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sdk_v", "1.1.5.5");
        hashMap.put("pid", string);
        hashMap.put("url", string2);
        hashMap.put("ad_type", "3");
        hashMap.put("result", string3);
        AthenaTracker.getInstance().imageDownload(hashMap);
    }

    public static void preCacheAdImages(String string, @NonNull List<NativeBean.Image> list, final @NonNull ImageListener imageListener) {
        final AtomicInteger atomicInteger = new AtomicInteger(list.size());
        for (NativeBean.Image image : list) {
            AdImageHelper.preCacheAdImage(string, image, new ImageListener(){

                @Override
                public void onImagesCached() {
                    int n = atomicInteger.decrementAndGet();
                    if (n == 0) {
                        imageListener.onImagesCached();
                    }
                }

                @Override
                public void onImagesFailedToCache(TAdErrorCode tAdErrorCode) {
                    int n = atomicInteger.decrementAndGet();
                    if (n == 0) {
                        imageListener.onImagesCached();
                    }
                }
            });
        }
    }

    public static interface ImageListener {
        public void onImagesCached();

        public void onImagesFailedToCache(TAdErrorCode var1);
    }
}

