/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.cache;

import android.support.annotation.Nullable;
import com.transsion.core.utils.AppUtil;
import com.zero.adx.cache.DiskLruCache;
import com.zero.adx.util.AdLogUtil;
import com.zero.adx.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CacheUtil {
    private String TAG = "CacheUtil";
    private static CacheUtil g;
    private static DiskLruCache i;

    private CacheUtil() {
        try {
            i = DiskLruCache.open(this.getCacheDir(), AppUtil.getVersionCode(), 1, 0x6400000L);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheUtil getInstance() {
        if (g != null) return g;
        Class<CacheUtil> clazz = CacheUtil.class;
        synchronized (CacheUtil.class) {
            if (g != null) return g;
            g = new CacheUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return g;
        }
    }

    @Nullable
    public synchronized String getString(String string) {
        if (i == null || i.isClosed()) {
            return null;
        }
        try {
            DiskLruCache.Snapshot snapshot = i.get(string);
            if (snapshot != null) {
                String string2 = snapshot.getString(0);
                AdLogUtil.Log().d(this.TAG, "get content successful.key=" + string + ", value=" + string2);
                return string2;
            }
        }
        catch (IOException iOException) {
            AdLogUtil.Log().e(this.TAG, "read cache error: " + iOException.toString());
        }
        return null;
    }

    public synchronized void putString(String string, String string2) {
        block6: {
            if (i == null || i.isClosed()) {
                return;
            }
            DiskLruCache.Editor editor = null;
            try {
                editor = i.edit(string);
                if (editor != null) {
                    editor.set(0, string2);
                    editor.commit();
                    i.flush();
                    AdLogUtil.Log().d(this.TAG, "put content successful. key=" + string);
                }
            }
            catch (IOException iOException) {
                if (editor == null) break block6;
                try {
                    editor.abort();
                }
                catch (IOException iOException2) {
                    AdLogUtil.Log().e(this.TAG, "write cache error: " + iOException.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSerializable(String string, Serializable serializable) {
        DiskLruCache.Editor editor = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            editor = i.edit(string);
            if (editor == null) {
                return;
            }
            OutputStream outputStream = editor.newOutputStream(0);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            editor.commit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                editor.abort();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAsSerializable(String string) {
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            DiskLruCache.Snapshot snapshot = i.get(string);
            if (snapshot == null) {
                T t = null;
                return t;
            }
            InputStream inputStream = snapshot.getInputStream(0);
            if (inputStream == null) {
                T t = null;
                return t;
            }
            objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return (T)object;
    }

    public void diskRemove(String string) {
        if (i == null || i.isClosed()) {
            return;
        }
        try {
            i.remove(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private File getCacheDir() {
        File file = new File(FileUtil.getAppDateCachePath(), "ZERO_AD_SDK_LRUCACHE");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

