/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.cache;

import com.zero.adx.util.AdLogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File j;
    private final File k;
    private final File l;
    private final int m;
    private final long n;
    private final int o;
    private long p = 0L;
    private Writer q;
    private final LinkedHashMap<String, a> r = new LinkedHashMap(0, 0.75f, true);
    private int s;
    private long t = 0L;
    private final ExecutorService u = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> v = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void g() throws Exception {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.q == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.d()) {
                    DiskLruCache.this.c();
                    DiskLruCache.this.s = 0;
                }
            }
            return null;
        }

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.g();
        }
    };

    private static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        int n3 = TArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4);
        System.arraycopy(TArray, n, objectArray, 0, n5);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            while ((n = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String readAsciiLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(80);
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new EOFException();
            }
            if (n == 10) break;
            stringBuilder.append((char)n);
        }
        n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '\r') {
            stringBuilder.setLength(n - 1);
        }
        return stringBuilder.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteContents(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            AdLogUtil.Log().d("DiskLruCache", "not a directory: " + file);
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                DiskLruCache.deleteContents(file2);
            }
            if (file2.delete()) continue;
            throw new IOException("failed to delete file: " + file2);
        }
    }

    private DiskLruCache(File file, int n, int n2, long l) {
        this.j = file;
        this.m = n;
        this.k = new File(file, "journal");
        this.l = new File(file, "journal.tmp");
        this.o = n2;
        this.n = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) throws IOException {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        DiskLruCache diskLruCache = new DiskLruCache(file, n, n2, l);
        if (diskLruCache.k.exists()) {
            try {
                diskLruCache.a();
                diskLruCache.b();
                diskLruCache.q = new BufferedWriter(new FileWriter(diskLruCache.k, true), 8192);
                return diskLruCache;
            }
            catch (IOException iOException) {
                diskLruCache.delete();
            }
        }
        file.mkdirs();
        diskLruCache = new DiskLruCache(file, n, n2, l);
        diskLruCache.c();
        return diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.k), 8192);
        try {
            String string = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string2 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string3 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string4 = DiskLruCache.readAsciiLine(bufferedInputStream);
            String string5 = DiskLruCache.readAsciiLine(bufferedInputStream);
            if (!("libcore.io.DiskLruCache".equals(string) && "1".equals(string2) && Integer.toString(this.m).equals(string3) && Integer.toString(this.o).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            try {
                while (true) {
                    this.a(DiskLruCache.readAsciiLine(bufferedInputStream));
                }
            }
            catch (EOFException eOFException) {
                DiskLruCache.closeQuietly(bufferedInputStream);
            }
        }
        catch (Throwable throwable) {
            DiskLruCache.closeQuietly(bufferedInputStream);
            throw throwable;
        }
    }

    private void a(String string) throws IOException {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 2) {
            throw new IOException("unexpected journal line: " + string);
        }
        String string2 = stringArray[1];
        if (stringArray[0].equals("REMOVE") && stringArray.length == 2) {
            this.r.remove(string2);
            return;
        }
        a a2 = this.r.get(string2);
        if (a2 == null) {
            a2 = new a(string2);
            this.r.put(string2, a2);
        }
        if (stringArray[0].equals("CLEAN") && stringArray.length == 2 + this.o) {
            a2.D = true;
            a2.E = null;
            a2.a(DiskLruCache.copyOfRange(stringArray, 2, stringArray.length));
        } else if (stringArray[0].equals("DIRTY") && stringArray.length == 2) {
            a2.E = new Editor(a2);
        } else if (!stringArray[0].equals("READ") || stringArray.length != 2) {
            throw new IOException("unexpected journal line: " + string);
        }
    }

    private void b() throws IOException {
        DiskLruCache.a(this.l);
        Iterator<a> iterator = this.r.values().iterator();
        while (iterator.hasNext()) {
            int n;
            a a2 = iterator.next();
            if (a2.E == null) {
                for (n = 0; n < this.o; ++n) {
                    this.p += a2.C[n];
                }
                continue;
            }
            a2.E = null;
            for (n = 0; n < this.o; ++n) {
                DiskLruCache.a(a2.a(n));
                DiskLruCache.a(a2.b(n));
            }
            iterator.remove();
        }
    }

    private synchronized void c() throws IOException {
        if (this.q != null) {
            this.q.close();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.l), 8192);
        bufferedWriter.write("libcore.io.DiskLruCache");
        bufferedWriter.write("\n");
        bufferedWriter.write("1");
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.m));
        bufferedWriter.write("\n");
        bufferedWriter.write(Integer.toString(this.o));
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        for (a a2 : this.r.values()) {
            if (a2.E != null) {
                bufferedWriter.write("DIRTY " + a2.B + '\n');
                continue;
            }
            bufferedWriter.write("CLEAN " + a2.B + a2.h() + '\n');
        }
        ((Writer)bufferedWriter).close();
        this.l.renameTo(this.k);
        this.q = new BufferedWriter(new FileWriter(this.k, true), 8192);
    }

    private static void a(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    public synchronized Snapshot get(String string) throws IOException {
        this.e();
        this.b(string);
        a a2 = this.r.get(string);
        if (a2 == null) {
            return null;
        }
        if (!a2.D) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.o];
        try {
            for (int i = 0; i < this.o; ++i) {
                inputStreamArray[i] = new FileInputStream(a2.a(i));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        ++this.s;
        this.q.append("READ " + string + '\n');
        if (this.d()) {
            this.u.submit(this.v);
        }
        return new Snapshot(string, a2.F, inputStreamArray);
    }

    public Editor edit(String string) throws IOException {
        return this.a(string, -1L);
    }

    private synchronized Editor a(String string, long l) throws IOException {
        this.e();
        this.b(string);
        a a2 = this.r.get(string);
        if (l != -1L && (a2 == null || a2.F != l)) {
            return null;
        }
        if (a2 == null) {
            a2 = new a(string);
            this.r.put(string, a2);
        } else if (a2.E != null) {
            return null;
        }
        Editor editor = new Editor(a2);
        a2.E = editor;
        this.q.write("DIRTY " + string + '\n');
        this.q.flush();
        return editor;
    }

    public File getDirectory() {
        return this.j;
    }

    public long maxSize() {
        return this.n;
    }

    public synchronized long size() {
        return this.p;
    }

    private synchronized void a(Editor editor, boolean bl) throws IOException {
        int n;
        a a2 = editor.y;
        if (a2.E != editor) {
            throw new IllegalStateException();
        }
        if (bl && !a2.D) {
            for (n = 0; n < this.o; ++n) {
                if (a2.b(n).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n = 0; n < this.o; ++n) {
            File file = a2.b(n);
            if (bl) {
                long l;
                if (!file.exists()) continue;
                File file2 = a2.a(n);
                file.renameTo(file2);
                long l2 = a2.C[n];
                ((a)a2).C[n] = l = file2.length();
                this.p = this.p - l2 + l;
                continue;
            }
            DiskLruCache.a(file);
        }
        ++this.s;
        a2.E = null;
        if (a2.D | bl) {
            a2.D = true;
            this.q.write("CLEAN " + a2.B + a2.h() + '\n');
            if (bl) {
                a2.F = this.t++;
            }
        } else {
            this.r.remove(a2.B);
            this.q.write("REMOVE " + a2.B + '\n');
        }
        if (this.p > this.n || this.d()) {
            this.u.submit(this.v);
        }
    }

    private boolean d() {
        int n = 2000;
        return this.s >= 2000 && this.s >= this.r.size();
    }

    public synchronized boolean remove(String string) throws IOException {
        this.e();
        this.b(string);
        a a2 = this.r.get(string);
        if (a2 == null || a2.E != null) {
            return false;
        }
        for (int i = 0; i < this.o; ++i) {
            File file = a2.a(i);
            if (!file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.p -= a2.C[i];
            ((a)a2).C[i] = 0L;
        }
        ++this.s;
        this.q.append("REMOVE " + string + '\n');
        this.r.remove(string);
        if (this.d()) {
            this.u.submit(this.v);
        }
        return true;
    }

    public boolean isClosed() {
        return this.q == null;
    }

    private void e() {
        if (this.q == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() throws IOException {
        this.e();
        this.trimToSize();
        this.q.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.q == null) {
            return;
        }
        for (a a2 : new ArrayList<a>(this.r.values())) {
            if (a2.E == null) continue;
            a2.E.abort();
        }
        this.trimToSize();
        this.q.close();
        this.q = null;
    }

    private void trimToSize() throws IOException {
        while (this.p > this.n) {
            Map.Entry<String, a> entry = this.r.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() throws IOException {
        this.close();
        DiskLruCache.deleteContents(this.j);
    }

    private void b(String string) {
        if (string.contains(" ") || string.contains("\n") || string.contains("\r")) {
            throw new IllegalArgumentException("keys must not contain spaces or newlines: \"" + string + "\"");
        }
    }

    private static String a(InputStream inputStream) throws IOException {
        return DiskLruCache.readFully(new InputStreamReader(inputStream, UTF_8));
    }

    private final class a {
        private final String B;
        private final long[] C;
        private boolean D;
        private Editor E;
        private long F;

        private a(String string) {
            this.B = string;
            this.C = new long[DiskLruCache.this.o];
        }

        public String h() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : this.C) {
                stringBuilder.append(' ').append(l);
            }
            return stringBuilder.toString();
        }

        private void a(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.o) {
                throw this.b(stringArray);
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.C[i] = Long.parseLong(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.b(stringArray);
            }
        }

        private IOException b(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File a(int n) {
            return new File(DiskLruCache.this.j, this.B + "." + n);
        }

        public File b(int n) {
            return new File(DiskLruCache.this.j, this.B + "." + n + ".tmp");
        }
    }

    public final class Editor {
        private final com.zero.adx.cache.DiskLruCache$a y;
        private boolean z;

        private Editor(com.zero.adx.cache.DiskLruCache$a a2) {
            this.y = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.y.E != this) {
                    throw new IllegalStateException();
                }
                if (!this.y.D) {
                    return null;
                }
                return new FileInputStream(this.y.a(n));
            }
        }

        public String getString(int n) throws IOException {
            InputStream inputStream = this.newInputStream(n);
            return inputStream != null ? DiskLruCache.a(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.y.E != this) {
                    throw new IllegalStateException();
                }
                return new a(new FileOutputStream(this.y.b(n)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n, String string) throws IOException {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n), UTF_8);
                outputStreamWriter.write(string);
            }
            catch (Throwable throwable) {
                DiskLruCache.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            DiskLruCache.closeQuietly(outputStreamWriter);
        }

        public void commit() throws IOException {
            if (this.z) {
                DiskLruCache.this.a(this, false);
                DiskLruCache.this.remove(this.y.B);
            } else {
                DiskLruCache.this.a(this, true);
            }
        }

        public void abort() throws IOException {
            DiskLruCache.this.a(this, false);
        }

        private class a
        extends FilterOutputStream {
            private a(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                }
                catch (IOException iOException) {
                    Editor.this.z = true;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    Editor.this.z = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    Editor.this.z = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    Editor.this.z = true;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String B;
        private final long F;
        private final InputStream[] G;

        private Snapshot(String string, long l, InputStream[] inputStreamArray) {
            this.B = string;
            this.F = l;
            this.G = inputStreamArray;
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.a(this.B, this.F);
        }

        public InputStream getInputStream(int n) {
            return this.G[n];
        }

        public String getString(int n) throws IOException {
            return DiskLruCache.a(this.getInputStream(n));
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.G) {
                DiskLruCache.closeQuietly(inputStream);
            }
        }
    }
}

