/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.config;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.zero.adx.constant.Constants;

public final class TAdManager {
    private static final String TAG = "TAdManager";
    private static AdConfig adConfig;

    public static int getAppId() {
        if (adConfig != null) {
            return adConfig.AppId;
        }
        return -1;
    }

    public static String getAppToken() {
        if (adConfig != null) {
            return adConfig.appToken;
        }
        return "";
    }

    public static boolean isDebug() {
        if (adConfig != null) {
            return adConfig.isDebug;
        }
        return false;
    }

    public static void setDebug(boolean bl) {
        if (adConfig != null) {
            adConfig.isDebug = bl;
        }
    }

    public static void init(@NonNull AdConfig adConfig) {
        if (TAdManager.adConfig != null) {
            return;
        }
        TAdManager.adConfig = adConfig;
        Constants.initNotification();
    }

    public static final class AdConfigBuilder {
        private int AppId = -1;
        private boolean isDebug = false;
        private String appToken = "";
        private String applicationId = "";

        public int getAppId() {
            return this.AppId;
        }

        public boolean isDebug() {
            return this.isDebug;
        }

        public AdConfigBuilder setDebug(boolean bl) {
            this.isDebug = bl;
            return this;
        }

        public AdConfigBuilder setAppToken(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new RuntimeException("please enter useful appid");
            }
            this.appToken = string;
            return this;
        }

        public String getAppToken() {
            return this.appToken;
        }

        public AdConfigBuilder setAppId(int n) {
            if (n == -1) {
                throw new RuntimeException("please enter useful appid");
            }
            this.AppId = n;
            return this;
        }

        public AdConfigBuilder setApplicationIdForStartAd(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new RuntimeException("please enter useful applicationId");
            }
            this.applicationId = string;
            return this;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public AdConfig build() {
            return new AdConfig(this);
        }
    }

    public static final class AdConfig {
        private final String applicationId;
        private int AppId = -1;
        private String appToken = "";
        private boolean isDebug = false;

        public AdConfig(AdConfigBuilder adConfigBuilder) {
            this.AppId = adConfigBuilder.getAppId();
            this.appToken = adConfigBuilder.getAppToken();
            this.isDebug = adConfigBuilder.isDebug();
            this.applicationId = adConfigBuilder.getApplicationId();
        }
    }
}

