/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.platform;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import com.zero.adx.bean.TAdNativeInfo;
import com.zero.adx.bean.response.AdBean;
import com.zero.adx.bean.response.NativeBean;
import com.zero.adx.ui.activity.TAdExposureActivity;
import com.zero.adx.util.AdLogUtil;
import java.util.ArrayList;
import java.util.List;

public class PlatformUtil {
    private static TAdNativeInfo a(AdBean adBean) {
        TAdNativeInfo tAdNativeInfo = new TAdNativeInfo();
        tAdNativeInfo.setSequenceId(adBean.getId());
        tAdNativeInfo.setVer(adBean.getNativeBean().getVer());
        tAdNativeInfo.setBrand(adBean.getNativeBean().getBrand());
        tAdNativeInfo.setCtatext(adBean.getNativeBean().getCtatext());
        tAdNativeInfo.setDisplay(adBean.getNativeBean().getDisplay());
        tAdNativeInfo.setDownloads(adBean.getNativeBean().getDownload());
        tAdNativeInfo.setLikes(adBean.getNativeBean().getLikes());
        tAdNativeInfo.setDescription(adBean.getNativeBean().getDesc());
        tAdNativeInfo.setTitle(adBean.getNativeBean().getTitle());
        tAdNativeInfo.setPrice(adBean.getNativeBean().getPrice());
        tAdNativeInfo.setRating(adBean.getNativeBean().getRating());
        tAdNativeInfo.setSaleprice(adBean.getNativeBean().getSaleprice());
        tAdNativeInfo.setSponsor(adBean.getNativeBean().getSponsor());
        tAdNativeInfo.setIcon(adBean.getNativeBean().getIcon());
        ArrayList<NativeBean.Image> arrayList = new ArrayList<NativeBean.Image>();
        arrayList.add(adBean.getNativeBean().getImage());
        tAdNativeInfo.setImage(arrayList);
        return tAdNativeInfo;
    }

    public static List<TAdNativeInfo> getTadNativeInfoList(List<AdBean> list) {
        ArrayList<TAdNativeInfo> arrayList = new ArrayList<TAdNativeInfo>();
        for (AdBean adBean : list) {
            arrayList.add(PlatformUtil.a(adBean));
        }
        return arrayList;
    }

    public static TAdNativeInfo getTadNativeInfo(AdBean adBean) {
        if (adBean != null) {
            return PlatformUtil.a(adBean);
        }
        return null;
    }

    public static boolean isPackageAvilible(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo("com.android.chrome", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        return packageInfo != null;
    }

    public static void startActivity(Context context, AdBean adBean) {
        if (adBean == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)adBean.getDpl())) {
            AdLogUtil.Log().e("PlatformUtil", "deep link is:=" + adBean.getDpl());
            Intent intent = new Intent(context, TAdExposureActivity.class);
            intent.putExtra("url", adBean.getDpl());
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        } else if (!TextUtils.isEmpty((CharSequence)adBean.getLdp())) {
            if (PlatformUtil.isPackageAvilible(context)) {
                AdLogUtil.Log().d("PlatformUtil", "Start page with Chrome Browser");
                boolean bl = PlatformUtil.startPageWithChrome(context, adBean.getLdp());
                if (!bl) {
                    AdLogUtil.Log().d("PlatformUtil", "Start page with Chrome Browser failed,Start default Browser.");
                    PlatformUtil.a(context, adBean.getLdp());
                }
            } else {
                AdLogUtil.Log().d("PlatformUtil", "Start page with default Browser");
                PlatformUtil.a(context, adBean.getLdp());
            }
        } else {
            AdLogUtil.Log().e("PlatformUtil", "Both deeplink and landing page is null");
        }
    }

    private static void a(Context context, String string) {
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri uri = Uri.parse((String)string);
            intent.setData(uri);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("PlatformUtil", exception.getLocalizedMessage());
        }
    }

    public static boolean startPageWithChrome(Context context, String string) {
        boolean bl = true;
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
            intent.setPackage("com.android.chrome");
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static String getRealUrl(String string) {
        String string2 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string2 = string.substring(12);
        }
        return string2;
    }

    public static int getDrawableWidth(Drawable drawable, int n) {
        if (drawable != null) {
            if (drawable instanceof BitmapDrawable) {
                int n2 = ((BitmapDrawable)drawable).getBitmap().getWidth();
                AdLogUtil.Log().d("PlatformUtil", "BitmapDrawable width:=" + n2);
                return n2 > 0 ? n2 : 0;
            }
            if (drawable instanceof Drawable) {
                int n3 = drawable.getIntrinsicWidth();
                AdLogUtil.Log().d("PlatformUtil", "Drawable width:=" + n3);
                return n3 > 0 ? n3 : 0;
            }
        }
        return n;
    }

    public static int getDrawableHeight(Drawable drawable, int n) {
        if (drawable != null) {
            if (drawable instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
                if (bitmap != null) {
                    int n2 = bitmap.getHeight();
                    AdLogUtil.Log().d("PlatformUtil", "BitmapDrawable height:=" + n2);
                    return n2 > 0 ? n2 : 0;
                }
            } else if (drawable instanceof Drawable) {
                int n3 = drawable.getIntrinsicHeight();
                AdLogUtil.Log().d("PlatformUtil", "Drawable height:=" + n3);
                return n3 > 0 ? n3 : 0;
            }
        }
        return n;
    }

    public static boolean isOurSelflanding(AdBean adBean) {
        return adBean != null && (!TextUtils.isEmpty((CharSequence)adBean.getDpl()) || !TextUtils.isEmpty((CharSequence)adBean.getLdp()));
    }
}

