/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adx.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zero.adx.R;
import com.zero.adx.bean.TAdNativeInfo;
import com.zero.adx.bean.response.NativeBean;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.http.callback.DrawableResponseListener;
import com.zero.adx.http.request.DownLoadRequest;
import com.zero.adx.util.AdLogUtil;
import java.util.List;

public class TAdNativeView
extends RelativeLayout {
    private static final String TAG = "TAdNativeView";
    private boolean canCreate = false;

    public TAdNativeView(Context context) {
        this(context, null);
    }

    public TAdNativeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TAdNativeView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public void addNativeAdView(View view, TAdNativeInfo tAdNativeInfo) {
        this.canCreate = true;
        if (tAdNativeInfo == null || view == null) {
            AdLogUtil.Log().d(TAG, "group view is null or nativeInfo is null ");
            return;
        }
        this.addView(view, tAdNativeInfo);
        this.addSelfChoice();
        AdLogUtil.Log().d(TAG, "add view finish");
    }

    private void addView(View view, TAdNativeInfo tAdNativeInfo) {
        this.removeAllViews();
        AdLogUtil.Log().d(TAG, "remove all view");
        this.addView(this.getNativeView(view, tAdNativeInfo));
    }

    private View getNativeView(View view, TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo == null) {
            throw new IllegalStateException("TAdNativeInfo is null");
        }
        if (view == null) {
            throw new IllegalStateException("ViewGroup can not be null.");
        }
        return view;
    }

    private void addSelfChoice() {
        ImageView imageView = new ImageView(this.getContext().getApplicationContext());
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getContext().getApplicationContext().getResources(), (int)R.drawable.ad_choices);
        imageView.setImageBitmap(bitmap);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10, -1);
        layoutParams.addRule(11, -1);
        this.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void setIconView(final ImageView imageView, TAdNativeInfo tAdNativeInfo) {
        if (!this.canCreate) {
            throw new IllegalStateException("ViewGroup cannot be null. Make sure your activity called TNativeAdView.addNativeAdView(ViewGroup, TAdNativeInfo) before.");
        }
        if (imageView == null) {
            throw new IllegalStateException("View cannot be null.");
        }
        if (tAdNativeInfo == null) {
            throw new IllegalStateException("TAdNativeInfo cannot be null.");
        }
        imageView.setImageDrawable(null);
        NativeBean.Image image = tAdNativeInfo.getIcon();
        if (image != null) {
            if (image.getDrawable() != null) {
                imageView.setImageDrawable(image.getDrawable());
            } else if (!TextUtils.isEmpty((CharSequence)image.getImg())) {
                DownLoadRequest downLoadRequest = ((DownLoadRequest)new DownLoadRequest().setListener(new DrawableResponseListener(){

                    @Override
                    protected void onRequestError(TAdErrorCode tAdErrorCode) {
                        AdLogUtil.Log().e(TAdNativeView.TAG, "download icon failed.");
                    }

                    @Override
                    public void onRequestSuccess(int n, Drawable drawable2) {
                        if (drawable2 != null) {
                            AdLogUtil.Log().d(TAdNativeView.TAG, "download icon Success.");
                            imageView.setImageDrawable(drawable2);
                        }
                    }
                })).setUrl(image.getImg());
                downLoadRequest.netRequestPreExecute();
            }
        }
    }

    public final void setImageView(ImageView imageView, TAdNativeInfo tAdNativeInfo) {
        if (!this.canCreate) {
            throw new IllegalStateException("ViewGroup is null. Make sure your activity called TNativeAdView.addNativeAdView(ViewGroup, TAdNativeInfo) before.");
        }
        if (imageView == null) {
            throw new IllegalStateException("View cannot be null.");
        }
        if (tAdNativeInfo == null) {
            throw new IllegalStateException("TAdNativeInfo cannot be null.");
        }
        imageView.setImageDrawable(null);
        List<NativeBean.Image> list = tAdNativeInfo.getImage();
        if (list != null && list.size() > 0) {
            this.setImageViewImpl(imageView, list.get(0));
        }
    }

    public final void setImageView(ImageView imageView, NativeBean.Image image) {
        if (!this.canCreate) {
            throw new IllegalStateException("ViewGroup is null. Make sure your activity called TNativeAdView.addNativeAdView(ViewGroup, TAdNativeInfo) before.");
        }
        if (imageView == null) {
            throw new IllegalStateException("View cannot be null.");
        }
        if (image == null) {
            throw new IllegalStateException("image cannot be null.");
        }
        imageView.setImageDrawable(null);
        this.setImageViewImpl(imageView, image);
    }

    private void setImageViewImpl(final ImageView imageView, NativeBean.Image image) {
        if (image != null) {
            if (image.getDrawable() != null) {
                imageView.setImageDrawable(image.getDrawable());
            } else if (!TextUtils.isEmpty((CharSequence)image.getImg())) {
                DownLoadRequest downLoadRequest = ((DownLoadRequest)new DownLoadRequest().setListener(new DrawableResponseListener(){

                    @Override
                    public void onRequestSuccess(int n, Drawable drawable2) {
                        if (drawable2 != null) {
                            AdLogUtil.Log().d(TAdNativeView.TAG, "download Image Success.");
                            imageView.setImageDrawable(drawable2);
                        }
                    }

                    @Override
                    protected void onRequestError(TAdErrorCode tAdErrorCode) {
                        AdLogUtil.Log().e(TAdNativeView.TAG, "download Image failed.");
                    }
                })).setUrl(image.getImg());
                downLoadRequest.netRequestPreExecute();
            }
        }
    }
}

