/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate;

import android.content.Context;
import android.os.Bundle;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.athena.data.TrackData;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.LogUtils;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.json.Tson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class Tracker {
    private static FirebaseAnalytics mFirebaseAnalytics;
    private static AthenaAnalytics mAthenaAnalytics;

    public static void track(TID TID2, Bundle bundle) {
        Tracker.track(TID2, bundle, true);
    }

    public static void trackList(TID TID2, List<Bundle> bundleList) {
        Tracker.trackList(TID2, bundleList, true);
    }

    public static void trackList(TID tid, List<Bundle> bundleList, boolean isUsedFB) {
        if (!PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
            return;
        }
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)CoreUtil.getContext());
        }
        if (mAthenaAnalytics == null) {
            mAthenaAnalytics = AthenaAnalytics.getInstance((int)TID.TMS_ACTIVE.getTid());
        }
        if (isUsedFB) {
            Bundle mapBundle = new Bundle();
            ArrayList list = new ArrayList();
            for (Bundle bundle : bundleList) {
                Set keySet = bundle.keySet();
                HashMap<String, Object> map = new HashMap<String, Object>(bundle.keySet().size());
                for (String key : keySet) {
                    map.put(key, bundle.get(key));
                }
                list.add(map);
            }
            String listData = Tson.toJson(list);
            LogUtils.v((String)"TMS_TRACKER", (Object[])new Object[]{"listData -> " + listData});
            mapBundle.putString("list_data", listData);
            mFirebaseAnalytics.logEvent(tid.name, mapBundle);
        }
        TrackData trackData = new TrackData();
        for (Bundle bundle : bundleList) {
            trackData.add("data", bundle, 3);
            mAthenaAnalytics.track(tid.getName(), trackData, tid.getTid());
        }
    }

    private static void track(TID tid, Bundle bundle, boolean isUsedFB) {
        if (!PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
            return;
        }
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)CoreUtil.getContext());
        }
        if (mAthenaAnalytics == null) {
            mAthenaAnalytics = AthenaAnalytics.getInstance((int)TID.TMS_ACTIVE.getTid());
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (isUsedFB) {
            mFirebaseAnalytics.logEvent(tid.name, bundle);
        }
        TrackData trackData = new TrackData();
        Set keySet = bundle.keySet();
        for (String key : keySet) {
            trackData.add(key, "" + bundle.get(key));
        }
        mAthenaAnalytics.track(tid.getName(), trackData, tid.getTid());
    }

    public static void submitAll() {
        if (!PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
            return;
        }
        if (mAthenaAnalytics != null) {
            mAthenaAnalytics.submitAll();
        }
    }

    public static void enableTrackData() {
        AthenaAnalytics.enable((boolean)true);
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)CoreUtil.getContext());
        }
        mFirebaseAnalytics.setAnalyticsCollectionEnabled(true);
    }

    public static void disableTrackData() {
        AthenaAnalytics.enable((boolean)false);
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)CoreUtil.getContext());
        }
        mFirebaseAnalytics.resetAnalyticsData();
        mFirebaseAnalytics.setAnalyticsCollectionEnabled(false);
    }

    public static enum TID {
        TMS_ACTIVE("tms_active", 10190001),
        TMS_SYNC("sync", 10190002),
        TMS_CREATIVE_GET("creative_get", 10190003),
        TMS_CID_STATUS("cid_state", 10190003),
        TMS_UPDATE_GET("update_get", 10190004),
        TMS_APP_TASK_STATUS("app_task_status", 10190005),
        TMS_SDK_ACTION("sdk_action", 10190006),
        TMS_SETTING_ENTER("enter_from_setting", 10190007),
        TMS_NOTIFICATION_ENTER("enter_from_notice", 10190007),
        TMS_OPEN_WEBVIEW("open_webview", 10190007),
        TMS_DETAIL_OPEN("open_detail", 10190007),
        TMS_DETAIL_CLICK_DOWNLOAD("detail_download_click", 10190007),
        TMS_DETAIL_CLICK_OPEN_APP("open_app", 10190007),
        TMS_APP_LIST_CLICK_DOWNLOAD("app_list_download_click", 10190007),
        TMS_APP_LIST_CLICK_EDIT("app_list_edit_click", 10190007),
        TMS_APP_LIST_CLICK_DELETE("app_list_delete_click", 10190007),
        TMS_TRAFFIC_REMIND_CLICK("data_traffic_remind_click", 10190007),
        TMS_TRAFFIC_REMIND_SHOW("data_traffic_remind_show", 10190007),
        TMS_IMG_CACHE_STATUS("img_cache_status", 10190008),
        TMS_IMG_CACHE_START_STATUS("img_cache_start_status_list", 10190008),
        TMS_APP_DOWNLOAD_STATUS("app_download_status", 10190009),
        TMS_APP_DATA_REPORT_PHONE("data_report_phone_info", 10190010),
        TMS_APP_DATA_REPORT_PKG("data_report_phone_pkg", 10190011),
        TMS_CRASH("crash", 10190015),
        TMS_OSUPDATE_INSTALL_EVENT("oie", 10280007),
        END("end", 99999999);

        private final String name;
        private final int tid;

        private TID(String name, int tid) {
            this.name = name;
            this.tid = tid;
        }

        public String getName() {
            return this.name;
        }

        public int getTid() {
            return this.tid;
        }
    }
}

