/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download;

import android.content.Context;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.DownloadTaskManager;
import com.transsion.appupdate.download.db.DownloadDao;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import java.util.ArrayList;
import java.util.List;

public final class AppDownloadTaskManager
extends DownloadTaskManager<AppDownLoadTask> {
    private static AppDownloadTaskManager sInstance;

    private AppDownloadTaskManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.mDownloadDao = DownloadDao.getInstance(context);
        long startTime = System.currentTimeMillis();
        this.resetDownloadingStatus();
        this.resetOslabDownloadingStatus();
        CS.log.d("TMS_DOWNLOAD", "update time:" + (System.currentTimeMillis() - startTime));
    }

    public static synchronized AppDownloadTaskManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new AppDownloadTaskManager(context);
        }
        return sInstance;
    }

    private void resetDownloadingStatus() {
        ArrayList<AppDownLoadTask> appTasks = new ArrayList<AppDownLoadTask>();
        List<AppDownLoadTask> downloadingTasks = this.mDownloadDao.queryByState(new AppDownLoadTask(), DownloadState.DOWNLOADING);
        List<AppDownLoadTask> waitingTasks = this.mDownloadDao.queryByState(new AppDownLoadTask(), DownloadState.WAITING);
        appTasks.addAll(downloadingTasks);
        appTasks.addAll(waitingTasks);
        if (appTasks.size() > 0) {
            for (AppDownLoadTask downloadTask : appTasks) {
                downloadTask.downloadState = DownloadState.PAUSE;
                this.updateDownloadTaskStatus(downloadTask);
            }
        }
    }

    private void resetOslabDownloadingStatus() {
        if (CSLib.OS_LAB) {
            ArrayList<OsLabAppDownLoadTask> appTasks = new ArrayList<OsLabAppDownLoadTask>();
            List<OsLabAppDownLoadTask> downloadingTasks = this.mDownloadDao.queryByState(new OsLabAppDownLoadTask(), DownloadState.DOWNLOADING);
            List<OsLabAppDownLoadTask> waitingTasks = this.mDownloadDao.queryByState(new OsLabAppDownLoadTask(), DownloadState.WAITING);
            appTasks.addAll(downloadingTasks);
            appTasks.addAll(waitingTasks);
            if (appTasks.size() > 0) {
                for (OsLabAppDownLoadTask downloadTask : appTasks) {
                    downloadTask.downloadState = DownloadState.PAUSE;
                    this.updateDownloadTaskStatus(downloadTask);
                }
            }
        }
    }
}

