/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download;

import android.content.Context;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.DownloadTaskManager;
import com.transsion.appupdate.download.db.DownloadDao;
import com.transsion.appupdate.download.task.AppSilentDownLoadTask;
import com.transsion.appupdate.download.task.CoreDownloadTask;
import com.transsion.appupdate.download.task.ImgCacheTask;
import com.transsion.appupdate.download.task.OsLabAppSilentDownLoadTask;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import java.util.List;

public final class CoreDownloadTaskManager
extends DownloadTaskManager<CoreDownloadTask> {
    private static CoreDownloadTaskManager sInstance;

    private CoreDownloadTaskManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.mDownloadDao = DownloadDao.getInstance(context);
        long startTime = System.currentTimeMillis();
        this.resetDownloadingStatus();
        this.resetOslabDownloadingStatus();
        CS.log.d("TMS_DOWNLOAD", "update time:" + (System.currentTimeMillis() - startTime));
    }

    public static synchronized CoreDownloadTaskManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new CoreDownloadTaskManager(context);
        }
        return sInstance;
    }

    private void resetDownloadingStatus() {
        List<ImgCacheTask> imgCacheTasks;
        List<AppSilentDownLoadTask> silentTasks = this.mDownloadDao.queryByState(new AppSilentDownLoadTask(), DownloadState.DOWNLOADING);
        if (null != silentTasks && silentTasks.size() > 0) {
            for (AppSilentDownLoadTask downloadTask : silentTasks) {
                downloadTask.downloadState = DownloadState.PAUSE;
                this.updateDownloadTaskStatus(downloadTask);
            }
        }
        if (null != (imgCacheTasks = this.mDownloadDao.queryByState(new ImgCacheTask(), DownloadState.DOWNLOADING)) && imgCacheTasks.size() > 0) {
            for (ImgCacheTask downloadTask : imgCacheTasks) {
                downloadTask.downloadState = DownloadState.PAUSE;
                this.updateDownloadTaskStatus(downloadTask);
            }
        }
    }

    private void resetOslabDownloadingStatus() {
        List<OsLabAppSilentDownLoadTask> silentTasks;
        if (CSLib.OS_LAB && null != (silentTasks = this.mDownloadDao.queryByState(new OsLabAppSilentDownLoadTask(), DownloadState.DOWNLOADING)) && silentTasks.size() > 0) {
            for (OsLabAppSilentDownLoadTask downloadTask : silentTasks) {
                downloadTask.downloadState = DownloadState.PAUSE;
                this.updateDownloadTaskStatus(downloadTask);
            }
        }
    }
}

