/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download.task;

import android.content.ContentValues;
import android.database.Cursor;
import com.transsion.appupdate.download.DownloadState;
import java.util.ArrayList;
import java.util.List;

public abstract class DownloadTask
implements Cloneable {
    public String url;
    public String md5;
    public long finishedSize;
    public long totalSize;
    public String filePath;
    public DownloadState downloadState;
    public long startTime;
    public boolean isSilentInstall = true;
    public int reDownloadTimes;
    public int reDownloadMaxTimes;
    public int downloadFailType;

    public DownloadTask() {
    }

    public DownloadTask(String url) {
        this.url = url;
    }

    public DownloadTask(String url, String md5, long totalSize, String filePath, DownloadState downloadState, long startTime, boolean isSilentInstall, int reDownloadMaxTimes) {
        this.url = url;
        this.md5 = md5;
        this.totalSize = totalSize;
        this.filePath = filePath;
        this.downloadState = downloadState;
        this.startTime = startTime;
        this.isSilentInstall = isSilentInstall;
        this.reDownloadMaxTimes = reDownloadMaxTimes;
    }

    public ContentValues of() {
        ContentValues values = new ContentValues();
        values.put("url", this.url);
        values.put("MD5", this.md5);
        values.put("downloadState", this.downloadState.name());
        values.put("finishedSize", Long.valueOf(this.finishedSize));
        values.put("totalSize", Long.valueOf(this.totalSize));
        values.put("filepath", this.filePath);
        values.put("startTime", Long.valueOf(this.startTime));
        values.put("isSilentInstall", Integer.valueOf(this.isSilentInstall ? 1 : 0));
        values.put("reDownloadTimes", Integer.valueOf(this.reDownloadTimes));
        values.put("reDownloadMaxTimes", Integer.valueOf(this.reDownloadMaxTimes));
        values.put("downloadFailType", Integer.valueOf(this.downloadFailType));
        return values;
    }

    public DownloadTask valueOf(Cursor cursor) {
        this.url = cursor.getString(cursor.getColumnIndex("url"));
        this.md5 = cursor.getString(cursor.getColumnIndex("MD5"));
        this.downloadState = DownloadState.valueOf(cursor.getString(cursor.getColumnIndex("downloadState")));
        this.finishedSize = cursor.getInt(cursor.getColumnIndex("finishedSize"));
        this.totalSize = cursor.getInt(cursor.getColumnIndex("totalSize"));
        this.filePath = cursor.getString(cursor.getColumnIndex("filepath"));
        this.startTime = cursor.getLong(cursor.getColumnIndex("startTime"));
        this.isSilentInstall = cursor.getInt(cursor.getColumnIndex("isSilentInstall")) > 0;
        this.reDownloadTimes = cursor.getInt(cursor.getColumnIndex("reDownloadTimes"));
        this.reDownloadMaxTimes = cursor.getInt(cursor.getColumnIndex("reDownloadMaxTimes"));
        this.downloadFailType = cursor.getInt(cursor.getColumnIndex("downloadFailType"));
        return this;
    }

    public List<String> columns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("url");
        columns.add("MD5");
        columns.add("downloadState");
        columns.add("finishedSize");
        columns.add("totalSize");
        columns.add("filepath");
        columns.add("startTime");
        columns.add("isSilentInstall");
        columns.add("reDownloadTimes");
        columns.add("reDownloadMaxTimes");
        columns.add("downloadFailType");
        return columns;
    }

    public void clear() {
        this.url = null;
        this.md5 = null;
        this.finishedSize = 0L;
        this.totalSize = 0L;
        this.filePath = null;
        this.downloadState = null;
        this.startTime = 0L;
        this.isSilentInstall = true;
        this.reDownloadTimes = 0;
        this.reDownloadMaxTimes = 0;
        this.downloadFailType = 0;
    }

    public abstract String getTableName();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadTask other = (DownloadTask)obj;
        if (this.url == null) {
            return other.url == null;
        }
        return this.url.equals(other.url);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

