/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.media;

import android.text.TextUtils;
import com.transsion.appupdate.http.HttpTool;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.common.bean.SdkAppConfig;
import com.transsion.common.bean.SdkAppID;
import com.transsion.common.log.CS;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.StringCallback;
import com.transsion.json.Tson;
import org.json.JSONObject;

public class CmdMedia {
    private static final String SUCCESS_CODE = "200";
    private static CmdMedia cmdMedia = null;
    private IMediaCallback callback = null;

    public static CmdMedia getInstance() {
        if (null == cmdMedia) {
            cmdMedia = new CmdMedia();
        }
        return cmdMedia;
    }

    public void syncData(SdkAppID sdkAppID, IMediaCallback iMediaCallback) {
        this.callback = iMediaCallback;
        String json = Tson.toJson((Object)sdkAppID);
        CS.log.d("TMS_MEDIA", "ConfigMedia request: Json ->" + json);
        HttpTool.getTool().getCmd(json, (HttpCallbackImpl)new StringCallback(){

            public void onSuccess(int i, String s) {
                block4: {
                    CS.log.d("TMS_MEDIA", "ConfigMedia onSuccess: s->" + s);
                    if (!TextUtils.isEmpty((CharSequence)s)) {
                        try {
                            JSONObject response = new JSONObject(s);
                            String code = response.optString("code");
                            if (CmdMedia.SUCCESS_CODE.equals(code)) {
                                String data = response.optString("sdkAppConfig");
                                CmdMedia.this.parseData(data);
                            }
                        }
                        catch (Exception e) {
                            CS.log.v("TMS_MEDIA", "ConfigMedia Error:" + e.toString());
                            if (null == CmdMedia.this.callback) break block4;
                            CmdMedia.this.callback.onRequestFailed(e.toString());
                        }
                    }
                }
            }

            public void onFailure(int i, String s, Throwable throwable) {
                CS.log.v("TMS_MEDIA", "ConfigMedia Error:" + s);
                if (null != CmdMedia.this.callback) {
                    CmdMedia.this.callback.onRequestFailed(s);
                }
            }
        });
    }

    private void parseData(String jsonData) {
        if (!TextUtils.isEmpty((CharSequence)jsonData)) {
            try {
                String permissionList;
                SdkAppConfig sdkAppConfig;
                if (null != this.callback && null != (sdkAppConfig = (SdkAppConfig)Tson.fromJson((String)jsonData, SdkAppConfig.class)) && !TextUtils.isEmpty((CharSequence)sdkAppConfig.getPermissionList()) && (permissionList = sdkAppConfig.getPermissionList().toLowerCase()).contains("silentinstall")) {
                    this.callback.onRequestSuccess(null);
                }
            }
            catch (Exception e) {
                this.callback.onRequestFailed(null);
                CS.log.v("TMS_APP", "\u89e3\u6790Config Error:" + e.toString());
            }
        }
    }
}

