/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.media;

import android.text.TextUtils;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.http.HttpTool;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.manager.PhoneInfoManager;
import com.transsion.appupdate.media.BaseMedia;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.appupdate.reportBean.RecordStateData;
import com.transsion.appupdate.reportBean.SyncAction;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.common.bean.ConfigInfo;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.StringCallback;
import com.transsion.json.Tson;
import org.json.JSONObject;

public class ConfigMedia
extends BaseMedia {
    private static ConfigMedia configMedia = null;

    public static ConfigMedia getInstance() {
        if (null == configMedia) {
            configMedia = new ConfigMedia();
        }
        return configMedia;
    }

    public void syncData(final IMediaCallback iMediaCallback) {
        long lastTime = SpUtil.getSP().getLong("CONFIG_LAST_TIME", 0L);
        long updateTime = (long)ConfigInfoManager.getInstance().getReqServerInterval() * 1000L;
        CS.log.d("TMS_MEDIA", "\u5f00\u59cb\u540c\u6b65 config,ConfigMedia -> updateTime: " + updateTime + " / intervalTime : " + Math.abs(System.currentTimeMillis() - lastTime));
        if (Math.abs(System.currentTimeMillis()) - lastTime > updateTime) {
            String json = PhoneInfoManager.getInstance().getPhoneInfoJson();
            CS.log.d("TMS_MEDIA", "ConfigMedia request: Json ->" + json);
            HttpTool.getTool().getConfig(json, (HttpCallbackImpl)new StringCallback(){

                public void onSuccess(int i, String s) {
                    CS.log.d("TMS_MEDIA", "ConfigMedia onCallbackSuccess: s->" + s);
                    if (!TextUtils.isEmpty((CharSequence)s)) {
                        try {
                            JSONObject response = new JSONObject(s);
                            String code = response.optString("code");
                            if ("200".equals(code)) {
                                String data = response.optString("config");
                                ConfigMedia.this.parseDataByTask(data, iMediaCallback);
                                SpUtil.getSP().putLong("CONFIG_LAST_TIME", System.currentTimeMillis());
                            } else {
                                Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(1, -2).getBundle());
                            }
                        }
                        catch (Exception e) {
                            CS.log.v("TMS_MEDIA", "ConfigMedia Error:" + e.toString());
                            if (null != iMediaCallback) {
                                iMediaCallback.onRequestFailed(e.toString());
                            }
                            Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(1, -3).getBundle());
                        }
                    }
                }

                public void onFailure(int i, String s, Throwable throwable) {
                    CS.log.v("TMS_MEDIA", "ConfigMedia Error:" + s);
                    if (null != iMediaCallback) {
                        iMediaCallback.onRequestFailed(s);
                    }
                    Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(1, -1).getBundle());
                }
            });
        }
    }

    @Override
    void parseData(String jsonData, IMediaCallback iMediaCallback) {
        if (!TextUtils.isEmpty((CharSequence)jsonData)) {
            try {
                ConfigInfo configInfo = (ConfigInfo)Tson.fromJson((String)jsonData, ConfigInfo.class);
                if (null != configInfo) {
                    SpUtil.getSP().putString("APP_CONFIG_INFO", jsonData);
                    ConfigInfoManager.getInstance().updateConfigInfo();
                    if (null != iMediaCallback) {
                        iMediaCallback.onRequestSuccess(null);
                    }
                    this.saveRecordState(configInfo);
                    Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(1, 0).getBundle());
                }
            }
            catch (Exception e) {
                CS.log.v("TMS_APP", "\u89e3\u6790Config Error:" + e.toString());
                Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(1, -3).getBundle());
            }
        }
    }

    private void saveRecordState(ConfigInfo configInfo) {
        RecordStateData recordState = FileUtil.readRecordStateData(CoreUtil.getContext());
        if (recordState != null) {
            recordState.setInvalidInterval(configInfo.getPrivacyPolicyInvalid());
        } else {
            recordState = new RecordStateData();
            recordState.setInvalidInterval(configInfo.getPrivacyPolicyInvalid());
        }
        FileUtil.saveRecordStateData(CoreUtil.getContext(), recordState);
    }
}

