/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.multiprocess;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.LauncherApps;
import android.content.pm.PackageInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.UserHandle;
import android.provider.Settings;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.RefWatcher;
import com.transsion.appupdate.multiprocess.AppAdapter;
import com.transsion.appupdate.receiver.NetworkReceiver;
import com.transsion.appupdate.receiver.UpdateBroadcastReceiver;
import com.transsion.appupdate.service.AppUpdateJobService;
import com.transsion.appupdate.service.DataCenterReportJobService;
import com.transsion.appupdate.service.TrackerJobService;
import com.transsion.appupdate.utils.CrashHandler;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.osupdate.Logger;

public class SingleProcessAppAdapter
implements AppAdapter {
    private Application mApp;
    private static NetworkReceiver networkReceiver = null;
    private UpdateBroadcastReceiver mUpdateBroadcastReceiver = null;
    private RefWatcher refWatcher;

    SingleProcessAppAdapter(Application app) {
        this.mApp = app;
    }

    @Override
    public void onCreate() {
        if (this.mApp == null) {
            return;
        }
        CS.log.d("TMS_APP", "Single process application initialize");
        this.initialize();
    }

    private void initialize() {
        CoreUtil.init((Context)this.mApp);
        DeviceInfo.getGAId();
        CoreUtil.setDebug((boolean)CSLib.SERVE_DEBUG);
        AthenaAnalytics.init((Context)this.mApp, (String)"TMS", (int)1019, (boolean)true);
        AthenaAnalytics.setTest((boolean)CSLib.TEST_MODE);
        AthenaAnalytics.setDebug((boolean)CSLib.SERVE_DEBUG);
        if (!CS.DEBUG_LOG) {
            CrashHandler.getInstance().init((Context)this.mApp);
        }
        AppUpdateJobService.startJob(this.mApp.getApplicationContext());
        TrackerJobService.startJob(this.mApp.getApplicationContext());
        DataCenterReportJobService.startJob(this.mApp.getApplicationContext());
        CS.log.v("TMS_APP", "App   AppUpdateJobService.startJob");
        if (null == networkReceiver) {
            networkReceiver = new NetworkReceiver();
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mApp.registerReceiver((BroadcastReceiver)networkReceiver, filter);
        if (CSLib.GDPR_OPEN) {
            this.checkPrivacyPolicy();
        }
        if (CSLib.OS_UPDATE) {
            this.registerUpdateBroadcastReceiver();
        }
        if (CSLib.WOODPECKER_OPEN) {
            this.initSecScanner();
        }
        this.refWatcher = this.setupLeakCanary();
    }

    @TargetApi(value=21)
    private void initSecScanner() {
        LauncherApps mLauncherApps = (LauncherApps)this.mApp.getSystemService("launcherapps");
        if (mLauncherApps != null) {
            mLauncherApps.registerCallback(new LauncherApps.Callback(){

                public void onPackageRemoved(String packageName, UserHandle user) {
                    CS.log.i("launcherapps", "onPackageRemoved:" + packageName);
                }

                public void onPackageAdded(String packageName, UserHandle user) {
                    CS.log.i("launcherapps", "onPackageAdded:" + packageName);
                    try {
                        PackageInfo info = PackageUtil.getPackageInfo((Context)SingleProcessAppAdapter.this.mApp, "com.clover.secscanner");
                        if (info == null || info.versionCode < 51) {
                            return;
                        }
                        Intent i = new Intent();
                        i.setComponent(new ComponentName("com.clover.secscanner", "com.clover.secscanner.ScanActivity"));
                        i.setData(Uri.parse((String)("pkg://" + packageName)));
                        i.setFlags(0x10000000);
                        SingleProcessAppAdapter.this.mApp.startActivity(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void onPackageChanged(String packageName, UserHandle user) {
                }

                public void onPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
                }

                public void onPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
                }
            });
        }
    }

    private void registerUpdateBroadcastReceiver() {
        if (this.mUpdateBroadcastReceiver == null) {
            this.mUpdateBroadcastReceiver = new UpdateBroadcastReceiver();
        }
        IntentFilter filter = new IntentFilter();
        String update_action = "INSTALL_ACTION";
        filter.addAction(update_action);
        filter.addAction("INSTALL_ACTION_OS");
        this.mApp.registerReceiver((BroadcastReceiver)this.mUpdateBroadcastReceiver, filter);
        Logger.d((String)"TMS_OS_UPDATE", (String)"\u6ce8\u518c\u4e86\u5e7f\u64ad");
    }

    private void checkPrivacyPolicy() {
        PrivacyPolicyUtil.resetReportStateByPrivacyPolicy();
        this.mApp.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"user_experience"), false, new ContentObserver(new Handler(Looper.getMainLooper())){

            public void onChange(boolean selfChange, Uri uri) {
                super.onChange(selfChange, uri);
                PrivacyPolicyUtil.resetReportStateByPrivacyPolicy();
            }
        });
    }

    private RefWatcher setupLeakCanary() {
        if (LeakCanary.isInAnalyzerProcess((Context)this.mApp)) {
            return RefWatcher.DISABLED;
        }
        return LeakCanary.install((Application)this.mApp);
    }

    @Override
    public RefWatcher getRefWatcher() {
        return this.refWatcher;
    }
}

