/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.transsion.appupdate.R;
import com.transsion.appupdate.application.GlideApp;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.oslabui.widgets.OsLabDownloadProgressBar;
import com.transsion.appupdate.utils.MeasureUtil;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;
import com.transsion.core.utils.ToastUtil;

public class OsLabAppItemView
extends RelativeLayout {
    private ImageView mIconView;
    private ImageView oslab_download_app_image;
    private TextView mNameView;
    private OsLabDownloadProgressBar mDownloadButton;
    private TextView mDetailView;
    private ImageView redCircle;

    public OsLabAppItemView(Context context) {
        this(context, null);
    }

    public OsLabAppItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setPaddingMinHeight();
        LayoutInflater.from((Context)context).inflate(R.layout.oslab_app_item_layout, (ViewGroup)this);
        this.initView();
    }

    private void setPaddingMinHeight() {
        int paddingTopBottom = this.getResources().getDimensionPixelSize(R.dimen.app_item_padding_top_bottom);
        this.setPadding(this.getResources().getDimensionPixelSize(R.dimen.app_item_padding_start), paddingTopBottom, this.getResources().getDimensionPixelSize(R.dimen.app_item_padding_end), paddingTopBottom);
        this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.app_item_min_height));
    }

    private void initView() {
        this.mIconView = (ImageView)this.findViewById(R.id.img_app_icon);
        this.oslab_download_app_image = (ImageView)this.findViewById(R.id.oslab_download_app_image);
        this.mNameView = (TextView)this.findViewById(R.id.text_app_name);
        this.redCircle = (ImageView)this.findViewById(R.id.red_circle);
        this.mDownloadButton = (OsLabDownloadProgressBar)this.findViewById(R.id.oslab_download_button);
        this.mDownloadButton.setMax(100);
        this.mDetailView = (TextView)this.findViewById(R.id.text_app_detail);
        int displayWidth = MeasureUtil.getDisplayWidth(this.getContext());
        if (displayWidth > 0) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.oslab_download_app_image.getLayoutParams();
            params.width = MeasureUtil.getDisplayWidth(this.getContext()) - OsLabAppItemView.dp2px(this.getContext(), 28.0f);
            params.height = (MeasureUtil.getDisplayWidth(this.getContext()) - OsLabAppItemView.dp2px(this.getContext(), 28.0f)) * 500 / 1024;
            this.oslab_download_app_image.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public OsLabDownloadProgressBar getStateBtn() {
        return this.mDownloadButton;
    }

    public void bindView(AppItem item) {
        if (UpdateConstants.STATE_INITIAL.equals(item.state)) {
            this.mNameView.setTextColor(this.getResources().getColor(R.color.os_lab_circle_red));
            this.redCircle.setVisibility(0);
        } else {
            this.mNameView.setTextColor(this.getResources().getColor(R.color.textColorPrimary));
            this.redCircle.setVisibility(8);
        }
        this.mNameView.setText((CharSequence)item.appName);
        this.mDetailView.setText((CharSequence)item.description);
        GlideApp.with(this.getContext()).load(item.appIconUrl).placeholder(R.drawable.ic_application_vector).error(R.drawable.ic_application_vector).into(this.mIconView);
        this.setState(item);
        GlideApp.with(this.getContext()).load(item.imgUrl).placeholder(R.drawable.oslab_download_img).override(960, 480).error(R.drawable.oslab_download_img).into(this.oslab_download_app_image);
    }

    public void updateDownloadStatus(DownloadState status, int apkType) {
        CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u72b6\u6001\uff1a" + (Object)((Object)status) + " , apkType :" + apkType);
        this.mDownloadButton.setDownloadState(status, apkType);
        if (status == DownloadState.INITIAL) {
            this.mNameView.setTextColor(this.getResources().getColor(R.color.os_lab_circle_red));
            this.redCircle.setVisibility(0);
        } else {
            this.mNameView.setTextColor(this.getResources().getColor(R.color.textColorPrimary));
            this.redCircle.setVisibility(8);
        }
    }

    public void setState(AppItem item) {
        this.updateDownloadStatus(DownloadState.valueOf(item.state), item.type);
        CS.log.d("TMS_UPDATE", "oslab setState:" + item.state);
        switch (DownloadState.valueOf(item.state)) {
            case INITIAL: {
                this.setInitial();
                break;
            }
            case WAITING: 
            case DOWNLOADING: 
            case PAUSE: {
                this.setDownloading(item);
                break;
            }
            case FAILED: {
                if (item.allSize == item.downloadSize) {
                    item.downloadSize = 0;
                }
                this.setError(item);
                break;
            }
            case FINISHED: 
            case INSTALLING: 
            case INSTALLED: {
                this.setDownloading(item);
                break;
            }
            case OPENED: {
                break;
            }
        }
    }

    private void setInitial() {
        this.setProgressAndBtnState(true);
    }

    private void setDownloading(AppItem item) {
        this.setProgressAndBtnState(true);
        this.updateDownloadProgress(item.downloadSize, item.allSize);
    }

    private void setError(AppItem item) {
        this.setProgressAndBtnState(true);
        this.updateDownloadProgress(item.downloadSize, item.allSize);
    }

    private String getErrorText(int errorType) {
        String errorStr = this.getContext().getString(R.string.download_fail);
        switch (errorType) {
            case 1: {
                return this.getContext().getString(R.string.network_error);
            }
            case 2: {
                return this.getContext().getString(R.string.lack_space);
            }
            case 3: {
                return this.getContext().getString(R.string.download_fail);
            }
            case 4: {
                return this.getContext().getString(R.string.install_fail);
            }
        }
        return errorStr;
    }

    private void setProgressAndBtnState(boolean isAble) {
        if (isAble) {
            this.mDownloadButton.setIndeterminate(false);
        } else {
            this.mDownloadButton.setIndeterminate(true);
        }
    }

    private int getPercent(int downloadSize, int allSize) {
        if (allSize != 0) {
            return (int)((long)downloadSize * 100L / (long)allSize);
        }
        return 0;
    }

    public void updateDownloadProgress(int downloadSize, int allSize) {
        int progress = this.getPercent(downloadSize, allSize);
        CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u8be6\u60c5\u8fdb\u5ea6\uff1a" + progress);
        this.mDownloadButton.setDownloadProgress(progress);
    }

    public void setOpen(AppItem item) {
        Intent intent;
        if (item == null || TextUtils.isEmpty((CharSequence)item.pkgName)) {
            CS.log.e("TMS_UPDATE", "\u5e94\u7528\u6253\u5f00\u5931\u8d25, item\u6216\u8005pkgName\u4e3a\u7a7a");
        }
        if ((intent = this.getContext().getPackageManager().getLaunchIntentForPackage(item.pkgName)) == null) {
            CS.log.e("TMS_UPDATE", "\u6253\u5f00\u5e94\u7528\u5931\u8d25\uff0c\u5e94\u7528\u4e0d\u5b58\u5728");
            ToastUtil.showToast((int)R.string.lab_app_remove);
            try {
                PackageManager pm = this.getContext().getApplicationContext().getPackageManager();
                int enabled = pm.getApplicationEnabledSetting(item.pkgName);
                if (enabled == 2 || enabled == 4 || enabled == 3) {
                    Toast.makeText((Context)this.getContext(), (int)R.string.unavailable_tip, (int)0).show();
                    return;
                }
                Intent localIntent = new Intent();
                localIntent.addFlags(0x10000000);
                localIntent.setData(Uri.parse((String)("oslab://" + item.pkgName + "/open")));
                this.getContext().startActivity(localIntent);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                Toast.makeText((Context)this.getContext(), (int)R.string.unavailable_tip, (int)0).show();
                return;
            }
        }
        intent.setFlags(337641472);
        this.getContext().startActivity(intent);
        OsLabTrackBean osLabTrackBean = new OsLabTrackBean(item.appVersionCode, item.pkgName, item.type);
        osLabTrackBean.setPageId("ol_main");
        TrackerOsLab.trackClick(TrackerOsLab.TID.TMS_OSLAB_OPEN_APP_LIST, osLabTrackBean);
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

