/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.transsion.appupdate.R;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.entity.ListItem;
import com.transsion.appupdate.oslabui.OsLabAppItemView;
import com.transsion.appupdate.oslabui.viewholder.BaseViewHolder;
import com.transsion.appupdate.oslabui.viewholder.OsLabAppViewHolder;
import java.util.ArrayList;
import java.util.List;

public class OsLabAppUpdateAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private ArrayList<ListItem> mList;
    private final int VIEWTYPE_APP = 1;
    private final int VIEWTYPE_INFO = 2;
    private LayoutInflater mInflater;
    private OnDownloadListener mDownListener;

    public OsLabAppUpdateAdapter(ArrayList<ListItem> list, LayoutInflater inflater, OnDownloadListener downListener) {
        this.mList = list;
        this.mInflater = inflater;
        this.mDownListener = downListener;
    }

    public int getItemViewType(int position) {
        if (this.mList == null) {
            throw new NullPointerException("Items datasource is null!");
        }
        if (this.mList.get(position) instanceof AppItem) {
            return 1;
        }
        return 2;
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new OsLabAppViewHolder((View)new OsLabAppItemView(parent.getContext()));
        }
        return new BaseViewHolder(this.mInflater.inflate(R.layout.oslab_info_item_layout, parent, false));
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        int viewType = this.getItemViewType(position);
        if (viewType == 1) {
            holder.bindView(position, (AppItem)this.mList.get(position), this.mDownListener);
        }
    }

    public void onBindViewHolder(BaseViewHolder holder, int position, List payloads) {
        this.onBindViewHolder(holder, position);
        if (payloads.isEmpty()) {
            return;
        }
        int type = (Integer)payloads.get(0);
        switch (type) {
            case 1: {
                holder.changeState((AppItem)this.mList.get(position));
                break;
            }
        }
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public void updateList(ArrayList<ListItem> list) {
        this.mList = list;
        this.notifyDataSetChanged();
    }

    public void notifyOsAppRemove(int position) {
        this.mList.remove(position);
        this.notifyItemRemoved(position);
    }

    public void notifyOsAppAdd(int position, ListItem item) {
        this.mList.add(position, item);
        this.notifyItemInserted(position);
    }

    public static interface OnDownloadListener {
        public void onDownload(int var1, AppItem var2);
    }
}

