/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import android.util.SparseIntArray;
import com.transsion.appupdate.R;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.IDownloadListener;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.entity.InfoItem;
import com.transsion.appupdate.entity.ListItem;
import com.transsion.appupdate.oslabui.OsLabContract;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.utils.AiMessageUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ToastUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class OsLabAppUpdatePresenter
implements OsLabContract.Presenter {
    private OsLabContract.View mView;
    private DataRepository mRepository;
    private ArrayList<ListItem> mList = new ArrayList();
    private HashMap<String, Integer> mUrlIndex = new HashMap();
    private SparseIntArray mInfoArray = new SparseIntArray(2);
    private AppDownloadTaskManager mDtm;
    private InstallCompleteReceiver mInstallReceiver;
    private DownloadListener mDownloadListener;
    private boolean isLoading;
    private int redCount = 0;
    private String activity = "com.transsion.appupdate.oslabui.OsLabActivity";
    private String mPackageName = "com.transsion.plat.appupdate";
    private List<ListItem> temp = new ArrayList<ListItem>();
    private long psts;
    private int type;

    OsLabAppUpdatePresenter(OsLabContract.View view) {
        this.mView = view;
        this.mRepository = DataRepository.getInstance(this.mView.getContext().getApplicationContext());
        this.mDtm = AppDownloadTaskManager.getInstance(this.mView.getContext());
        this.mInstallReceiver = new InstallCompleteReceiver();
        this.mDownloadListener = new DownloadListener();
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.transsion.appupdate.ACTION_INSTALL_COMMIT");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mView.getContext().registerReceiver((BroadcastReceiver)this.mInstallReceiver, filter);
        this.mDtm.registerDownloadCallback(this.mDownloadListener, OsLabAppDownLoadTask.class);
    }

    @Override
    public void loadData() {
        CS.log.d("TMS_UPDATE", "\u5f00\u59cb\u52a0\u8f7d\u6570\u636e");
        if (NetworkUtil.isConnected(this.mView.getContext().getApplicationContext())) {
            if (this.isLoading) {
                CS.log.d("TMS_UPDATE", "\u6b63\u5728\u52a0\u8f7d\u6570\u636e");
                return;
            }
            if (this.mList.isEmpty()) {
                this.mView.showLoadingView();
            }
            this.mList.clear();
            this.isLoading = true;
            this.mRepository.loadShowOsAppList(list -> {
                this.isLoading = false;
                CS.log.d("TMS_UPDATE", "\u6570\u636e\u52a0\u8f7d\u6210\u529f\uff0c list:" + list.size());
                if (list.size() > 1) {
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u52a0\u8f7d\u6210\u529f\uff0c list:" + list);
                    this.mList.addAll((Collection<ListItem>)list);
                    this.updatePkgIndex();
                    this.mView.showListView((ArrayList<ListItem>)list);
                    this.redCount = 0;
                    for (ListItem listItem : list) {
                        if (!(listItem instanceof AppItem)) continue;
                        AppItem appItem = (AppItem)listItem;
                        if (!UpdateConstants.STATE_INITIAL.equals(appItem.state)) continue;
                        ++this.redCount;
                    }
                    AiMessageUtil.setChangeBudge(CoreUtil.getContext(), this.mPackageName, this.activity, this.redCount);
                    if (this.redCount == 0) {
                        AiMessageUtil.setTipBudge(CoreUtil.getContext(), this.mPackageName, this.activity, 0);
                    }
                } else {
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u52a0\u8f7d\u6210\u529f\uff0c \u6570\u636e\u4e3a\u7a7a");
                    this.mView.showBlankView(false);
                    if (this.redCount == 0) {
                        AiMessageUtil.setChangeBudge(CoreUtil.getContext(), this.mPackageName, this.activity, 0);
                        AiMessageUtil.setTipBudge(CoreUtil.getContext(), this.mPackageName, this.activity, 0);
                    }
                }
            }, listPre -> {
                if (listPre.size() > 1) {
                    this.mView.showListViewPreload((ArrayList<ListItem>)listPre);
                }
            });
        } else {
            if (this.isLoading) {
                CS.log.d("TMS_UPDATE", "\u6b63\u5728\u52a0\u8f7d\u5df2\u7ecf\u5b89\u88c5\u6210\u529f\u7684\u6570\u636e");
                return;
            }
            if (this.mList.isEmpty()) {
                this.mView.showLoadingView();
            }
            this.mList.clear();
            this.isLoading = true;
            this.mRepository.loadShowOsAppInstallList(list -> {
                this.isLoading = false;
                if (list.size() > 1) {
                    CS.log.d("TMS_UPDATE", "\u5df2\u5b89\u88c5\u6570\u636e\u52a0\u8f7d\u6210\u529f\uff0c list:" + list);
                    this.mList.addAll((Collection<ListItem>)list);
                    this.updatePkgIndex();
                    this.mView.showListView((ArrayList<ListItem>)list);
                } else {
                    this.mView.showBlankView(false);
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u52a0\u8f7d\uff0c\u65e0\u7f51\u7edc");
                }
            });
        }
    }

    @Override
    public void requestAllDownload() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem appItem = (AppItem)this.mList.get(i);
            if (appItem.type != 1 || !UpdateConstants.STATE_INITIAL.equals(appItem.state) && !UpdateConstants.STATE_PAUSED.equals(appItem.state) && !UpdateConstants.STATE_FAILED.equals(appItem.state)) continue;
            this.requestDownload(appItem);
        }
    }

    @Override
    public void requestDownload(AppItem item) {
        if (UpdateConstants.STATE_INITIAL.equals(item.state) || UpdateConstants.STATE_PAUSED.equals(item.state) || UpdateConstants.STATE_FAILED.equals(item.state)) {
            if (StorageUtils.isLessThanUsagePercent(5L)) {
                ToastUtil.showLongToast((String)this.mView.getContext().getString(R.string.lack_space));
                return;
            }
            OsLabTrackBean osLabTrackBean = new OsLabTrackBean(item.appVersionCode, item.pkgName, item.type);
            osLabTrackBean.setPageId("ol_main");
            TrackerOsLab.trackClick(TrackerOsLab.TID.TMS_OSLAB_LIST_CLICK_DOWNLOAD, osLabTrackBean);
            if (UpdateConstants.STATE_INITIAL.equals(item.state)) {
                --this.redCount;
                AiMessageUtil.setChangeBudge(CoreUtil.getContext(), this.mPackageName, this.activity, this.redCount);
                if (this.redCount == 0) {
                    AiMessageUtil.setTipBudge(CoreUtil.getContext(), this.mPackageName, this.activity, 0);
                }
            }
            item.state = UpdateConstants.STATE_WAITING;
            this.startDownload(item);
        } else if (UpdateConstants.STATE_WAITING.equals(item.state) || UpdateConstants.STATE_DOWNLOADING.equals(item.state)) {
            item.state = UpdateConstants.STATE_PAUSED;
            this.pauseDownload(item);
        }
    }

    @Override
    public void startDownload(AppItem item) {
        OsLabAppDownLoadTask task = new OsLabAppDownLoadTask(item.apkUrl, item.md5, item.allSize, item.apkPath, DownloadState.WAITING, item.pkgName, item.appIconUrl, item.appName, item.appId, item.isSilentInstall, item.appVersionName, item.appVersionCode, item.type, item.description, item.imgUrl);
        this.mDtm.startDownload(task);
        this.mView.notifyItemChanged(this.mUrlIndex.get(item.apkUrl), 3);
    }

    @Override
    public void pauseDownload(AppItem item) {
        OsLabAppDownLoadTask task = OsLabAppDownLoadTask.obtain();
        task.url = item.apkUrl;
        task.filePath = item.apkPath;
        task.md5 = item.md5;
        task.downloadState = DownloadState.PAUSE;
        this.mDtm.pauseDownloadTask(task);
        this.mView.notifyItemChanged(this.mUrlIndex.get(item.apkUrl), 3);
        this.mRepository.updateAppItemState(task);
    }

    @Override
    public void stopDownload(AppItem item) {
        OsLabAppDownLoadTask task = OsLabAppDownLoadTask.obtain();
        task.url = item.apkUrl;
        task.filePath = item.apkPath;
        task.md5 = item.md5;
        this.mDtm.deleteDownloadTask(task);
        this.mView.notifyItemChanged(this.mUrlIndex.get(item.apkUrl), 3);
        this.mRepository.updateAppItemState(task);
    }

    private void updatePkgIndex() {
        this.mUrlIndex.clear();
        this.mInfoArray.clear();
        int appCount = 0;
        int installAppCount = 0;
        for (int i = 0; i < this.mList.size(); ++i) {
            if (this.mList.get(i) instanceof AppItem) {
                this.mUrlIndex.put(((AppItem)this.mList.get((int)i)).apkUrl, i);
                ++appCount;
                continue;
            }
            if (this.mList.get(i) instanceof InfoItem) {
                if (((InfoItem)this.mList.get((int)i)).showUpdate) {
                    this.mInfoArray.put(1, i);
                    continue;
                }
                if (((InfoItem)this.mList.get((int)i)).showdetails) {
                    this.mInfoArray.put(4, i);
                    continue;
                }
                this.mInfoArray.put(2, i);
                continue;
            }
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            ++installAppCount;
        }
        if (appCount == 0 && installAppCount == 0) {
            this.mView.showBlankView(false);
        }
    }

    private void showNetError() {
        this.mList.clear();
        this.mView.showBlankView(true);
    }

    @Override
    public void removeUninstallApp() {
        Context context = this.mView.getContext();
        if (context instanceof Activity && !((Activity)context).isDestroyed()) {
            String url = null;
            for (int index = 0; index < this.mList.size(); ++index) {
                PackageInfo packageInfo;
                ListItem item = this.mList.get(index);
                if (!(item instanceof AppItem) || !UpdateConstants.STATE_INSTALLED.equals(((AppItem)item).state) || (packageInfo = PackageUtil.getPackageInfo(context, ((AppItem)item).pkgName)) != null && (packageInfo == null || packageInfo.versionCode >= ((AppItem)item).appVersionCode)) continue;
                url = ((AppItem)item).apkUrl;
                this.mList.remove(item);
                this.mView.notifyItemRemove(index);
                this.updatePkgIndex();
                AppDownloadTaskManager.getInstance(context).deleteDownloadTask(new OsLabAppDownLoadTask(url));
            }
        }
    }

    private void installFinished(String pkgName, boolean success) {
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            return;
        }
        Context context = this.mView.getContext();
        if (context instanceof Activity && !((Activity)context).isDestroyed()) {
            String url = null;
            for (ListItem item : this.mList) {
                if (!(item instanceof AppItem) || !pkgName.equals(((AppItem)item).pkgName)) continue;
                url = ((AppItem)item).apkUrl;
            }
            Integer index = this.mUrlIndex.get(url);
            if (index == null || this.mList.size() == 0) {
                return;
            }
            if (this.mList.get(index) instanceof AppItem) {
                ListItem item;
                item = (AppItem)this.mList.get(index);
                if (!UpdateConstants.STATE_INSTALLED.equals(((AppItem)item).state)) {
                    if (success) {
                        ((AppItem)item).state = UpdateConstants.STATE_INSTALLED;
                    } else {
                        ((AppItem)item).state = UpdateConstants.STATE_FAILED;
                        ((AppItem)item).errorType = 4;
                        ToastUtil.showLongToast((int)R.string.install_fail);
                    }
                }
                this.mView.notifyItemChanged(index, 3);
            }
        }
    }

    private void updateInfoItem(int type) {
        int index = this.mInfoArray.get(type);
        InfoItem updateInfo = (InfoItem)this.mList.get(index);
        --updateInfo.count;
        if (updateInfo.count == 0) {
            this.mList.remove(index);
            this.mView.notifyItemRemove(index);
            this.updatePkgIndex();
            return;
        }
        this.mView.notifyItemChanged(index, 2);
    }

    @Override
    public boolean canUpdateAll() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem appItem = (AppItem)this.mList.get(i);
            if (appItem.type != 1 || !UpdateConstants.STATE_INITIAL.equals(appItem.state) && !UpdateConstants.STATE_PAUSED.equals(appItem.state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pauseAll() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem appItem = (AppItem)this.mList.get(i);
            if (!UpdateConstants.STATE_WAITING.equals(appItem.state) && !UpdateConstants.STATE_DOWNLOADING.equals(appItem.state)) continue;
            appItem.state = UpdateConstants.STATE_PAUSED;
            this.pauseDownload(appItem);
            OsLabAppDownLoadTask task = new OsLabAppDownLoadTask(appItem.apkUrl);
            task.downloadState = DownloadState.PAUSE;
            this.mRepository.updateAppItemState(task);
        }
    }

    @Override
    public boolean isEditable() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem item = (AppItem)this.mList.get(i);
            if (!UpdateConstants.STATE_WAITING.equals(item.state) && !UpdateConstants.STATE_DOWNLOADING.equals(item.state) && !UpdateConstants.STATE_PAUSED.equals(item.state) && !UpdateConstants.STATE_FAILED.equals(item.state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trackAppListEvent(TrackerOsLab.TID tid, AppItem item) {
        if (tid != null) {
            if (item != null) {
                OsLabTrackBean osLabTrackBean = new OsLabTrackBean(item.pkgName, item.appVersionCode, item.type, item.state);
                osLabTrackBean.setPageId("ol_main");
                TrackerOsLab.trackCommon(tid, osLabTrackBean);
            } else {
                OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200001, -1);
                osLabTrackBean.setPageId("ol_main");
                TrackerOsLab.trackClick(tid, osLabTrackBean);
            }
        }
    }

    public void trackAppEvent(int type) {
        OsLabTrackBean osLabTrackBean = new OsLabTrackBean(200001, type);
        osLabTrackBean.setPageId("ol_main");
        TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_ENTER, osLabTrackBean);
        this.psts = System.currentTimeMillis();
        this.type = type;
        OsLabTrackBean osLabTrackBean1 = new OsLabTrackBean(this.psts, 0L, type);
        osLabTrackBean1.setPageId("ol_main");
        TrackerOsLab.trackPV(TrackerOsLab.TID.TMS_OSLAB_MAIN_PV, osLabTrackBean1);
    }

    @Override
    public void onDestroy() {
        this.mDtm.unregisterDownloadCallback(this.mDownloadListener);
        this.mView.getContext().unregisterReceiver((BroadcastReceiver)this.mInstallReceiver);
        OsLabTrackBean osLabTrackBean1 = new OsLabTrackBean(this.psts, System.currentTimeMillis(), this.type);
        osLabTrackBean1.setPageId("ol_main");
        TrackerOsLab.trackPV(TrackerOsLab.TID.TMS_OSLAB_MAIN_PV, osLabTrackBean1);
    }

    private class InstallCompleteReceiver
    extends BroadcastReceiver {
        private InstallCompleteReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("com.transsion.appupdate.ACTION_INSTALL_COMMIT".equals(intent.getAction())) {
                int status = intent.getIntExtra("android.content.pm.extra.STATUS", 0);
                String msg = intent.getStringExtra("android.content.pm.extra.STATUS_MESSAGE");
                String pkg = intent.getStringExtra("android.content.pm.extra.PACKAGE_NAME");
                CS.log.d("TMS_DOWNLOAD", "\u5217\u8868\u9875\u9762\uff0c\u5b89\u88c5\u5b8c\u6210\uff0cInstallReceiver status:" + status + " msg:" + msg + " pkg:" + pkg);
                OsLabAppUpdatePresenter.this.installFinished(pkg, "INSTALL_SUCCEEDED".equals(msg));
            } else if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction()) && NetworkUtil.isConnected(context) && OsLabAppUpdatePresenter.this.mList.size() <= 0) {
                OsLabAppUpdatePresenter.this.loadData();
            }
        }
    }

    private class DownloadListener
    extends IDownloadListener<OsLabAppDownLoadTask> {
        private DownloadListener() {
        }

        @Override
        public void updateDownloadStatus(OsLabAppDownLoadTask task) {
            CS.log.d("TMS_DOWNLOAD", "OsLab App \u5217\u8868task\uff1a" + task.url + " : " + task.finishedSize + "/" + task.totalSize);
            Integer index = (Integer)OsLabAppUpdatePresenter.this.mUrlIndex.get(task.url);
            if (index == null || OsLabAppUpdatePresenter.this.mList.size() == 0) {
                return;
            }
            if (OsLabAppUpdatePresenter.this.mList.get(index) instanceof AppItem) {
                AppItem item = (AppItem)OsLabAppUpdatePresenter.this.mList.get(index);
                item.downloadSize = (int)task.finishedSize;
                item.allSize = (int)task.totalSize;
                if (!task.downloadState.name().equals(item.state)) {
                    item.state = task.downloadState.name();
                    item.errorType = task.downloadFailType;
                }
                if (DownloadState.FAILED.equals((Object)task.downloadState)) {
                    ToastUtil.showToast((int)R.string.download_fail);
                }
                OsLabAppUpdatePresenter.this.mView.notifyItemChanged(index, 3);
            }
        }
    }
}

