/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui.api_test;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.IDownloadListener;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.oslabui.api_test.OsLabAppListAdapterOnlyTest;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.common.log.CS;
import java.util.List;

public class OsLabAppListActivityOnlyTest
extends Activity {
    private RecyclerView mRvCreativeList;
    private List<OsLabAppDownLoadTask> osLabAppDownLoadTaskList;
    private OsLabAppListAdapterOnlyTest mOsLabAppListAdapterOnlyTest;
    private DownloadLister downloadLister;
    private InstallCompleteReceiver mInstallReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_os_lab_app_list);
        this.mRvCreativeList = (RecyclerView)this.findViewById(R.id.rv_os_lab_list);
        this.initViews();
        this.mInstallReceiver = new InstallCompleteReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.transsion.appupdate.ACTION_INSTALL_COMMIT");
        this.registerReceiver(this.mInstallReceiver, filter);
        this.downloadLister = new DownloadLister();
        AppDownloadTaskManager.getInstance(this.getApplicationContext()).registerDownloadCallback(this.downloadLister, OsLabAppDownLoadTask.class);
    }

    private void initViews() {
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.osLabAppDownLoadTaskList = AppDownloadTaskManager.getInstance(this.getApplicationContext()).getAllTask(OsLabAppDownLoadTask.obtain());
        for (OsLabAppDownLoadTask task : this.osLabAppDownLoadTaskList) {
            if (task.downloadState != DownloadState.INSTALLING || !PackageUtil.checkApkExist(this.getApplicationContext(), task.pkgName, task.appVersionCode)) continue;
            task.downloadState = DownloadState.INSTALLED;
            AppDownloadTaskManager.getInstance(this.getApplicationContext()).updateDownloadTaskStatus(task);
        }
        this.mOsLabAppListAdapterOnlyTest = new OsLabAppListAdapterOnlyTest((Context)this, this.osLabAppDownLoadTaskList);
        this.mRvCreativeList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvCreativeList.setAdapter((RecyclerView.Adapter)this.mOsLabAppListAdapterOnlyTest);
    }

    protected void onDestroy() {
        super.onDestroy();
        AppDownloadTaskManager.getInstance(this.getApplicationContext()).unregisterDownloadCallback(this.downloadLister);
        this.unregisterReceiver(this.mInstallReceiver);
    }

    class DownloadLister
    extends IDownloadListener<OsLabAppDownLoadTask> {
        DownloadLister() {
        }

        @Override
        public void updateDownloadStatus(OsLabAppDownLoadTask task) {
            for (int i = 0; i < OsLabAppListActivityOnlyTest.this.osLabAppDownLoadTaskList.size(); ++i) {
                OsLabAppDownLoadTask curTask = (OsLabAppDownLoadTask)OsLabAppListActivityOnlyTest.this.osLabAppDownLoadTaskList.get(i);
                if (task.appId != curTask.appId) continue;
                OsLabAppListActivityOnlyTest.this.osLabAppDownLoadTaskList.set(i, task);
                OsLabAppListActivityOnlyTest.this.mOsLabAppListAdapterOnlyTest.notifyItemChanged(i);
            }
        }
    }

    private class InstallCompleteReceiver
    extends BroadcastReceiver {
        private InstallCompleteReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("com.transsion.appupdate.ACTION_INSTALL_COMMIT".equals(intent.getAction())) {
                int status = intent.getIntExtra("android.content.pm.extra.STATUS", 0);
                String msg = intent.getStringExtra("android.content.pm.extra.STATUS_MESSAGE");
                String pkg = intent.getStringExtra("android.content.pm.extra.PACKAGE_NAME");
                CS.log.d("TMS_DOWNLOAD", "\u5217\u8868\u9875\u9762\uff0c\u5b89\u88c5\u5b8c\u6210\uff0cInstallReceiver status:" + status + " msg:" + msg + " pkg:" + pkg);
                for (int i = 0; i < OsLabAppListActivityOnlyTest.this.osLabAppDownLoadTaskList.size(); ++i) {
                    OsLabAppDownLoadTask curTask = (OsLabAppDownLoadTask)OsLabAppListActivityOnlyTest.this.osLabAppDownLoadTaskList.get(i);
                    if (!pkg.equals(curTask.pkgName) || !PackageUtil.checkApkExist(OsLabAppListActivityOnlyTest.this.getApplicationContext(), curTask.pkgName, curTask.appVersionCode)) continue;
                    curTask.downloadState = DownloadState.INSTALLED;
                    OsLabAppListActivityOnlyTest.this.osLabAppDownLoadTaskList.set(i, curTask);
                    OsLabAppListActivityOnlyTest.this.mOsLabAppListAdapterOnlyTest.notifyItemChanged(i);
                    AppDownloadTaskManager.getInstance(OsLabAppListActivityOnlyTest.this.getApplicationContext()).updateDownloadTaskStatus(curTask);
                }
            }
        }
    }
}

