/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui.detail;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.transsion.appupdate.R;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.detail.OsLabAppUpdateDetailContract;
import com.transsion.appupdate.oslabui.detail.OsLabAppUpdateDetailPresenter;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.oslabui.widgets.OsLabDetailDownloadProgressBar;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;
import java.util.Locale;

public class OsLabAppUpdateDetailActivity
extends Activity
implements OsLabAppUpdateDetailContract.View {
    private ImageView mIvDownloadAppIcon;
    private TextView mTvDownloadAppName;
    private TextView mTvDownloadAppVersion;
    private TextView mTvAppSize;
    private TextView mTvDownloadAppIntro;
    private OsLabDetailDownloadProgressBar mPbDownloadButton;
    private ImageView mIvDownloadAnimWave;
    private Animation mDownloadAnim;
    private TextView mBtnCancel;
    private float mProgress;
    private int likeNormal = R.drawable.ic_like_normal;
    private int likeClick = R.drawable.ic_like_click;
    private int disLikeNormal = R.drawable.ic_dislike_normal;
    private int disLikeClick = R.drawable.ic_dislike_click;
    private int mCurrentLikeImgResId = 0;
    private int mCurrentDisLikeImgResId = 0;
    private String mCurrentState = "";
    private String likeStateTag = "1##";
    private String dislikeStateTag = "0##";
    private OsLabAppUpdateDetailContract.Presenter mPresenter;
    private AppItem appItem;
    private ImageView likeIv;
    private ImageView disLikeIv;
    private String likeStateAll;
    private LinearLayout mLikeFeedbackLl;
    private View mLikeFeedbackLlDiv;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.oslab_activity_app_update_detail);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.mIvDownloadAppIcon = (ImageView)this.findViewById(R.id.iv_download_app_icon);
        this.mLikeFeedbackLl = (LinearLayout)this.findViewById(R.id.like_feedback_ll);
        this.mLikeFeedbackLlDiv = this.findViewById(R.id.like_feedback_ll_div);
        this.mTvDownloadAppName = (TextView)this.findViewById(R.id.tv_download_app_name);
        this.mTvDownloadAppVersion = (TextView)this.findViewById(R.id.tv_download_app_version);
        this.mTvAppSize = (TextView)this.findViewById(R.id.tv_app_size);
        this.mTvDownloadAppIntro = (TextView)this.findViewById(R.id.tv_download_app_intro);
        this.mPbDownloadButton = (OsLabDetailDownloadProgressBar)this.findViewById(R.id.pb_download_button);
        this.mIvDownloadAnimWave = (ImageView)this.findViewById(R.id.iv_download_anim_wave);
        this.findViewById(R.id.feedback).setOnClickListener(v -> {
            try {
                String feedback = "com.rlk.feedback";
                PackageManager pm = this.getContext().getApplicationContext().getPackageManager();
                int enabled = pm.getApplicationEnabledSetting(feedback);
                if (enabled == 2 || enabled == 4 || enabled == 3) {
                    Toast.makeText((Context)this.getContext(), (int)R.string.unavailable_tip, (int)0).show();
                    return;
                }
                ComponentName componentName = new ComponentName(feedback, "com.rlk.feedback.FeedBackEditActivity");
                Intent intent = new Intent();
                intent.putExtra("fbsortId", 2);
                intent.putExtra("catalogId", 7);
                intent.putExtra("app_name", this.appItem.appName);
                intent.putExtra("app_package", "com.oslab.feedback");
                intent.addFlags(0x4000000);
                System.out.println("=========appItem.appName=" + this.appItem.appName + "===============appItem.pkgName " + this.appItem.pkgName);
                intent.setComponent(componentName);
                this.getContext().startActivity(intent);
                OsLabTrackBean osLabTrackBean = new OsLabTrackBean(this.appItem.pkgName, this.appItem.appVersionCode, this.appItem.type, "");
                osLabTrackBean.setPageId("ol_carddetail");
                TrackerOsLab.trackClick(TrackerOsLab.TID.TMS_OSLAB_FEEDBACK_CLICK, osLabTrackBean);
            }
            catch (Exception e) {
                e.printStackTrace();
                Toast.makeText((Context)this.getContext(), (int)R.string.unavailable_tip, (int)0).show();
            }
        });
        this.likeIv = (ImageView)this.findViewById(R.id.like_iv);
        this.disLikeIv = (ImageView)this.findViewById(R.id.dislike_iv);
        this.mBtnCancel = (TextView)this.findViewById(R.id.cancel_but);
        this.mBtnCancel.getPaint().setFlags(8);
        this.initToolbar();
    }

    private void initToolbar() {
        TextView textTitle = (TextView)this.findViewById(R.id.text_title);
        textTitle.setSingleLine(true);
        textTitle.setEllipsize(TextUtils.TruncateAt.END);
        if (TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1) {
            textTitle.setGravity(5);
            this.mTvDownloadAppIntro.setGravity(5);
        }
        this.findViewById(R.id.btn_back).setOnClickListener(v -> this.finish());
    }

    private void setLightNavBar() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getWindow().getDecorView().setSystemUiVisibility(this.getWindow().getDecorView().getSystemUiVisibility() | 0x10);
        }
    }

    private void initData() {
        this.appItem = (AppItem)this.getIntent().getParcelableExtra("item_info");
        if (this.getIntent().getBooleanExtra("from_tms_service", false)) {
            this.mPresenter.checkDownload(this.appItem);
        }
        this.mPresenter = new OsLabAppUpdateDetailPresenter(this, this.appItem.pkgName);
        this.mPresenter.registerDownloadListener();
        this.mTvDownloadAppName.setText((CharSequence)this.appItem.appName);
        String version = this.getString(R.string.download_app_version) + this.appItem.appVersionName;
        this.mTvDownloadAppVersion.setText((CharSequence)version);
        String size = this.getString(R.string.download_app_size) + StorageUtils.convertFromByte(this.appItem.allSize);
        this.mTvAppSize.setText((CharSequence)size);
        this.mTvDownloadAppIntro.setText((CharSequence)this.appItem.description);
        this.updateDownloadProgress(this.appItem.downloadSize, this.appItem.allSize);
        this.updateDownloadStatus(DownloadState.valueOf(this.appItem.state));
        this.mPresenter.loadAppIcon(this.appItem.appIconUrl, this.mIvDownloadAppIcon);
        this.mPbDownloadButton.setOnClickListener(v -> this.mPresenter.requestDownload(this.appItem));
        this.mBtnCancel.setOnClickListener(v -> this.mPresenter.cancelDownload(this.appItem));
        this.mBtnCancel.setClickable(true);
        this.setCancelVisibility(DownloadState.valueOf(this.appItem.state));
        new Handler().post(() -> this.mPresenter.trackDetailEvent());
        this.likeStateAll = SpUtil.getSP().getString("OS_DETAIL_LIKE_STATE");
        if (this.likeStateAll.contains(this.appItem.pkgName + this.likeStateTag)) {
            this.mCurrentLikeImgResId = this.likeClick;
            this.mCurrentState = this.likeStateTag;
        } else {
            this.mCurrentLikeImgResId = this.likeNormal;
        }
        if (this.likeStateAll.contains(this.appItem.pkgName + this.dislikeStateTag)) {
            this.mCurrentDisLikeImgResId = this.disLikeClick;
            this.mCurrentState = this.dislikeStateTag;
        } else {
            this.mCurrentDisLikeImgResId = this.disLikeNormal;
        }
        this.likeIv.setImageResource(this.mCurrentLikeImgResId);
        this.disLikeIv.setImageResource(this.mCurrentDisLikeImgResId);
        this.findViewById(R.id.like_ll).setOnClickListener(v -> {
            if (this.mCurrentLikeImgResId == this.likeClick) {
                this.mCurrentLikeImgResId = this.likeNormal;
                this.mCurrentState = "";
            } else {
                this.mCurrentLikeImgResId = this.likeClick;
                this.mCurrentDisLikeImgResId = this.disLikeNormal;
                this.mCurrentState = this.likeStateTag;
            }
            this.disLikeIv.setImageResource(this.mCurrentDisLikeImgResId);
            this.likeIv.setImageResource(this.mCurrentLikeImgResId);
        });
        this.findViewById(R.id.dislike_ll).setOnClickListener(v -> {
            if (this.mCurrentDisLikeImgResId == this.disLikeClick) {
                this.mCurrentDisLikeImgResId = this.disLikeNormal;
                this.mCurrentState = "";
            } else {
                this.mCurrentDisLikeImgResId = this.disLikeClick;
                this.mCurrentLikeImgResId = this.likeNormal;
                this.mCurrentState = this.dislikeStateTag;
            }
            this.disLikeIv.setImageResource(this.mCurrentDisLikeImgResId);
            this.likeIv.setImageResource(this.mCurrentLikeImgResId);
        });
    }

    private void setCancelVisibility(DownloadState state) {
        this.mBtnCancel.setVisibility(8);
    }

    protected void onDestroy() {
        this.mPresenter.onDestroy();
        super.onDestroy();
        this.mPresenter.unregisterDownloadListener();
        this.mIvDownloadAnimWave.setVisibility(4);
        if (this.mDownloadAnim != null) {
            this.mDownloadAnim.cancel();
            this.mDownloadAnim = null;
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mLikeFeedbackLl.getVisibility() == 0) {
            String replace;
            String saveLikeStateAll = " ";
            if (!TextUtils.isEmpty((CharSequence)this.likeStateAll) && !TextUtils.isEmpty((CharSequence)(replace = this.likeStateAll.replace(this.appItem.pkgName + this.likeStateTag, "")))) {
                saveLikeStateAll = replace.replace(this.appItem.pkgName + this.dislikeStateTag, "");
            }
            int status = -1;
            if (!TextUtils.isEmpty((CharSequence)this.mCurrentState)) {
                String concat = saveLikeStateAll.concat(this.appItem.pkgName + this.mCurrentState);
                SpUtil.getSP().putString("OS_DETAIL_LIKE_STATE", concat);
                if (this.likeStateTag.equals(this.mCurrentState)) {
                    status = 1;
                } else if (this.dislikeStateTag.equals(this.mCurrentState)) {
                    status = 2;
                }
            } else {
                status = 0;
                SpUtil.getSP().putString("OS_DETAIL_LIKE_STATE", saveLikeStateAll);
            }
            OsLabTrackBean osLabTrackBean = new OsLabTrackBean(this.appItem.pkgName, this.appItem.appVersionCode, this.appItem.type, status);
            osLabTrackBean.setPageId("ol_carddetail");
            TrackerOsLab.trackClick(TrackerOsLab.TID.TMS_OSLAB_LIKE_DISLIKE_CLICK, osLabTrackBean);
        }
    }

    public void onLowMemory() {
        Glide.get((Context)this.getApplicationContext()).clearMemory();
    }

    public void onTrimMemory(int level) {
        if (level == 20) {
            Glide.get((Context)this.getApplicationContext()).clearMemory();
        }
        Glide.get((Context)this.getApplicationContext()).trimMemory(level);
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void updateDownloadStatus(DownloadState status) {
        CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u8be6\u60c5\u72b6\u6001\uff1a" + (Object)((Object)status));
        this.appItem.state = status.name();
        if (DownloadState.FAILED.toString().equals(status.name()) && this.appItem.downloadSize == this.appItem.allSize) {
            this.appItem.downloadSize = 0;
            this.updateDownloadProgress(0L, this.appItem.allSize);
        }
        this.mPbDownloadButton.setDownloadState(status, this.appItem.type);
        if (DownloadState.OPENED.toString().equals(status.name()) || DownloadState.INSTALLED.toString().equals(status.name())) {
            this.mLikeFeedbackLl.setVisibility(0);
            this.mLikeFeedbackLlDiv.setVisibility(0);
        }
        this.setCancelVisibility(status);
    }

    @Override
    public void updateDownloadProgress(long downloadSize, long allSize) {
        this.appItem.downloadSize = (int)downloadSize;
        this.appItem.allSize = (int)allSize;
        int progress = (int)(downloadSize * 100L / allSize);
        CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u8be6\u60c5\u8fdb\u5ea6\uff1a" + progress);
        this.mPbDownloadButton.setDownloadProgress(progress);
    }

    @Override
    public void startDownloadAnim() {
        float progressPercent = this.mProgress / 100.0f;
        float startX = (float)(0 - this.mIvDownloadAnimWave.getWidth()) + progressPercent * (float)this.mPbDownloadButton.getWidth();
        float endX = this.mPbDownloadButton.getWidth();
        this.mDownloadAnim = new TranslateAnimation(startX, endX, 0.0f, 0.0f);
        this.mDownloadAnim.setRepeatCount(0);
        this.mDownloadAnim.setDuration(2000L);
        this.mDownloadAnim.setStartOffset(500L);
        this.mDownloadAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                OsLabAppUpdateDetailActivity.this.mIvDownloadAnimWave.setVisibility(4);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mIvDownloadAnimWave.startAnimation(this.mDownloadAnim);
    }

    @Override
    public void stopDownloadAnim() {
        if (this.mDownloadAnim != null) {
            this.mDownloadAnim.cancel();
        }
    }

    @Override
    public String getDetailUrl() {
        return this.appItem != null ? this.appItem.apkUrl : null;
    }

    @Override
    public void finishDetail() {
        this.setResult(0);
        this.finish();
    }
}

