/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui.detail;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.Toast;
import com.transsion.appupdate.R;
import com.transsion.appupdate.application.GlideApp;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.IDownloadListener;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.detail.OsLabAppUpdateDetailContract;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.ui.main.AlertMobileFragment;
import com.transsion.appupdate.utils.AiMessageUtil;
import com.transsion.appupdate.utils.ButtonUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.utils.TimeUtil;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ToastUtil;
import java.lang.ref.WeakReference;

class OsLabAppUpdateDetailPresenter
implements OsLabAppUpdateDetailContract.Presenter {
    private static final int INSTALL_COMPLETE_WHAT = 1;
    private static final int INSTALL_SUCCEEDED = 1;
    private static final int INSTALL_FAILED = 0;
    private String pkgNam = "";
    private OsLabAppUpdateDetailContract.View mView;
    private AppDownloadTaskManager mDtm;
    private DataRepository mRepository;
    private DownloadListener mDownloadListener;
    private InstallCompleteReceiver mInstallReceiver;
    private static UpdateHandler mUpdateHandler;
    private long psts;

    OsLabAppUpdateDetailPresenter(OsLabAppUpdateDetailContract.View view, String pkgNamame) {
        this.mView = view;
        this.mDtm = AppDownloadTaskManager.getInstance(this.mView.getContext());
        this.pkgNam = pkgNamame;
        this.mRepository = DataRepository.getInstance(this.mView.getContext().getApplicationContext());
        this.mDownloadListener = new DownloadListener();
        this.mInstallReceiver = new InstallCompleteReceiver();
        mUpdateHandler = new UpdateHandler(this.mView);
    }

    @Override
    public void loadAppImage(String imgUrl, ImageView img) {
        GlideApp.with(this.mView.getContext()).load(imgUrl).error(R.drawable.download_detail_app_img).into(img);
    }

    @Override
    public void loadAppIcon(String imgUrl, ImageView img) {
        GlideApp.with(this.mView.getContext()).load(imgUrl).placeholder(R.drawable.ic_application_vector).error(R.drawable.ic_application_vector).into(img);
    }

    @Override
    public void checkDownload(AppItem item) {
        OsLabAppDownLoadTask task = this.mDtm.queryByUrl(new OsLabAppDownLoadTask(item.apkUrl));
        if (TextUtils.isEmpty((CharSequence)task.url)) {
            this.checkAndShowDialog(item, DownloadState.INITIAL, true);
        } else {
            CS.log.d("TMS_UPDATE", "\u8be6\u60c5\u9875\u9762\uff0c\u4efb\u52a1\u5b58\u5728\uff0curl:" + item.apkUrl);
            if (task.downloadState == DownloadState.INITIAL) {
                this.checkAndShowDialog(item, DownloadState.INITIAL, true);
            } else if (task.downloadState == DownloadState.PAUSE || task.downloadState == DownloadState.FAILED) {
                this.checkAndShowDialog(item, DownloadState.INITIAL, false);
            } else if (task.downloadState == DownloadState.INSTALLING) {
                item.state = UpdateConstants.STATE_INSTALLING;
            } else if (task.downloadState == DownloadState.DOWNLOADING) {
                item.state = UpdateConstants.STATE_DOWNLOADING;
            } else if (task.downloadState == DownloadState.WAITING) {
                item.state = UpdateConstants.STATE_WAITING;
            }
            item.downloadSize = (int)task.finishedSize;
        }
    }

    @Override
    public void requestDownload(AppItem item) {
        if (ButtonUtil.isFastDoubleClick()) {
            return;
        }
        switch (DownloadState.valueOf(item.state)) {
            case INITIAL: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u5f00\u59cb\u4e0b\u8f7d");
                this.checkAndShowDialog(item, DownloadState.WAITING, true);
                break;
            }
            case PAUSE: 
            case FAILED: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u5f00\u59cb\u4e0b\u8f7d");
                this.checkAndShowDialog(item, DownloadState.WAITING, false);
                break;
            }
            case WAITING: 
            case DOWNLOADING: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u6682\u505c\u4e0b\u8f7d");
                item.state = UpdateConstants.STATE_PAUSED;
                this.pauseDownload(item);
                break;
            }
            case FINISHED: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u5df2\u4e0b\u8f7d\u5b8c\u6210");
                break;
            }
            case INSTALLING: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u6b63\u5728\u5b89\u88c5...");
                break;
            }
            case INSTALLED: 
            case OPENED: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u5b89\u88c5\u5b89\u88c5\u5b8c\u6210,\u6253\u5f00\u5e94\u7528");
                this.openApplication(item);
            }
        }
    }

    @Override
    public void cancelDownload(AppItem item) {
        AlertDialog dialog = new AlertDialog.Builder(this.mView.getContext()).setMessage(R.string.confirm_message).setNegativeButton(0x1040000, null).setPositiveButton(17039370, (dialog1, which) -> {
            this.mDtm.deleteDownloadTask(new OsLabAppDownLoadTask(item.apkUrl));
            this.mView.finishDetail();
        }).create();
        dialog.show();
    }

    private void checkAndShowDialog(AppItem item, DownloadState state, boolean isRefreshRedCount) {
        if (StorageUtils.isLessThanUsagePercent(5L)) {
            ToastUtil.showLongToast((String)this.mView.getContext().getString(R.string.lack_space));
            return;
        }
        if (!NetworkUtil.isConnected(this.mView.getContext())) {
            ToastUtil.showToast((int)R.string.no_network);
            return;
        }
        if (NetworkUtil.isMobileData(this.mView.getContext())) {
            if (TimeUtil.isToday()) {
                item.state = state.name();
                this.startDownload(item, isRefreshRedCount);
            } else {
                AlertMobileFragment amf = new AlertMobileFragment();
                amf.setOnPositiveBtnListener(() -> {
                    item.state = state.name();
                    this.startDownload(item, isRefreshRedCount);
                });
                amf.show(((Activity)this.mView.getContext()).getFragmentManager(), "AlertMobileFragment");
            }
        } else {
            item.state = state.name();
            this.startDownload(item, isRefreshRedCount);
        }
    }

    private void openApplication(AppItem item) {
        Intent intent;
        if (item == null || TextUtils.isEmpty((CharSequence)item.pkgName)) {
            CS.log.e("TMS_UPDATE", "\u5e94\u7528\u6253\u5f00\u5931\u8d25, item\u6216\u8005pkgName\u4e3a\u7a7a");
        }
        if ((intent = this.mView.getContext().getPackageManager().getLaunchIntentForPackage(item.pkgName)) == null) {
            CS.log.e("TMS_UPDATE", "\u6253\u5f00\u5e94\u7528\u5931\u8d25\uff0c\u5e94\u7528\u4e0d\u5b58\u5728");
            ToastUtil.showToast((int)R.string.lab_app_remove);
            try {
                PackageManager pm = this.mView.getContext().getApplicationContext().getPackageManager();
                int enabled = pm.getApplicationEnabledSetting(item.pkgName);
                if (enabled == 2 || enabled == 4 || enabled == 3) {
                    Toast.makeText((Context)this.mView.getContext(), (int)R.string.unavailable_tip, (int)0).show();
                    return;
                }
                Intent localIntent = new Intent();
                localIntent.addFlags(0x10000000);
                localIntent.setData(Uri.parse((String)("oslab://" + item.pkgName + "/open")));
                this.mView.getContext().startActivity(localIntent);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                Toast.makeText((Context)this.mView.getContext(), (int)R.string.unavailable_tip, (int)0).show();
                return;
            }
        }
        intent.setFlags(337641472);
        this.mView.getContext().startActivity(intent);
        OsLabTrackBean osLabTrackBean = new OsLabTrackBean(item.appVersionCode, item.pkgName, item.type);
        osLabTrackBean.setPageId("ol_carddetail");
        TrackerOsLab.trackClick(TrackerOsLab.TID.TMS_OSLAB_OPEN_APP_DETAIL, osLabTrackBean);
    }

    private void startDownload(AppItem item, boolean isRefreshRedCount) {
        OsLabAppDownLoadTask task = new OsLabAppDownLoadTask(item.apkUrl, item.md5, item.allSize, item.apkPath, DownloadState.WAITING, item.pkgName, item.appIconUrl, item.appName, item.appId, item.isSilentInstall, item.appVersionName, item.appVersionCode, item.type, item.description, item.imgUrl);
        this.mDtm.startDownload(task);
        this.mView.updateDownloadProgress(item.downloadSize, item.allSize);
        this.mView.updateDownloadStatus(task.downloadState);
        OsLabTrackBean osLabTrackBean = new OsLabTrackBean(item.appVersionCode, item.pkgName, item.type);
        osLabTrackBean.setPageId("ol_carddetail");
        TrackerOsLab.trackClick(TrackerOsLab.TID.TMS_OSLAB_CLICKDOWNLOAD_DETAIL, osLabTrackBean);
        if (isRefreshRedCount) {
            String activity = "com.transsion.appupdate.oslabui.OsLabActivity";
            String mPackageName = "com.transsion.plat.appupdate";
            DataRepository mRepository = DataRepository.getInstance(CoreUtil.getContext().getApplicationContext());
            mRepository.loadOsLabRedCount(redCount -> {
                CS.log.d("TMS_MEDIA", "OsLabAppUpdateMedia  redCount=  " + redCount);
                AiMessageUtil.setChangeBudge(CoreUtil.getContext(), mPackageName, activity, redCount);
                if (redCount == 0) {
                    AiMessageUtil.setTipBudge(CoreUtil.getContext(), mPackageName, activity, 0);
                }
            });
        }
    }

    private void pauseDownload(AppItem item) {
        OsLabAppDownLoadTask task = OsLabAppDownLoadTask.obtain();
        task.url = item.apkUrl;
        task.filePath = item.apkPath;
        task.md5 = item.md5;
        task.downloadState = DownloadState.PAUSE;
        this.mDtm.pauseDownloadTask(task);
        this.mView.updateDownloadProgress(item.downloadSize, item.allSize);
        this.mView.updateDownloadStatus(task.downloadState);
        this.mRepository.updateAppItemState(task);
    }

    @Override
    public void registerDownloadListener() {
        this.mDtm.registerDownloadCallback(this.mDownloadListener, OsLabAppDownLoadTask.class);
        this.mView.getContext().registerReceiver((BroadcastReceiver)this.mInstallReceiver, new IntentFilter("com.transsion.appupdate.ACTION_INSTALL_COMMIT"));
    }

    @Override
    public void unregisterDownloadListener() {
        this.mDtm.unregisterDownloadCallback(this.mDownloadListener);
        this.mView.getContext().unregisterReceiver((BroadcastReceiver)this.mInstallReceiver);
    }

    @Override
    public void trackDetailEvent() {
        this.psts = System.currentTimeMillis();
        OsLabTrackBean osLabTrackBean = new OsLabTrackBean(this.psts, 0L, -1);
        osLabTrackBean.setPageId("ol_carddetail");
        TrackerOsLab.trackPV(TrackerOsLab.TID.TMS_OSLAB_DETAIL_PV, osLabTrackBean);
    }

    @Override
    public void onDestroy() {
        OsLabTrackBean osLabTrackBean1 = new OsLabTrackBean(this.psts, System.currentTimeMillis(), -1);
        osLabTrackBean1.setPageId("ol_carddetail");
        TrackerOsLab.trackPV(TrackerOsLab.TID.TMS_OSLAB_DETAIL_PV, osLabTrackBean1);
    }

    public class InstallCompleteReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra("android.content.pm.extra.STATUS", 0);
            String msg = intent.getStringExtra("android.content.pm.extra.STATUS_MESSAGE");
            String pkg = intent.getStringExtra("android.content.pm.extra.PACKAGE_NAME");
            if (OsLabAppUpdateDetailPresenter.this.pkgNam.equals(pkg)) {
                CS.log.d("TMS_DOWNLOAD", "\u8be6\u60c5\u9875\u9762\uff0c\u5b89\u88c5\u5b8c\u6210\uff0cInstallReceiver status:" + status + " msg:" + msg + " pkg:" + pkg);
                Message message = Message.obtain();
                message.what = 1;
                message.arg1 = "INSTALL_SUCCEEDED".equals(msg) ? 1 : 0;
                mUpdateHandler.sendMessage(message);
            }
        }
    }

    private static class UpdateHandler
    extends Handler {
        private WeakReference<OsLabAppUpdateDetailContract.View> mUpdateView;

        UpdateHandler(OsLabAppUpdateDetailContract.View view) {
            this.mUpdateView = new WeakReference<OsLabAppUpdateDetailContract.View>(view);
        }

        public void handleMessage(Message msg) {
            OsLabAppUpdateDetailContract.View view;
            super.handleMessage(msg);
            if (msg.what == 1 && (view = (OsLabAppUpdateDetailContract.View)this.mUpdateView.get()) != null) {
                if (msg.arg1 == 1) {
                    view.updateDownloadProgress(1L, 1L);
                    view.updateDownloadStatus(DownloadState.INSTALLED);
                } else if (msg.arg1 == 0) {
                    view.updateDownloadStatus(DownloadState.FAILED);
                    ToastUtil.showToast((int)R.string.install_fail);
                }
            }
        }
    }

    private class DownloadListener
    extends IDownloadListener<OsLabAppDownLoadTask> {
        private DownloadListener() {
        }

        @Override
        public void updateDownloadStatus(OsLabAppDownLoadTask task) {
            if (task.url.equals(OsLabAppUpdateDetailPresenter.this.mView.getDetailUrl())) {
                CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u72b6\u6001 " + task.downloadState.name() + "  " + task.finishedSize + "/" + task.totalSize);
                OsLabAppUpdateDetailPresenter.this.mView.updateDownloadProgress(task.finishedSize, task.totalSize);
                OsLabAppUpdateDetailPresenter.this.mView.updateDownloadStatus(task.downloadState);
                if (DownloadState.FAILED.equals((Object)task.downloadState)) {
                    Toast.makeText((Context)OsLabAppUpdateDetailPresenter.this.mView.getContext(), (int)R.string.download_fail, (int)0).show();
                }
            }
        }
    }
}

