/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui.util;

import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.transsion.athena.data.TrackData;
import com.transsion.ga.AthenaAnalytics;
import java.util.ArrayList;

@RequiresApi(api=3)
public class AthenaCust {
    private final TrackData trackData;
    private String eid;
    private int tid;

    public AthenaCust(String eid, int tid) {
        this.tid = tid;
        this.eid = eid;
        this.trackData = new TrackData();
    }

    private void trackBundle(String key, Bundle bundles) {
        if (bundles != null) {
            this.trackData.add(key, bundles);
        }
    }

    private void trackBundles(String key, ArrayList<Bundle> bundles) {
        if (bundles != null) {
            this.trackData.add(key, bundles);
        }
    }

    private void trackString(String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.trackData.add(key, value);
        }
    }

    public AthenaCust trackClick(Bundle eparam, Bundle ext) {
        this.trackBundle("eparam", eparam);
        this.trackBundle("ext", ext);
        return this;
    }

    public AthenaCust trackPV(long pageEnter, long pageExit, int scroll, Bundle ext) {
        this.trackData.add("psts", pageEnter);
        this.trackData.add("pets", pageExit);
        this.trackData.add("dph", scroll);
        this.trackBundle("ext", ext);
        return this;
    }

    public AthenaCust trackCommon(Bundle eparam, Bundle ext) {
        this.trackBundle("eparam", eparam);
        this.trackBundle("ext", ext);
        return this;
    }

    public AthenaCust trackCommon(ArrayList<Bundle> eparam, Bundle ext) {
        this.trackBundles("eparam", eparam);
        this.trackBundle("ext", ext);
        return this;
    }

    public AthenaCust trackCommon(ArrayList<Bundle> eparam, ArrayList<Bundle> ext) {
        this.trackBundles("eparam", eparam);
        this.trackBundles("ext", ext);
        return this;
    }

    public AthenaCust setPageId(String pageId) {
        this.trackString("pid", pageId);
        return this;
    }

    public AthenaCust setPageParam(Bundle pageParam) {
        this.trackBundle("pparam", pageParam);
        return this;
    }

    public AthenaCust setPageUrl(String pageUrl) {
        this.trackString("purl", pageUrl);
        return this;
    }

    public AthenaCust setPrePageUrl(String prePageUrl) {
        this.trackString("burl", prePageUrl);
        return this;
    }

    public AthenaCust setSource(String source) {
        this.trackString("source", source);
        return this;
    }

    public AthenaCust setUUID(String uuid) {
        this.trackString("uuid", uuid);
        return this;
    }

    public void submit() {
        AthenaAnalytics athenaAnalytics = AthenaAnalytics.getInstance((int)this.tid);
        athenaAnalytics.track(this.eid, this.trackData, this.tid);
    }
}

