/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.SparseArray;
import com.transsion.common.log.CS;

public class NetLinkedReceiver
extends BroadcastReceiver {
    private static final String TAG = "NetLinkedReceiver";
    public static final int TYPE_NONE = -1;
    public static final int TYPE_MOBILE = 0;
    public static final int TYPE_WIFI = 1;
    private static volatile NetLinkedReceiver mReceiver;
    private boolean mNetLinked = false;
    private int mType = -1;
    private int mSubType;
    private final SparseArray<NetLinkChangeListener> mLinkListeners = new SparseArray();
    private final SparseArray<NetTypeChangeListener> mTypeListeners = new SparseArray();

    private NetLinkedReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetLinkedReceiver getReceiver() {
        if (mReceiver != null) return mReceiver;
        Class<NetLinkedReceiver> clazz = NetLinkedReceiver.class;
        synchronized (NetLinkedReceiver.class) {
            if (mReceiver != null) return mReceiver;
            mReceiver = new NetLinkedReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mReceiver;
        }
    }

    public static void register(Context c) {
        NetLinkedReceiver.register(c, null);
    }

    public static void register(Context c, NetLinkChangeListener l) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        c.registerReceiver((BroadcastReceiver)NetLinkedReceiver.getReceiver(), filter);
        if (l != null) {
            NetLinkedReceiver.getReceiver().mLinkListeners.put(c.hashCode(), (Object)l);
        }
    }

    public static void unregister(Context c) {
        c.unregisterReceiver((BroadcastReceiver)NetLinkedReceiver.getReceiver());
        NetLinkedReceiver.getReceiver().mLinkListeners.delete(c.hashCode());
        NetLinkedReceiver.getReceiver().mTypeListeners.delete(c.hashCode());
    }

    public static void setNetLinkChangeListener(Context c, NetLinkChangeListener l) {
        if (l != null) {
            NetLinkedReceiver.getReceiver().mLinkListeners.put(c.hashCode(), (Object)l);
        }
    }

    public static void setNetTypeChangeListener(Context c, NetTypeChangeListener l) {
        if (l != null) {
            NetLinkedReceiver.getReceiver().mTypeListeners.put(c.hashCode(), (Object)l);
        }
    }

    public static boolean isNetLinked() {
        return NetLinkedReceiver.getReceiver().mNetLinked;
    }

    public static boolean isUseMobile() {
        return NetLinkedReceiver.getReceiver().mType == 0;
    }

    public static boolean isUseWIFI() {
        return NetLinkedReceiver.getReceiver().mType == 1;
    }

    public static boolean isNetwork4G() {
        return NetLinkedReceiver.isUseMobile() && 3 == MobileNetWorkType.getNetworkClass(NetLinkedReceiver.getReceiver().mSubType);
    }

    public static boolean isNetwork3G() {
        return NetLinkedReceiver.isUseMobile() && 2 == MobileNetWorkType.getNetworkClass(NetLinkedReceiver.getReceiver().mSubType);
    }

    public static boolean isNetwork2G() {
        return NetLinkedReceiver.isUseMobile() && 1 == MobileNetWorkType.getNetworkClass(NetLinkedReceiver.getReceiver().mSubType);
    }

    public void onReceive(Context context, Intent intent) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                CS.log.d("TMS_UPDATE", "ConnectivityManager is null");
                return;
            }
            NetworkInfo activeInfo = cm.getActiveNetworkInfo();
            boolean netLinked = false;
            int type = -1;
            if (activeInfo != null) {
                if (activeInfo.isConnected() && activeInfo.isAvailable()) {
                    netLinked = true;
                }
                type = activeInfo.getType();
                this.mSubType = activeInfo.getSubtype();
            } else {
                netLinked = false;
            }
            if (netLinked != this.mNetLinked) {
                this.mNetLinked = netLinked;
                this.setLinkChange();
            }
            if (type != this.mType) {
                this.mType = type;
                if (this.mNetLinked) {
                    this.setTypeChange(this.mType == 0);
                }
            }
        }
    }

    private void setLinkChange() {
        int size = this.mLinkListeners.size();
        for (int i = 0; i < size; ++i) {
            NetLinkChangeListener listener = (NetLinkChangeListener)this.mLinkListeners.get(this.mLinkListeners.keyAt(i));
            if (listener == null) continue;
            listener.onNetLinkChange(this.mNetLinked);
        }
    }

    private void setTypeChange(boolean isMobile) {
        int size = this.mTypeListeners.size();
        for (int i = 0; i < size; ++i) {
            NetTypeChangeListener listener = (NetTypeChangeListener)this.mTypeListeners.get(this.mTypeListeners.keyAt(i));
            if (listener == null) continue;
            listener.onNetTypeChange(isMobile);
        }
    }

    public static class MobileNetWorkType {
        public static final int NETWORK_TYPE_GPRS = 1;
        public static final int NETWORK_TYPE_EDGE = 2;
        public static final int NETWORK_TYPE_UMTS = 3;
        public static final int NETWORK_TYPE_CDMA = 4;
        public static final int NETWORK_TYPE_EVDO_0 = 5;
        public static final int NETWORK_TYPE_EVDO_A = 6;
        public static final int NETWORK_TYPE_1xRTT = 7;
        public static final int NETWORK_TYPE_HSDPA = 8;
        public static final int NETWORK_TYPE_HSUPA = 9;
        public static final int NETWORK_TYPE_HSPA = 10;
        public static final int NETWORK_TYPE_IDEN = 11;
        public static final int NETWORK_TYPE_EVDO_B = 12;
        public static final int NETWORK_TYPE_LTE = 13;
        public static final int NETWORK_TYPE_EHRPD = 14;
        public static final int NETWORK_TYPE_HSPAP = 15;
        public static final int NETWORK_TYPE_GSM = 16;
        public static final int NETWORK_TYPE_TD_SCDMA = 17;
        public static final int NETWORK_TYPE_IWLAN = 18;
        public static final int NETWORK_TYPE_LTE_CA = 19;
        public static final int NETWORK_CLASS_UNKNOWN = 0;
        public static final int NETWORK_CLASS_2_G = 1;
        public static final int NETWORK_CLASS_3_G = 2;
        public static final int NETWORK_CLASS_4_G = 3;

        public static int getNetworkClass(int networkType) {
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    return 1;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: {
                    return 2;
                }
                case 13: 
                case 18: 
                case 19: {
                    return 3;
                }
            }
            return 0;
        }
    }

    public static interface NetTypeChangeListener {
        public void onNetTypeChange(boolean var1);
    }

    public static interface NetLinkChangeListener {
        public void onNetLinkChange(boolean var1);
    }
}

