/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.detail;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.widget.ImageView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.application.GlideApp;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.IDownloadListener;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.reportBean.TrafficDialogClickData;
import com.transsion.appupdate.reportBean.TrafficDialogShowData;
import com.transsion.appupdate.reportBean.UserActionDLTaskData;
import com.transsion.appupdate.ui.detail.AppUpdateDetailContract;
import com.transsion.appupdate.ui.main.AlertMobileFragment;
import com.transsion.appupdate.utils.ButtonUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.utils.TimeUtil;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.bean.SdkAppConfig;
import com.transsion.common.log.CS;
import com.transsion.core.utils.ToastUtil;
import java.lang.ref.WeakReference;

class AppUpdateDetailPresenter
implements AppUpdateDetailContract.Presenter {
    private static final int INSTALL_COMPLETE_WHAT = 1;
    private static final int INSTALL_SUCCEEDED = 1;
    private static final int INSTALL_FAILED = 0;
    private AppUpdateDetailContract.View mView;
    private AppDownloadTaskManager mAdtm;
    private DataRepository mRepository;
    private DownloadListener mDownloadListener;
    private InstallCompleteReceiver mInstallReceiver;
    private static UpdateHandler mUpdateHandler;

    AppUpdateDetailPresenter(AppUpdateDetailContract.View view) {
        this.mView = view;
        this.mAdtm = AppDownloadTaskManager.getInstance(this.mView.getContext());
        this.mRepository = DataRepository.getInstance(this.mView.getContext().getApplicationContext());
        this.mDownloadListener = new DownloadListener();
        this.mInstallReceiver = new InstallCompleteReceiver();
        mUpdateHandler = new UpdateHandler(this.mView);
    }

    @Override
    public void loadAppImage(String imgUrl, ImageView img) {
        GlideApp.with(this.mView.getContext()).load(imgUrl).error(R.drawable.download_detail_app_img).into(img);
    }

    @Override
    public void loadAppIcon(String imgUrl, ImageView img) {
        GlideApp.with(this.mView.getContext()).load(imgUrl).placeholder(R.drawable.ic_application_vector).error(R.drawable.ic_application_vector).into(img);
    }

    @Override
    public void checkDownload(AppItem item) {
        if (PackageUtil.checkApkExist(this.mView.getContext(), item.pkgName, item.appVersionCode)) {
            this.mView.updateDownloadProgress(1L, 1L);
            this.mView.updateDownloadStatus(DownloadState.INSTALLED);
            return;
        }
        AppDownLoadTask task = this.mAdtm.queryByUrl(new AppDownLoadTask(item.apkUrl));
        if (TextUtils.isEmpty((CharSequence)task.url)) {
            this.checkAndShowDialog(item, DownloadState.INITIAL, true);
        } else {
            CS.log.d("TMS_UPDATE", "\u8be6\u60c5\u9875\u9762\uff0c\u4efb\u52a1\u5b58\u5728\uff0curl:" + item.apkUrl);
            if (task.downloadState == DownloadState.INITIAL || task.downloadState == DownloadState.PAUSE || task.downloadState == DownloadState.FAILED) {
                this.checkAndShowDialog(item, DownloadState.INITIAL, true);
            } else if (task.downloadState == DownloadState.INSTALLING) {
                item.state = UpdateConstants.STATE_INSTALLING;
            } else if (task.downloadState == DownloadState.DOWNLOADING) {
                item.state = UpdateConstants.STATE_DOWNLOADING;
            } else if (task.downloadState == DownloadState.WAITING) {
                item.state = UpdateConstants.STATE_WAITING;
            }
            item.downloadSize = (int)task.finishedSize;
        }
    }

    @Override
    public void requestDownload(AppItem item) {
        if (ButtonUtil.isFastDoubleClick()) {
            return;
        }
        switch (DownloadState.valueOf(item.state)) {
            case INITIAL: 
            case PAUSE: 
            case FAILED: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u5f00\u59cb\u4e0b\u8f7d");
                this.trackDetailClickBtnEvent(Tracker.TID.TMS_DETAIL_CLICK_DOWNLOAD, item, 1);
                this.checkAndShowDialog(item, DownloadState.WAITING);
                break;
            }
            case WAITING: 
            case DOWNLOADING: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u6682\u505c\u4e0b\u8f7d");
                this.trackDetailClickBtnEvent(Tracker.TID.TMS_DETAIL_CLICK_DOWNLOAD, item, 2);
                item.state = UpdateConstants.STATE_PAUSED;
                this.pauseDownload(item);
                break;
            }
            case FINISHED: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u5df2\u4e0b\u8f7d\u5b8c\u6210");
                break;
            }
            case INSTALLING: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u6b63\u5728\u5b89\u88c5...");
                break;
            }
            case INSTALLED: 
            case OPENED: {
                CS.log.d("TMS_UPDATE", "\u70b9\u51fb\u5b89\u88c5\u5b89\u88c5\u5b8c\u6210,\u6253\u5f00\u5e94\u7528");
                this.openApplication(item);
            }
        }
    }

    @Override
    public void cancelDownload(AppItem item) {
        AlertDialog dialog = new AlertDialog.Builder(this.mView.getContext()).setMessage(R.string.confirm_message).setNegativeButton(0x1040000, null).setPositiveButton(17039370, (dialog1, which) -> {
            this.mAdtm.deleteDownloadTask(new AppDownLoadTask(item.apkUrl));
            this.mView.finishDetail();
        }).create();
        dialog.show();
    }

    private void checkAndShowDialog(AppItem item, DownloadState state) {
        this.checkAndShowDialog(item, state, false);
    }

    private void checkAndShowDialog(AppItem item, DownloadState state, boolean isFirstEnterByTMS) {
        if (item == null) {
            CS.log.w("TMS_UPDATE", "download click but item is null");
            return;
        }
        if (StorageUtils.isLessThanUsagePercent(5L)) {
            ToastUtil.showLongToast((String)this.mView.getContext().getString(R.string.lack_space));
            return;
        }
        if (!NetworkUtil.isConnected(this.mView.getContext())) {
            ToastUtil.showToast((int)R.string.no_network);
            return;
        }
        if (NetworkUtil.isMobileData(this.mView.getContext())) {
            SdkAppConfig mediaAppConfig = null;
            if (!TextUtils.isEmpty((CharSequence)item.mediaPkgName)) {
                String mediaSign = PackageUtil.getSignWrap(this.mView.getContext(), item.mediaPkgName);
                mediaAppConfig = DBManager.getInstance().getSdkAppConfigByPkgName(item.mediaPkgName, mediaSign);
                if (isFirstEnterByTMS && mediaAppConfig.getFastDownload() != 1) {
                    CS.log.d("TMS_UPDATE", "first enter by tms, but media AUTO DOWNLOAD is CLOSE");
                    return;
                }
            }
            if (TimeUtil.isToday()) {
                this.trackTrafficRemindShow(item, 3);
                item.state = state.name();
                this.startDownload(item);
            } else if (mediaAppConfig != null && mediaAppConfig.getFastDownload() == 1) {
                CS.log.d("TMS_UPDATE", "media AUTO DOWNLOAD OPEN, skip data dialog");
                this.trackTrafficRemindShow(item, 2);
                item.state = state.name();
                this.startDownload(item);
            } else if (mediaAppConfig != null && mediaAppConfig.getTrafficRemind() == 0) {
                CS.log.d("TMS_UPDATE", "media DATA TRAFFIC REMIND CLOSE, skip data dialog");
                this.trackTrafficRemindShow(item, 2);
                item.state = state.name();
                this.startDownload(item);
            } else {
                this.trackTrafficRemindShow(item, 0);
                AlertMobileFragment amf = new AlertMobileFragment();
                amf.setOnPositiveBtnListener(() -> {
                    if (TimeUtil.isToday()) {
                        this.trackTrafficRemindClick(item, 0);
                    } else {
                        this.trackTrafficRemindClick(item, 1);
                    }
                    item.state = state.name();
                    this.startDownload(item);
                });
                amf.setOnNegativeBtnListener(() -> this.trackTrafficRemindClick(item, 2));
                amf.setOnCancelListener(() -> this.trackTrafficRemindClick(item, 2));
                amf.show(((Activity)this.mView.getContext()).getFragmentManager(), "AlertMobileFragment");
            }
        } else {
            this.trackTrafficRemindShow(item, 1);
            item.state = state.name();
            this.startDownload(item);
        }
    }

    private void openApplication(AppItem item) {
        Intent intent;
        if (item == null || TextUtils.isEmpty((CharSequence)item.pkgName)) {
            CS.log.e("TMS_UPDATE", "\u5e94\u7528\u6253\u5f00\u5931\u8d25, item\u6216\u8005pkgName\u4e3a\u7a7a");
        }
        if ((intent = this.mView.getContext().getPackageManager().getLaunchIntentForPackage(item.pkgName)) != null) {
            intent.setFlags(337641472);
            this.mView.getContext().startActivity(intent);
        } else {
            CS.log.e("TMS_UPDATE", "\u6253\u5f00\u5e94\u7528\u5931\u8d25\uff0c\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        this.trackDetailEvent(Tracker.TID.TMS_DETAIL_CLICK_OPEN_APP, item);
    }

    private void startDownload(AppItem item) {
        if (!NetworkUtil.isConnected(this.mView.getContext())) {
            ToastUtil.showLongToast((String)this.mView.getContext().getString(R.string.no_network));
            return;
        }
        if (StorageUtils.isLessThanUsagePercent(5L)) {
            ToastUtil.showLongToast((String)this.mView.getContext().getString(R.string.lack_space));
            return;
        }
        AppDownLoadTask task = new AppDownLoadTask(item.apkUrl, item.md5, item.allSize, item.apkPath, DownloadState.WAITING, item.pkgName, item.appIconUrl, item.appName, item.appId, item.isSilentInstall, item.appVersionName, item.appVersionCode, item.type, item.description, item.imgUrl);
        task.mediaPkgName = item.mediaPkgName;
        task.CID = item.creativeID;
        this.mAdtm.startDownload(task);
        this.mView.updateDownloadProgress(item.downloadSize, item.allSize);
        this.mView.updateDownloadStatus(task.downloadState);
    }

    private void pauseDownload(AppItem item) {
        AppDownLoadTask task = AppDownLoadTask.obtain();
        task.url = item.apkUrl;
        task.filePath = item.apkPath;
        task.md5 = item.md5;
        task.downloadState = DownloadState.PAUSE;
        this.mAdtm.pauseDownloadTask(task);
        this.mView.updateDownloadProgress(item.downloadSize, item.allSize);
        this.mView.updateDownloadStatus(task.downloadState);
        this.mRepository.updateAppItemState(task);
    }

    @Override
    public void registerDownloadListener() {
        this.mAdtm.registerDownloadCallback(this.mDownloadListener, AppDownLoadTask.class);
        this.mView.getContext().registerReceiver((BroadcastReceiver)this.mInstallReceiver, new IntentFilter("com.transsion.appupdate.ACTION_INSTALL_COMMIT"));
    }

    @Override
    public void unregisterDownloadListener() {
        this.mAdtm.unregisterDownloadCallback(this.mDownloadListener);
        try {
            this.mView.getContext().unregisterReceiver((BroadcastReceiver)this.mInstallReceiver);
        }
        catch (Exception e) {
            CS.log.e("TMS_APP", e.getMessage());
        }
    }

    @Override
    public void trackDetailEvent(Tracker.TID tid, AppItem appItem) {
        if (tid != null && appItem != null) {
            UserActionDLTaskData data = new UserActionDLTaskData();
            data.setAppId(appItem.appId);
            data.setAppVersion(appItem.appVersionCode);
            data.setMediaPkgName(appItem.mediaPkgName);
            data.setCreativeId(appItem.creativeID);
            Tracker.track(tid, data.getBundle());
        }
    }

    private void trackDetailClickBtnEvent(Tracker.TID tid, AppItem appItem, int downloadStatus) {
        if (tid != null && appItem != null) {
            UserActionDLTaskData data = new UserActionDLTaskData();
            data.setAppId(appItem.appId);
            data.setAppVersion(appItem.appVersionCode);
            data.setMediaPkgName(appItem.mediaPkgName);
            data.setCreativeId(appItem.creativeID);
            data.setDownloadStatus(downloadStatus);
            Tracker.track(tid, data.getBundle());
        }
    }

    private void trackTrafficRemindShow(AppItem item, int showState) {
        TrafficDialogShowData data = new TrafficDialogShowData();
        data.setAppId(item.appId);
        data.setMediaPkgName(item.mediaPkgName);
        data.setCreativeId(item.creativeID);
        data.setPage(1);
        data.setShowState(showState);
        Tracker.track(Tracker.TID.TMS_TRAFFIC_REMIND_SHOW, data.getBundle());
    }

    private void trackTrafficRemindClick(AppItem item, int clickState) {
        TrafficDialogClickData data = new TrafficDialogClickData();
        data.setAppId(item.appId);
        data.setMediaPkgName(item.mediaPkgName);
        data.setCreativeId(item.creativeID);
        data.setPage(1);
        data.setClickState(clickState);
        Tracker.track(Tracker.TID.TMS_TRAFFIC_REMIND_CLICK, data.getBundle());
    }

    public static class InstallCompleteReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra("android.content.pm.extra.STATUS", 0);
            String msg = intent.getStringExtra("android.content.pm.extra.STATUS_MESSAGE");
            String pkg = intent.getStringExtra("android.content.pm.extra.PACKAGE_NAME");
            CS.log.d("TMS_DOWNLOAD", "\u8be6\u60c5\u9875\u9762\uff0c\u5b89\u88c5\u5b8c\u6210\uff0cInstallReceiver status:" + status + " msg:" + msg + " pkg:" + pkg);
            Message message = Message.obtain();
            message.what = 1;
            message.arg1 = "INSTALL_SUCCEEDED".equals(msg) ? 1 : 0;
            mUpdateHandler.sendMessage(message);
        }
    }

    private static class UpdateHandler
    extends Handler {
        private WeakReference<AppUpdateDetailContract.View> mUpdateView;

        UpdateHandler(AppUpdateDetailContract.View view) {
            this.mUpdateView = new WeakReference<AppUpdateDetailContract.View>(view);
        }

        public void handleMessage(Message msg) {
            AppUpdateDetailContract.View view;
            super.handleMessage(msg);
            if (msg.what == 1 && (view = (AppUpdateDetailContract.View)this.mUpdateView.get()) != null) {
                if (msg.arg1 == 1) {
                    view.updateDownloadProgress(1L, 1L);
                    view.updateDownloadStatus(DownloadState.INSTALLED);
                } else if (msg.arg1 == 0) {
                    view.updateDownloadStatus(DownloadState.FAILED);
                    ToastUtil.showLongToast((int)R.string.install_fail);
                }
            }
        }
    }

    private class DownloadListener
    extends IDownloadListener<AppDownLoadTask> {
        private DownloadListener() {
        }

        @Override
        public void updateDownloadStatus(AppDownLoadTask task) {
            if (task.url.equals(AppUpdateDetailPresenter.this.mView.getDetailUrl())) {
                CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u72b6\u6001 " + task.downloadState.name() + "  " + task.finishedSize + "/" + task.totalSize);
                AppUpdateDetailPresenter.this.mView.updateDownloadProgress(task.finishedSize, task.totalSize);
                AppUpdateDetailPresenter.this.mView.updateDownloadStatus(task.downloadState);
                if (DownloadState.FAILED.equals((Object)task.downloadState)) {
                    ToastUtil.showToast((int)R.string.download_fail);
                }
            }
        }
    }
}

