/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.main;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.util.SparseIntArray;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.IDownloadListener;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.entity.InfoItem;
import com.transsion.appupdate.entity.ListItem;
import com.transsion.appupdate.reportBean.RecordStateData;
import com.transsion.appupdate.reportBean.UserActionData;
import com.transsion.appupdate.ui.main.AppUpdateActivity;
import com.transsion.appupdate.ui.main.AppUpdateContract;
import com.transsion.appupdate.utils.AiMessageUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;
import com.transsion.core.utils.ToastUtil;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

class AppUpdatePresenter
implements AppUpdateContract.Presenter {
    private AppUpdateContract.View mView;
    private DataRepository mRepository;
    private ArrayList<ListItem> mList = new ArrayList();
    private HashMap<String, Integer> mUrlIndex = new HashMap();
    private SparseIntArray mInfoArray = new SparseIntArray(2);
    private AppDownloadTaskManager mAdtm;
    private InstallCompleteReceiver mInstallReceiver;
    private DownloadListener mDownloadListener;
    private boolean isLoading;

    AppUpdatePresenter(AppUpdateContract.View view) {
        this.mView = view;
        this.mRepository = DataRepository.getInstance(this.mView.getContext().getApplicationContext());
        this.mAdtm = AppDownloadTaskManager.getInstance(this.mView.getContext());
        this.mInstallReceiver = new InstallCompleteReceiver();
        this.mDownloadListener = new DownloadListener();
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.transsion.appupdate.ACTION_INSTALL_COMMIT");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mView.getContext().registerReceiver((BroadcastReceiver)this.mInstallReceiver, filter);
        this.mAdtm.registerDownloadCallback(this.mDownloadListener, AppDownLoadTask.class);
    }

    @Override
    public void loadData() {
        CS.log.d("TMS_UPDATE", "\u5f00\u59cb\u52a0\u8f7d\u6570\u636e");
        this.clearAppUpdateSettingsBadge();
        if (NetworkUtil.isConnected(this.mView.getContext().getApplicationContext())) {
            if (this.isLoading) {
                CS.log.d("TMS_UPDATE", "\u6b63\u5728\u52a0\u8f7d\u6570\u636e");
                return;
            }
            if (this.mList.isEmpty()) {
                this.mView.showLoadingView();
            }
            this.mList.clear();
            this.isLoading = true;
            this.mRepository.loadShowList(list -> {
                this.isLoading = false;
                if (list.size() > 0) {
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u52a0\u8f7d\u6210\u529f\uff0c list:" + list);
                    this.mList.addAll((Collection<ListItem>)list);
                    this.updatePkgIndex();
                    this.mView.showListView((ArrayList<ListItem>)list);
                } else {
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u52a0\u8f7d\u6210\u529f\uff0c \u6570\u636e\u4e3a\u7a7a");
                    this.mView.showBlankView(false);
                }
            });
        } else {
            this.mView.showBlankView(false);
            CS.log.d("TMS_UPDATE", "\u6570\u636e\u52a0\u8f7d\uff0c\u65e0\u7f51\u7edc");
        }
    }

    @Override
    public void requestAllDownload() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem appItem = (AppItem)this.mList.get(i);
            if (appItem.type != 1 || !UpdateConstants.STATE_INITIAL.equals(appItem.state) && !UpdateConstants.STATE_PAUSED.equals(appItem.state) && !UpdateConstants.STATE_FAILED.equals(appItem.state)) continue;
            this.requestDownload(appItem);
        }
    }

    @Override
    public void requestDownload(AppItem item) {
        if (UpdateConstants.STATE_INITIAL.equals(item.state) || UpdateConstants.STATE_PAUSED.equals(item.state) || UpdateConstants.STATE_FAILED.equals(item.state)) {
            if (StorageUtils.isLessThanUsagePercent(5L)) {
                ToastUtil.showLongToast((String)this.mView.getContext().getString(R.string.lack_space));
                return;
            }
            item.state = UpdateConstants.STATE_WAITING;
            this.startDownload(item);
        } else if (UpdateConstants.STATE_WAITING.equals(item.state) || UpdateConstants.STATE_DOWNLOADING.equals(item.state)) {
            item.state = UpdateConstants.STATE_PAUSED;
            this.pauseDownload(item);
        }
    }

    @Override
    public void startDownload(AppItem item) {
        AppDownLoadTask task = new AppDownLoadTask(item.apkUrl, item.md5, item.allSize, item.apkPath, DownloadState.WAITING, item.pkgName, item.appIconUrl, item.appName, item.appId, item.isSilentInstall, item.appVersionName, item.appVersionCode, item.type, item.description, item.imgUrl);
        this.mAdtm.startDownload(task);
        this.mView.notifyItemChanged(this.mUrlIndex.get(item.apkUrl), 3);
    }

    @Override
    public void pauseDownload(AppItem item) {
        AppDownLoadTask task = AppDownLoadTask.obtain();
        task.url = item.apkUrl;
        task.filePath = item.apkPath;
        task.md5 = item.md5;
        task.downloadState = DownloadState.PAUSE;
        this.mAdtm.pauseDownloadTask(task);
        this.mView.notifyItemChanged(this.mUrlIndex.get(item.apkUrl), 3);
        this.mRepository.updateAppItemState(task);
    }

    @Override
    public void stopDownload(AppItem item) {
        AppDownLoadTask task = AppDownLoadTask.obtain();
        task.url = item.apkUrl;
        task.filePath = item.apkPath;
        task.md5 = item.md5;
        this.mAdtm.deleteDownloadTask(task);
        this.mView.notifyItemChanged(this.mUrlIndex.get(item.apkUrl), 3);
        this.mRepository.updateAppItemState(task);
    }

    private void updatePkgIndex() {
        this.mUrlIndex.clear();
        this.mInfoArray.clear();
        int appCount = 0;
        for (int i = 0; i < this.mList.size(); ++i) {
            if (this.mList.get(i) instanceof AppItem) {
                this.mUrlIndex.put(((AppItem)this.mList.get((int)i)).apkUrl, i);
                ++appCount;
                continue;
            }
            if (!(this.mList.get(i) instanceof InfoItem)) continue;
            if (((InfoItem)this.mList.get((int)i)).showUpdate) {
                this.mInfoArray.put(1, i);
                continue;
            }
            this.mInfoArray.put(2, i);
        }
        if (appCount == 0) {
            this.mView.showBlankView(false);
        }
    }

    private void showNetError() {
        this.mList.clear();
        this.mView.showBlankView(true);
    }

    private void installFinished(String pkgName, boolean success) {
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            return;
        }
        Context context = this.mView.getContext();
        if (context instanceof Activity && !((Activity)context).isDestroyed()) {
            String url = null;
            for (ListItem item : this.mList) {
                if (!(item instanceof AppItem) || !pkgName.equals(((AppItem)item).pkgName)) continue;
                url = ((AppItem)item).apkUrl;
            }
            Integer index = this.mUrlIndex.get(url);
            if (index == null || this.mList.size() == 0) {
                return;
            }
            if (this.mList.get(index) instanceof AppItem) {
                ListItem item;
                item = (AppItem)this.mList.get(index);
                if (!UpdateConstants.STATE_INSTALLED.equals(((AppItem)item).state)) {
                    if (success) {
                        ((AppItem)item).state = UpdateConstants.STATE_INSTALLED;
                    } else {
                        ((AppItem)item).state = UpdateConstants.STATE_FAILED;
                        ((AppItem)item).errorType = 4;
                        ToastUtil.showLongToast((int)R.string.install_fail);
                    }
                }
                this.mView.notifyItemChanged(index, 3);
                this.updateInfoItem(((AppItem)item).type);
            }
        }
    }

    private void updateInfoItem(int type) {
        int index = this.mInfoArray.get(type);
        InfoItem updateInfo = (InfoItem)this.mList.get(index);
        --updateInfo.count;
        this.mView.notifyItemChanged(index, 2);
    }

    @Override
    public boolean canUpdateAll() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem appItem = (AppItem)this.mList.get(i);
            if (appItem.type != 1 || !UpdateConstants.STATE_INITIAL.equals(appItem.state) && !UpdateConstants.STATE_PAUSED.equals(appItem.state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pauseAll() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem appItem = (AppItem)this.mList.get(i);
            if (!UpdateConstants.STATE_WAITING.equals(appItem.state) && !UpdateConstants.STATE_DOWNLOADING.equals(appItem.state)) continue;
            appItem.state = UpdateConstants.STATE_PAUSED;
            this.pauseDownload(appItem);
            AppDownLoadTask task = new AppDownLoadTask(appItem.apkUrl);
            task.downloadState = DownloadState.PAUSE;
            this.mRepository.updateAppItemState(task);
        }
    }

    @Override
    public boolean isEditable() {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (!(this.mList.get(i) instanceof AppItem)) continue;
            AppItem item = (AppItem)this.mList.get(i);
            if (!UpdateConstants.STATE_WAITING.equals(item.state) && !UpdateConstants.STATE_DOWNLOADING.equals(item.state) && !UpdateConstants.STATE_PAUSED.equals(item.state) && !UpdateConstants.STATE_FAILED.equals(item.state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trackAppListEvent(Tracker.TID tid, AppItem item) {
        if (tid != null) {
            if (tid == Tracker.TID.TMS_NOTIFICATION_ENTER || tid == Tracker.TID.TMS_SETTING_ENTER || tid == Tracker.TID.TMS_APP_LIST_CLICK_EDIT) {
                Tracker.track(tid, null);
            } else if (item != null) {
                UserActionData data = new UserActionData();
                data.setAppId(item.appId);
                data.setAppVersion(item.appVersionCode);
                Tracker.track(tid, data.getBundle());
            }
        }
    }

    private void clearAppUpdateSettingsBadge() {
        if (this.mView == null || this.mView.getContext() == null || this.mView.getContext().getApplicationContext() == null) {
            return;
        }
        Context context = this.mView.getContext().getApplicationContext();
        RecordStateData recordStateData = FileUtil.readRecordStateData(context);
        if (recordStateData == null) {
            recordStateData = new RecordStateData();
        }
        recordStateData.setSettingBadgeCount(0);
        FileUtil.saveRecordStateData(context, recordStateData);
        AiMessageUtil.setChangeBudge(context, context.getPackageName(), AppUpdateActivity.class.getName(), 0);
        AiMessageUtil.setTipBudge(context, context.getPackageName(), AppUpdateActivity.class.getName(), 0);
        CS.log.d("TMS_APP", "AppUpdate Settings Badge: CLEAR");
    }

    @Override
    public void trackNewPhoneRecommendNotification(int apkType) {
        NewPhoneRecommendManager.trackNotificationClick((int)apkType);
    }

    @Override
    public void onDestroy() {
        this.clearAppUpdateSettingsBadge();
        this.mAdtm.unregisterDownloadCallback(this.mDownloadListener);
        this.mView.getContext().unregisterReceiver((BroadcastReceiver)this.mInstallReceiver);
    }

    private class InstallCompleteReceiver
    extends BroadcastReceiver {
        private InstallCompleteReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("com.transsion.appupdate.ACTION_INSTALL_COMMIT".equals(intent.getAction())) {
                int status = intent.getIntExtra("android.content.pm.extra.STATUS", 0);
                String msg = intent.getStringExtra("android.content.pm.extra.STATUS_MESSAGE");
                String pkg = intent.getStringExtra("android.content.pm.extra.PACKAGE_NAME");
                CS.log.d("TMS_DOWNLOAD", "\u5217\u8868\u9875\u9762\uff0c\u5b89\u88c5\u5b8c\u6210\uff0cInstallReceiver status:" + status + " msg:" + msg + " pkg:" + pkg);
                AppUpdatePresenter.this.installFinished(pkg, "INSTALL_SUCCEEDED".equals(msg));
            } else if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction()) && NetworkUtil.isConnected(context) && AppUpdatePresenter.this.mList.size() <= 0) {
                AppUpdatePresenter.this.loadData();
            }
        }
    }

    private class DownloadListener
    extends IDownloadListener<AppDownLoadTask> {
        private DownloadListener() {
        }

        @Override
        public void updateDownloadStatus(AppDownLoadTask task) {
            CS.log.d("TMS_DOWNLOAD", "App \u5217\u8868task\uff1a" + task.url + " : " + task.finishedSize + "/" + task.totalSize);
            Integer index = (Integer)AppUpdatePresenter.this.mUrlIndex.get(task.url);
            if (index == null || AppUpdatePresenter.this.mList.size() == 0) {
                return;
            }
            if (AppUpdatePresenter.this.mList.get(index) instanceof AppItem) {
                AppItem item = (AppItem)AppUpdatePresenter.this.mList.get(index);
                item.downloadSize = (int)task.finishedSize;
                item.allSize = (int)task.totalSize;
                if (!task.downloadState.name().equals(item.state)) {
                    item.state = task.downloadState.name();
                    item.errorType = task.downloadFailType;
                }
                AppUpdatePresenter.this.mView.notifyItemChanged(index, 3);
            }
        }
    }
}

