/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.main.viewholder;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.ui.detail.AppUpdateDetailActivity;
import com.transsion.appupdate.ui.main.AppItemView;
import com.transsion.appupdate.ui.main.AppUpdateAdapter;
import com.transsion.appupdate.ui.main.viewholder.BaseViewHolder;

public class AppViewHolder
extends BaseViewHolder {
    private AppItemView mItemView;

    public AppViewHolder(View itemView) {
        super(itemView);
        this.mItemView = (AppItemView)itemView;
    }

    @Override
    public void bindView(int pos, AppItem item, AppUpdateAdapter.OnDownloadListener downListener) {
        this.mItemView.bindView(item);
        this.mItemView.getStateBtn().setOnClickListener(v -> {
            if (downListener != null) {
                downListener.onDownload(pos, item);
            }
        });
        this.mItemView.setOnClickListener(v -> {
            Intent intent = new Intent(this.mItemView.getContext(), AppUpdateDetailActivity.class);
            Bundle bundle = new Bundle();
            bundle.putParcelable("item_info", (Parcelable)item);
            intent.putExtras(bundle);
            if (this.mItemView.getContext() instanceof Activity) {
                ((Activity)this.mItemView.getContext()).startActivityForResult(intent, 161);
            } else {
                this.mItemView.getContext().startActivity(intent);
            }
        });
    }

    @Override
    public void changeState(AppItem item) {
        this.mItemView.setState(item);
    }
}

