/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Parcel;
import android.os.UserHandle;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class PermissionUtil {
    private static final int FLAG_PERMISSION_USER_FIXED = 2;
    private static final int FLAG_PERMISSION_USER_SET = 1;
    private static final int OP_SYSTEM_ALERT_WINDOW = 24;
    private static final String STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String WINDOW_PERMISSION = "android.permission.SYSTEM_OVERLAY_WINDOW";

    public static int grantAppPermission(Context context, String packageName, String permissionName) {
        PackageInfo packageInfo;
        PermissionInfo permissionInfo = null;
        PackageManager packageManager = context.getPackageManager();
        try {
            permissionInfo = packageManager.getPermissionInfo(permissionName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PermissionInfo groupInfo = permissionInfo;
        if (groupInfo == null || permissionInfo == null) {
            return 0;
        }
        if (permissionInfo.group != null) {
            try {
                groupInfo = packageManager.getPermissionGroupInfo(permissionInfo.group, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        List permissionInfos = null;
        if (groupInfo instanceof PermissionGroupInfo) {
            try {
                permissionInfos = packageManager.queryPermissionsByGroup(groupInfo.name, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            packageInfo = null;
        }
        if (permissionInfos == null || permissionInfos.isEmpty()) {
            return 0;
        }
        for (String requestedPermission : packageInfo.requestedPermissions) {
            for (PermissionInfo permission : permissionInfos) {
                if (!requestedPermission.equals(permission.name)) continue;
                PermissionUtil.grantRuntimePermission(packageManager, packageName, permission.name, PermissionUtil.getUserHandle(context));
                return 1;
            }
        }
        return 0;
    }

    private static UserHandle getUserHandle(Context context) {
        int userId = 0;
        try {
            Method userIdMethod = Context.class.getMethod("getUserId", new Class[0]);
            try {
                userId = (Integer)userIdMethod.invoke((Object)context, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Parcel parcel = Parcel.obtain();
        parcel.writeInt(userId);
        UserHandle userHandle = new UserHandle(parcel);
        return userHandle;
    }

    private static void grantRuntimePermission(PackageManager packageManager, String packageName, String permissionName, UserHandle userHandle) {
        try {
            Method grantPermission = PackageManager.class.getMethod("grantRuntimePermission", String.class, String.class, UserHandle.class);
            Method updatePermissionFlags = PackageManager.class.getMethod("updatePermissionFlags", String.class, String.class, Integer.TYPE, Integer.TYPE, UserHandle.class);
            try {
                grantPermission.invoke((Object)packageManager, packageName, permissionName, userHandle);
                updatePermissionFlags.invoke((Object)packageManager, permissionName, packageName, 3, 0, userHandle);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public static void setCanDrawOverlay(Context context) {
        if (!PermissionUtil.checkWindowOp(context)) {
            PermissionUtil.setCanDrawOverlay(context, true, context.getPackageName());
        }
    }

    public static int setCanDrawOverlay(Context context, boolean newState, String packageName) {
        if (Build.VERSION.SDK_INT < 19) {
            return 1;
        }
        AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 8768);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"book", (String)"Exception when retrieving package:");
        }
        if (packageInfo == null) {
            return 0;
        }
        Method opMethod = null;
        try {
            opMethod = AppOpsManager.class.getMethod("setMode", Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE);
            opMethod.invoke((Object)appOpsManager, 24, packageInfo.applicationInfo.uid, packageName, newState ? 0 : 2);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean checkWindowOp(Context context) {
        return PermissionUtil.checkWindowOp(context, context.getPackageName());
    }

    public static boolean checkWindowOp(Context context, String pkgName) {
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        return PermissionUtil.getAppOps(context);
    }

    public static boolean getAppOps(Context context) {
        try {
            Class[] arrayOfClass;
            Object object = context.getSystemService("appops");
            if (object == null) {
                return false;
            }
            Class<?> localClass = object.getClass();
            Method method = localClass.getMethod("checkOp", arrayOfClass = new Class[]{Integer.TYPE, Integer.TYPE, String.class});
            if (method == null) {
                return false;
            }
            Object[] arrayOfObject1 = new Object[]{24, Binder.getCallingUid(), context.getPackageName()};
            int m = (Integer)method.invoke(object, arrayOfObject1);
            return m == 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }
}

