/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class SecurityUtil {
    public static final String DEFAULT_PASSWORD = "admaster";

    private static byte[] desEncrypt(byte[] dataSource, String password) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretkey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, (Key)secretkey, random);
            return cipher.doFinal(dataSource);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String desEncrypt(String dataSource) {
        return SecurityUtil.desEncrypt(dataSource, DEFAULT_PASSWORD);
    }

    public static String desEncrypt(String dataSource, String passWord) {
        try {
            byte[] data = SecurityUtil.desEncrypt(dataSource.getBytes(), passWord);
            return new String(Base64.encode((byte[])data, (int)2), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static byte[] desDecrypt(byte[] src, String password) throws Exception {
        SecureRandom random = new SecureRandom();
        DESKeySpec desKey = new DESKeySpec(password.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretkey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)secretkey, random);
        return cipher.doFinal(src);
    }

    public static String desDecrypt(String dataSource, String passWord) throws Exception {
        byte[] data = Base64.decode((String)dataSource, (int)2);
        return new String(SecurityUtil.desDecrypt(data, passWord), Charset.defaultCharset());
    }

    public static String desDecrypt(String dataSource) throws Exception {
        return SecurityUtil.desDecrypt(dataSource, DEFAULT_PASSWORD);
    }

    public static String getFileMD5(File file) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return SecurityUtil.bytesToHexString(digest.digest());
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getFileMD5Self(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (digest != null) {
            return Base64.encodeToString((byte[])digest.digest(), (int)2);
        }
        return null;
    }
}

