/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.data;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.RemoteException;
import android.text.TextUtils;
import com.transsion.appupdate.data.Callback;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadHelper;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.entity.InfoItem;
import com.transsion.appupdate.entity.ListItem;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.appupdate.media.MediaManager;
import com.transsion.appupdate.service.ICoreDataCallback;
import com.transsion.appupdate.utils.AppExecutors;
import com.transsion.appupdate.utils.CoreServiceTools;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.json.Tson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public final class DataRepository {
    private static volatile DataRepository sInstance;
    private final AppExecutors mExecutors;
    private Context mAppContext;
    private AppDownloadTaskManager mAdtm;

    private DataRepository(Context c) {
        this.mAppContext = c.getApplicationContext();
        this.mExecutors = AppExecutors.getInstance();
        this.mAdtm = AppDownloadTaskManager.getInstance(this.mAppContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataRepository getInstance(Context c) {
        if (sInstance != null) return sInstance;
        Class<DataRepository> clazz = DataRepository.class;
        synchronized (DataRepository.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DataRepository(c.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public void loadShowList(final Callback<ArrayList<ListItem>> callback) {
        this.mExecutors.work().execute(() -> {
            List<AppDownLoadTask> tasks = AppDownloadTaskManager.getInstance(this.mAppContext).getAllDownloadTask(AppDownLoadTask.obtain());
            CS.log.d("TMS_UPDATE", "\u6570\u636e\u5e93\u52a0\u8f7d\u6570\u636e\uff0c task\uff1a" + tasks);
            if (tasks == null || tasks.size() <= 0) {
                if (CSLib.IS_MULTI_PROCESS) {
                    if (CoreServiceTools.getTools().isBind()) {
                        if (CoreServiceTools.getTools().getCoreAidl() != null) {
                            this.requestDataFromCoreService(callback);
                        } else {
                            this.handlerTasks(null, callback);
                        }
                    } else {
                        CoreServiceTools.getTools().addOpenCallback(new CoreServiceTools.ICoreOpenCallback(){

                            @Override
                            public void onSuccess() {
                                DataRepository.this.requestDataFromCoreService(callback);
                            }

                            @Override
                            public void onFailed() {
                                DataRepository.this.handlerTasks(null, callback);
                            }
                        });
                    }
                } else {
                    MediaManager.getInstance().forceSyncAppUpdate(new IMediaCallback(){

                        public void onRequestSuccess(Object callBack) {
                            CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u6210\u529f\uff0c\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u5e93");
                            List<AppDownLoadTask> reTasks = AppDownloadTaskManager.getInstance(DataRepository.this.mAppContext).getAllDownloadTask(AppDownLoadTask.obtain());
                            DataRepository.this.handlerTasks(reTasks, callback);
                        }

                        @Override
                        public void onRequestFailed(String msg) {
                            CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u5931\u8d25");
                            DataRepository.this.handlerTasks(null, callback);
                        }
                    });
                }
            } else {
                this.handlerTasks(tasks, callback);
            }
        });
    }

    private void requestDataFromCoreService(final Callback<ArrayList<ListItem>> callback) {
        try {
            CoreServiceTools.getTools().getCoreAidl().requestAppUpdateData(new ICoreDataCallback.Stub(){

                @Override
                public void onSuccess(String response) throws RemoteException {
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        JSONArray savedNewTaskJsonArray = null;
                        try {
                            savedNewTaskJsonArray = new JSONArray(response);
                            for (int i = 0; i < savedNewTaskJsonArray.length(); ++i) {
                                AppDownLoadTask savedNewTask = (AppDownLoadTask)Tson.fromJson((String)savedNewTaskJsonArray.getString(i), AppDownLoadTask.class);
                                DownloadHelper.getInstance().addAppDownload(savedNewTask);
                            }
                        }
                        catch (JSONException e) {
                            CS.log.e("TMS_APP", e.getMessage());
                        }
                    }
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u6210\u529f\uff0c\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u5e93");
                    List<AppDownLoadTask> reTasks = AppDownloadTaskManager.getInstance(DataRepository.this.mAppContext).getAllDownloadTask(AppDownLoadTask.obtain());
                    DataRepository.this.handlerTasks(reTasks, callback);
                }

                @Override
                public void onFail(String response) throws RemoteException {
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u5931\u8d25");
                    DataRepository.this.handlerTasks(null, callback);
                }
            });
        }
        catch (RemoteException e) {
            CS.log.e("TMS_APP", e.getMessage());
            this.handlerTasks(null, callback);
        }
    }

    private void handlerTasks(List<AppDownLoadTask> tasks, Callback<ArrayList<ListItem>> callback) {
        int recommendCount;
        ArrayList<ListItem> list = new ArrayList<ListItem>();
        ArrayList<AppItem> updateItems = new ArrayList<AppItem>();
        ArrayList<AppItem> recommendItems = new ArrayList<AppItem>();
        this.taskToAppItem(1, tasks, updateItems);
        this.taskToAppItem(2, tasks, recommendItems);
        this.taskToAppItem(5, tasks, recommendItems);
        this.checkUpdateAndRecommendApk(updateItems, recommendItems);
        int updateCount = updateItems.size();
        if (updateCount > 0) {
            list.add(new InfoItem(updateCount, true, false, false));
            list.addAll(updateItems);
        }
        if ((recommendCount = recommendItems.size()) > 0) {
            list.add(new InfoItem(recommendCount, false, false, false));
            list.addAll(recommendItems);
        }
        this.mExecutors.ui().execute(() -> {
            if (callback != null) {
                callback.onCallback(list);
            }
        });
    }

    private void checkUpdateAndRecommendApk(List<AppItem> updateItems, List<AppItem> recommendItems) {
        PackageInfo packageInfo;
        ArrayList<AppItem> removeUpdateItems = new ArrayList<AppItem>();
        ArrayList<AppItem> removeRecommendItems = new ArrayList<AppItem>();
        for (AppItem item : updateItems) {
            packageInfo = PackageUtil.getPackageInfo(this.mAppContext, item.pkgName);
            if (packageInfo != null && packageInfo.versionCode < item.appVersionCode) continue;
            removeUpdateItems.add(item);
        }
        for (AppItem item : recommendItems) {
            packageInfo = PackageUtil.getPackageInfo(this.mAppContext, item.pkgName);
            if (packageInfo == null || packageInfo.versionCode < item.appVersionCode) continue;
            removeRecommendItems.add(item);
        }
        updateItems.removeAll(removeUpdateItems);
        recommendItems.removeAll(removeRecommendItems);
        removeUpdateItems.clear();
        removeRecommendItems.clear();
    }

    private void taskToAppItem(int apkType, List<AppDownLoadTask> tasks, List<AppItem> items) {
        if (tasks == null) {
            return;
        }
        for (AppDownLoadTask task : tasks) {
            AppItem item = new AppItem();
            item.pkgName = task.pkgName;
            item.appName = task.title;
            item.appIconUrl = task.iconUrl;
            item.appVersionName = task.appVersionName;
            item.appVersionCode = task.appVersionCode;
            item.apkUrl = task.url;
            item.apkPath = task.filePath;
            item.appInfo = null;
            item.apkSize = String.valueOf(task.totalSize);
            item.allSize = (int)task.totalSize;
            item.downloadSize = (int)task.finishedSize;
            item.state = task.downloadState.name();
            item.md5 = task.md5;
            item.type = task.apkType;
            item.appId = task.appId;
            item.description = task.description;
            item.imgUrl = task.imgUrl;
            item.isSilentInstall = true;
            item.errorType = task.downloadFailType;
            item.mediaPkgName = TextUtils.isEmpty((CharSequence)task.mediaPkgName) ? PackageUtil.getSelfPackageName(null) : task.mediaPkgName;
            item.creativeID = task.CID;
            if (task.apkType != apkType) continue;
            items.add(item);
        }
    }

    private void checkOsLabUpdateAndRecommendApk(List<AppItem> updateItems, List<AppItem> recommendItems) {
        PackageInfo packageInfo;
        ArrayList<AppItem> removeUpdateItems = new ArrayList<AppItem>();
        ArrayList<AppItem> removeRecommendItems = new ArrayList<AppItem>();
        for (AppItem item : updateItems) {
            packageInfo = PackageUtil.getPackageInfo(this.mAppContext, item.pkgName);
            if (packageInfo != null && packageInfo.versionCode < item.appVersionCode) continue;
            removeUpdateItems.add(item);
        }
        for (AppItem item : recommendItems) {
            packageInfo = PackageUtil.getPackageInfo(this.mAppContext, item.pkgName);
            if (packageInfo == null || packageInfo.versionCode < item.appVersionCode) continue;
            removeRecommendItems.add(item);
        }
        updateItems.removeAll(removeUpdateItems);
        recommendItems.removeAll(removeRecommendItems);
        removeUpdateItems.clear();
        removeRecommendItems.clear();
    }

    private void checkOsLabUpdateAndInstallItemsApk(List<AppItem> installItems) {
        ArrayList<AppItem> removeinstallItems = new ArrayList<AppItem>();
        for (AppItem item : installItems) {
            PackageInfo packageInfo = PackageUtil.getPackageInfo(this.mAppContext, item.pkgName);
            if (packageInfo != null) continue;
            removeinstallItems.add(item);
        }
        installItems.removeAll(removeinstallItems);
        removeinstallItems.clear();
    }

    private void checkOsLabUpdateAndInstallItemsApk(List<AppItem> updateItems, List<AppItem> installItems) {
        ArrayList<AppItem> removeinstallItems = new ArrayList<AppItem>();
        for (AppItem item : installItems) {
            PackageInfo packageInfo = PackageUtil.getPackageInfo(this.mAppContext, item.pkgName);
            if (packageInfo == null || packageInfo != null && packageInfo.versionCode < item.appVersionCode) {
                if (UpdateConstants.STATE_INSTALLING == item.state || UpdateConstants.STATE_FINISHED == item.state) continue;
                removeinstallItems.add(item);
                continue;
            }
            for (AppItem updateItem : updateItems) {
                if (!item.pkgName.equals(updateItem.pkgName) || item.appVersionCode >= updateItem.appVersionCode) continue;
                removeinstallItems.add(item);
                AppDownloadTaskManager.getInstance(this.mAppContext).deleteDownloadTask(new OsLabAppDownLoadTask(item.apkUrl));
            }
        }
        installItems.removeAll(removeinstallItems);
        removeinstallItems.clear();
    }

    public void loadShowOsAppList(final Callback<ArrayList<ListItem>> callback, Callback<ArrayList<ListItem>> callbackPre) {
        this.mExecutors.work().execute(() -> {
            List<OsLabAppDownLoadTask> tasks = AppDownloadTaskManager.getInstance(this.mAppContext).getAllDownloadTask(OsLabAppDownLoadTask.obtain());
            final List<OsLabAppDownLoadTask> reNewTasks = AppDownloadTaskManager.getInstance(this.mAppContext).getAllNewFeatureDownloadTask(OsLabAppDownLoadTask.obtain());
            CS.log.d("TMS_UPDATE", "\u6570\u636e\u5e93\u52a0\u8f7d\u6570\u636e\uff0c oslab task\uff1a" + tasks);
            if (tasks == null || tasks.size() <= 0) {
                if (reNewTasks != null && reNewTasks.size() > 0) {
                    this.handlerOsLabAppTasks(null, reNewTasks, callbackPre);
                }
                if (CSLib.IS_MULTI_PROCESS) {
                    if (CoreServiceTools.getTools().isBind()) {
                        if (CoreServiceTools.getTools().getCoreAidl() != null) {
                            this.requestOslabDataFromCoreService(callback, reNewTasks);
                        } else {
                            this.handlerOsLabAppTasks(null, reNewTasks, callback);
                        }
                    } else {
                        CoreServiceTools.getTools().addOpenCallback(new CoreServiceTools.ICoreOpenCallback(){

                            @Override
                            public void onSuccess() {
                                DataRepository.this.requestOslabDataFromCoreService(callback, reNewTasks);
                            }

                            @Override
                            public void onFailed() {
                                DataRepository.this.handlerOsLabAppTasks(null, reNewTasks, callback);
                            }
                        });
                    }
                } else {
                    MediaManager.getInstance().forceSyncOsLabAppUpdate(new IMediaCallback(){

                        public void onRequestSuccess(Object callBack) {
                            CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u6210\u529f\uff0c\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u5e93");
                            List<OsLabAppDownLoadTask> reTasks = AppDownloadTaskManager.getInstance(DataRepository.this.mAppContext).getAllDownloadTask(OsLabAppDownLoadTask.obtain());
                            List<OsLabAppDownLoadTask> reNewTasks2 = AppDownloadTaskManager.getInstance(DataRepository.this.mAppContext).getAllNewFeatureDownloadTask(OsLabAppDownLoadTask.obtain());
                            DataRepository.this.handlerOsLabAppTasks(reTasks, reNewTasks2, callback);
                        }

                        @Override
                        public void onRequestFailed(String msg) {
                            CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u5931\u8d25");
                            DataRepository.this.handlerOsLabAppTasks(null, reNewTasks, callback);
                        }
                    });
                }
            } else {
                this.handlerOsLabAppTasks(tasks, reNewTasks, callback);
            }
        });
    }

    public void loadOsLabRedCount(Callback<Integer> mCallback) {
        this.mExecutors.work().execute(() -> {
            List<OsLabAppDownLoadTask> tasks = AppDownloadTaskManager.getInstance(this.mAppContext).getAllDownloadTask(OsLabAppDownLoadTask.obtain());
            List<OsLabAppDownLoadTask> reNewTasks = AppDownloadTaskManager.getInstance(this.mAppContext).getAllNewFeatureDownloadTask(OsLabAppDownLoadTask.obtain());
            if (tasks != null && tasks.size() > 0) {
                int installItemsCount;
                int recommendCount;
                ArrayList<AppItem> list = new ArrayList<AppItem>();
                ArrayList<AppItem> updateItems = new ArrayList<AppItem>();
                ArrayList<AppItem> recommendItems = new ArrayList<AppItem>();
                ArrayList<AppItem> installItems = new ArrayList<AppItem>();
                this.taskToOsLabAppItem(1, tasks, updateItems);
                this.taskToOsLabAppItem(2, tasks, recommendItems);
                this.taskToOsLabOtherAppItem(3, reNewTasks, installItems);
                this.checkOsLabUpdateAndRecommendApk(updateItems, recommendItems);
                this.checkOsLabUpdateAndInstallItemsApk(updateItems, installItems);
                int redCount = 0;
                int updateCount = updateItems.size();
                if (updateCount > 0) {
                    list.addAll(updateItems);
                }
                if ((recommendCount = recommendItems.size()) > 0) {
                    list.addAll(recommendItems);
                }
                if ((installItemsCount = installItems.size()) > 0) {
                    list.addAll(installItems);
                }
                for (AppItem appItem : list) {
                    if (!UpdateConstants.STATE_INITIAL.equals(appItem.state)) continue;
                    ++redCount;
                }
                if (mCallback != null) {
                    mCallback.onCallback(redCount);
                }
            }
        });
    }

    private void requestOslabDataFromCoreService(final Callback<ArrayList<ListItem>> callback, final List<OsLabAppDownLoadTask> newtasks) {
        try {
            CoreServiceTools.getTools().getCoreAidl().requestOslabAppUpdateData(new ICoreDataCallback.Stub(){

                @Override
                public void onSuccess(String response) throws RemoteException {
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        JSONArray savedNewTaskJsonArray = null;
                        try {
                            savedNewTaskJsonArray = new JSONArray(response);
                            for (int i = 0; i < savedNewTaskJsonArray.length(); ++i) {
                                OsLabAppDownLoadTask savedNewTask = (OsLabAppDownLoadTask)Tson.fromJson((String)savedNewTaskJsonArray.getString(i), OsLabAppDownLoadTask.class);
                                DownloadHelper.getInstance().addOsLabAppDownload(savedNewTask);
                            }
                        }
                        catch (JSONException e) {
                            CS.log.e("TMS_APP", e.getMessage());
                        }
                    }
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u6210\u529f\uff0c\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u5e93");
                    List<OsLabAppDownLoadTask> reTasks = AppDownloadTaskManager.getInstance(DataRepository.this.mAppContext).getAllDownloadTask(OsLabAppDownLoadTask.obtain());
                    List<OsLabAppDownLoadTask> reNewTasks = AppDownloadTaskManager.getInstance(DataRepository.this.mAppContext).getAllNewFeatureDownloadTask(OsLabAppDownLoadTask.obtain());
                    DataRepository.this.handlerOsLabAppTasks(reTasks, reNewTasks, callback);
                }

                @Override
                public void onFail(String response) throws RemoteException {
                    CS.log.d("TMS_UPDATE", "\u6570\u636e\u540c\u6b65\u5931\u8d25");
                    DataRepository.this.handlerOsLabAppTasks(null, newtasks, callback);
                }
            });
        }
        catch (RemoteException e) {
            CS.log.e("TMS_APP", e.getMessage());
            this.handlerOsLabAppTasks(null, newtasks, callback);
        }
    }

    public void loadShowOsAppInstallList(Callback<ArrayList<ListItem>> callback) {
        this.mExecutors.work().execute(() -> {
            List<OsLabAppDownLoadTask> reNewTasks = AppDownloadTaskManager.getInstance(this.mAppContext).getAllNewFeatureDownloadTask(OsLabAppDownLoadTask.obtain());
            CS.log.d("TMS_UPDATE", "\u6570\u636e\u5e93\u52a0\u8f7d\u5b89\u88c5\u6210\u529f\u7684\u6570\u636e\uff0c reNewTasks\uff1a" + reNewTasks);
            if (reNewTasks != null && reNewTasks.size() > 0) {
                CS.log.d("TMS_UPDATE", "\u91cd\u65b0\u52a0\u8f7d\u5df2\u5b89\u88c5\u7684\u6570\u636e");
                this.handlerOsLabAppTasks(null, reNewTasks, callback);
            } else {
                CS.log.d("TMS_UPDATE", "\u65e0\u5b89\u88c5\u6210\u529f\u6570\u636e");
                this.handlerOsLabAppTasks(null, null, callback);
            }
        });
    }

    private void handlerOsLabAppTasks(List<OsLabAppDownLoadTask> tasks, List<OsLabAppDownLoadTask> newtasks, Callback<ArrayList<ListItem>> callback) {
        int installItemsCount;
        int recommendCount;
        ArrayList<ListItem> list = new ArrayList<ListItem>();
        ArrayList<AppItem> updateItems = new ArrayList<AppItem>();
        ArrayList<AppItem> recommendItems = new ArrayList<AppItem>();
        ArrayList<AppItem> installItems = new ArrayList<AppItem>();
        this.taskToOsLabAppItem(1, tasks, updateItems);
        this.taskToOsLabAppItem(2, tasks, recommendItems);
        this.taskToOsLabOtherAppItem(3, newtasks, installItems);
        this.checkOsLabUpdateAndRecommendApk(updateItems, recommendItems);
        this.checkOsLabUpdateAndInstallItemsApk(updateItems, installItems);
        int updateCount = updateItems.size();
        if (updateCount > 0) {
            list.addAll(updateItems);
        }
        if ((recommendCount = recommendItems.size()) > 0) {
            list.addAll(recommendItems);
        }
        if ((installItemsCount = installItems.size()) > 0) {
            list.addAll(installItems);
        }
        list.add(new InfoItem(0, false, false, true));
        this.mExecutors.ui().execute(() -> {
            if (callback != null) {
                callback.onCallback(list);
            }
        });
    }

    private void taskToOsLabAppItem(int apkType, List<OsLabAppDownLoadTask> tasks, List<AppItem> items) {
        if (tasks == null) {
            return;
        }
        for (OsLabAppDownLoadTask task : tasks) {
            AppItem item = new AppItem();
            item.pkgName = task.pkgName;
            item.appName = task.title;
            item.appIconUrl = task.iconUrl;
            item.appVersionName = task.appVersionName;
            item.appVersionCode = task.appVersionCode;
            item.apkUrl = task.url;
            item.apkPath = task.filePath;
            item.appInfo = null;
            item.apkSize = String.valueOf(task.totalSize);
            item.allSize = (int)task.totalSize;
            item.downloadSize = (int)task.finishedSize;
            item.state = task.downloadState.name();
            item.md5 = task.md5;
            item.type = task.apkType;
            item.appId = task.appId;
            item.description = task.description;
            item.imgUrl = task.imgUrl;
            item.isSilentInstall = true;
            item.errorType = task.downloadFailType;
            item.installed = task.isShowRedPoint;
            if (apkType != task.apkType) continue;
            items.add(item);
        }
    }

    private void taskToOsLabOtherAppItem(int apkType, List<OsLabAppDownLoadTask> tasks, List<AppItem> items) {
        if (tasks == null) {
            return;
        }
        for (OsLabAppDownLoadTask task : tasks) {
            AppItem item = new AppItem();
            item.pkgName = task.pkgName;
            item.appName = task.title;
            item.appIconUrl = task.iconUrl;
            item.appVersionName = task.appVersionName;
            item.appVersionCode = task.appVersionCode;
            item.apkUrl = task.url;
            item.apkPath = task.filePath;
            item.appInfo = null;
            item.apkSize = String.valueOf(task.totalSize);
            item.allSize = (int)task.totalSize;
            item.downloadSize = (int)task.finishedSize;
            item.state = task.downloadState.name();
            item.md5 = task.md5;
            item.type = task.apkType;
            item.appId = task.appId;
            item.description = task.description;
            item.imgUrl = task.imgUrl;
            item.isSilentInstall = true;
            item.errorType = task.downloadFailType;
            item.installed = task.isShowRedPoint;
            items.add(item);
        }
    }

    public void updateAppItemState(AppDownLoadTask task) {
        this.mExecutors.work().execute(() -> this.mAdtm.updateDownloadTaskStatus(task));
    }

    public <T extends AppDownLoadTask> void queryByPkgName(T task, String pkgName, Callback<T> callback) {
        this.mExecutors.work().execute(() -> callback.onCallback(this.mAdtm.queryByPkgName(task, pkgName)));
    }

    public void loadPausedAppItems(Callback<ArrayList<AppItem>> callback) {
        this.mExecutors.work().execute(() -> {
            ArrayList<AppItem> list = new ArrayList<AppItem>();
            ArrayList<AppItem> pauseList = this.taskToAppItem(this.mAdtm.getAllDownloadTaskByState(new AppDownLoadTask(), DownloadState.PAUSE));
            ArrayList<AppItem> failList = this.taskToAppItem(this.mAdtm.getAllDownloadTaskByState(new AppDownLoadTask(), DownloadState.FAILED));
            list.addAll(pauseList);
            list.addAll(failList);
            this.mExecutors.ui().execute(() -> {
                if (callback != null) {
                    callback.onCallback(list);
                }
            });
        });
    }

    private ArrayList<AppItem> taskToAppItem(List<AppDownLoadTask> tasks) {
        ArrayList<AppItem> items = new ArrayList<AppItem>();
        for (AppDownLoadTask task : tasks) {
            if (task == null) continue;
            AppItem item = new AppItem();
            item.pkgName = task.pkgName;
            item.appName = task.title;
            item.appIconUrl = task.iconUrl;
            item.appVersionName = task.appVersionName;
            item.appVersionCode = task.appVersionCode;
            item.apkUrl = task.url;
            item.apkPath = task.filePath;
            item.apkSize = String.valueOf(task.totalSize);
            item.allSize = (int)task.totalSize;
            item.downloadSize = (int)task.finishedSize;
            item.state = task.downloadState.name();
            item.md5 = task.md5;
            item.appId = task.appId;
            item.description = task.description;
            item.imgUrl = task.imgUrl;
            item.isSilentInstall = task.isSilentInstall;
            items.add(item);
        }
        return items;
    }

    public void deleteDownloadTasks(ArrayList<String> urls, Callback<Boolean> callback) {
        this.mExecutors.work().execute(() -> {
            for (String url : urls) {
                this.mAdtm.deleteDownloadTask(new AppDownLoadTask(url));
            }
            this.mExecutors.ui().execute(() -> {
                if (callback != null) {
                    callback.onCallback(true);
                }
            });
        });
    }

    public void loadPausedOsLabAppItems(Callback<ArrayList<AppItem>> callback) {
        this.mExecutors.work().execute(() -> {
            ArrayList<AppItem> list = new ArrayList<AppItem>();
            ArrayList<AppItem> pauseList = this.taskToOsLabAppItem(this.mAdtm.getOsLabAllDownloadTaskByState(new OsLabAppDownLoadTask(), DownloadState.PAUSE));
            ArrayList<AppItem> failList = this.taskToOsLabAppItem(this.mAdtm.getOsLabAllDownloadTaskByState(new OsLabAppDownLoadTask(), DownloadState.FAILED));
            list.addAll(pauseList);
            list.addAll(failList);
            this.mExecutors.ui().execute(() -> {
                if (callback != null) {
                    callback.onCallback(list);
                }
            });
        });
    }

    private ArrayList<AppItem> taskToOsLabAppItem(List<OsLabAppDownLoadTask> tasks) {
        ArrayList<AppItem> items = new ArrayList<AppItem>();
        for (OsLabAppDownLoadTask task : tasks) {
            if (task == null) continue;
            AppItem item = new AppItem();
            item.pkgName = task.pkgName;
            item.appName = task.title;
            item.appIconUrl = task.iconUrl;
            item.appVersionName = task.appVersionName;
            item.appVersionCode = task.appVersionCode;
            item.apkUrl = task.url;
            item.apkPath = task.filePath;
            item.apkSize = String.valueOf(task.totalSize);
            item.allSize = (int)task.totalSize;
            item.downloadSize = (int)task.finishedSize;
            item.state = task.downloadState.name();
            item.md5 = task.md5;
            item.appId = task.appId;
            item.description = task.description;
            item.imgUrl = task.imgUrl;
            item.isSilentInstall = task.isSilentInstall;
            items.add(item);
        }
        return items;
    }

    public void oslabDeleteDownloadTasks(ArrayList<String> urls, Callback<Boolean> callback) {
        this.mExecutors.work().execute(() -> {
            for (String url : urls) {
                this.mAdtm.deleteDownloadTask(new OsLabAppDownLoadTask(url));
            }
            this.mExecutors.ui().execute(() -> {
                if (callback != null) {
                    callback.onCallback(true);
                }
            });
        });
    }
}

