/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.manager;

import android.text.TextUtils;
import com.transsion.common.bean.ConfigInfo;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.json.Tson;

public class ConfigInfoManager {
    private static ConfigInfoManager configInfoManager = null;
    private static ConfigInfo configInfo = null;

    public static ConfigInfoManager getInstance() {
        if (null == configInfoManager) {
            configInfoManager = new ConfigInfoManager();
        }
        return configInfoManager;
    }

    private ConfigInfoManager() {
        if (null == configInfo) {
            this.updateConfigInfo();
        }
    }

    public void updateConfigInfo() {
        try {
            String json = SpUtil.getSP().getString("APP_CONFIG_INFO", null);
            if (!TextUtils.isEmpty((CharSequence)json)) {
                configInfo = (ConfigInfo)Tson.fromJson((String)json, ConfigInfo.class);
            }
        }
        catch (Exception e) {
            configInfo = null;
        }
    }

    public int getReqServerInterval() {
        int reqServerInterval = 0;
        if (null != configInfo) {
            reqServerInterval = configInfo.getReqConfigInterval();
        }
        return reqServerInterval;
    }

    public int getReqCreativeServerInterval() {
        int reqServerInterval = 0;
        if (null != configInfo) {
            reqServerInterval = configInfo.getReqCreativeInterval();
        }
        return reqServerInterval;
    }

    public int getReqAppUpdateInterval() {
        int reqServerInterval = 0;
        if (null != configInfo) {
            reqServerInterval = configInfo.getReqAppUpdateInterval();
        }
        return reqServerInterval;
    }

    public int getReqOsLabInterval() {
        int reqServerInterval = 0;
        if (null != configInfo) {
            reqServerInterval = configInfo.getReqOsLabInterval();
        }
        return reqServerInterval;
    }

    public boolean isTmsOpen() {
        boolean isTmsOpen = false;
        if (null != configInfo) {
            isTmsOpen = 1 == configInfo.getTmsOpened();
        }
        return isTmsOpen;
    }

    public long getImpressionInterval() {
        long interval = 0L;
        if (null != configInfo) {
            interval = configInfo.getImpressionInterval();
        }
        return interval;
    }

    public int getImageDownloadRetryTimes() {
        int imageDownloadRetryTimes = 0;
        if (null != configInfo) {
            imageDownloadRetryTimes = configInfo.getImageDownloadRetryTimes();
        }
        return imageDownloadRetryTimes;
    }

    public int getApkDownloadRetryTimes() {
        int apkDownloadRetryTimes = 0;
        if (null != configInfo) {
            apkDownloadRetryTimes = configInfo.getApkDownloadRetryTimes();
        }
        return apkDownloadRetryTimes;
    }

    public int getCheckStep() {
        int checkStep = 0;
        if (null != configInfo) {
            checkStep = configInfo.getCheckStep();
        }
        return checkStep;
    }

    public String getNetwork() {
        String netWork = null;
        if (null != configInfo) {
            netWork = configInfo.getNetwork();
        }
        return netWork;
    }

    public long getTrackerReportInterval() {
        long interval = 0L;
        if (null != configInfo) {
            interval = configInfo.getTrackerReportInterval();
        }
        return interval;
    }

    public long getDataCenterReportInterval() {
        long interval = 0L;
        if (null != configInfo) {
            interval = configInfo.getDataCenterReportInterval();
        }
        return interval;
    }
}

