/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.media;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.SparseArray;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.DownloadHelper;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.download.task.AppSilentDownLoadTask;
import com.transsion.appupdate.download.task.DownloadTask;
import com.transsion.appupdate.entity.AppDownloadTaskData;
import com.transsion.appupdate.http.HttpTool;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.manager.PhoneInfoManager;
import com.transsion.appupdate.media.BaseMedia;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.appupdate.media.bean.AppUpdateReqBean;
import com.transsion.appupdate.media.bean.AppUpdateResBean;
import com.transsion.appupdate.reportBean.AppUpdateData;
import com.transsion.appupdate.reportBean.AppUpdateUninstallData;
import com.transsion.appupdate.reportBean.RecordStateData;
import com.transsion.appupdate.reportBean.SyncAction;
import com.transsion.appupdate.service.AppSilentJobService;
import com.transsion.appupdate.service.DataSyncService;
import com.transsion.appupdate.ui.main.AppUpdateActivity;
import com.transsion.appupdate.utils.AiMessageUtil;
import com.transsion.appupdate.utils.DataSyncUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.InstallUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.common.bean.AppDetailInfo;
import com.transsion.common.bean.AppInfo;
import com.transsion.common.bean.AppUpdateBean;
import com.transsion.common.bean.ImgInfo;
import com.transsion.common.bean.PhoneInfo;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.StringCallback;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class AppUpdateMedia
extends BaseMedia {
    private static AppUpdateMedia configMedia = null;
    private boolean requestMultiPlan = true;

    public static AppUpdateMedia getInstance() {
        if (null == configMedia) {
            configMedia = new AppUpdateMedia();
        }
        return configMedia;
    }

    public void syncCheckData(int step, IMediaCallback appUpdateCallback) {
        PhoneInfo phoneInfo = PhoneInfoManager.getInstance().getPhoneInfo();
        configMedia.syncDataInternal(phoneInfo, null, null, step, appUpdateCallback);
    }

    public void syncData(IMediaCallback appUpdateCallback) {
        if (!NewPhoneRecommendManager.isNewPhoneRecommendOver((Context)CoreUtil.getContext())) {
            if (appUpdateCallback != null) {
                appUpdateCallback.onRequestSuccess(null);
            }
            return;
        }
        long lastTime = SpUtil.getSP().getLong("APP_UPDATE_LAST_TIME", 0L);
        long updateTime = (long)ConfigInfoManager.getInstance().getReqAppUpdateInterval() * 1000L;
        CS.log.d("TMS_MEDIA", "\u5f00\u59cb\u540c\u6b65appupdate\u6570\u636e\uff0cAppUpdateMedia -> updateTime: " + updateTime + " / intervalTime : " + Math.abs(System.currentTimeMillis() - lastTime));
        if (Math.abs(System.currentTimeMillis() - lastTime) > updateTime) {
            new AppSyncTask(appUpdateCallback).execute(new String[0]);
        }
    }

    private void syncDataInternal(PhoneInfo phoneInfo, List<Integer> planIdList, List<AppInfo> appInfoList, int checkStep, final IMediaCallback appUpdateCallback) {
        AppUpdateReqBean appUpdateReqBean = new AppUpdateReqBean(phoneInfo, planIdList, appInfoList, checkStep);
        appUpdateReqBean.setMore(this.requestMultiPlan);
        String data = Tson.toJson((Object)appUpdateReqBean);
        CS.log.d("TMS_MEDIA", "AppUpdateMedia req JSON ->" + data);
        HttpTool.getTool().getApps(data, (HttpCallbackImpl)new StringCallback(){

            public void onFailure(int i, String s, Throwable throwable) {
                CS.log.d("TMS_MEDIA", "AppUpdateMedia : onFailure->" + s);
                if (null != appUpdateCallback) {
                    appUpdateCallback.onRequestFailed(s);
                }
                Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(3, -1).getBundle());
            }

            public void onSuccess(int i, String s) {
                block6: {
                    CS.log.d("TMS_MEDIA", "AppUpdateMedia : onCallbackSuccess->" + (s.length() > 2048 ? Integer.valueOf(2048) : s));
                    if (!TextUtils.isEmpty((CharSequence)s)) {
                        try {
                            JSONObject response = new JSONObject(s);
                            String code = response.optString("code");
                            if ("200".equals(code)) {
                                AppUpdateMedia.this.parseDataByTask(s, appUpdateCallback);
                                SpUtil.getSP().putLong("APP_UPDATE_LAST_TIME", System.currentTimeMillis());
                                break block6;
                            }
                            Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(3, -2).getBundle());
                        }
                        catch (Exception e) {
                            CS.log.d("TMS_MEDIA", "AppUpdateMedia : syncDataInternal Exception->" + s);
                            Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(3, -3).getBundle());
                            if (null != appUpdateCallback) {
                                appUpdateCallback.onRequestFailed(e.toString());
                            }
                            break block6;
                        }
                    }
                    if (null != appUpdateCallback) {
                        appUpdateCallback.onRequestFailed("DATA IS NULL");
                    }
                }
            }
        });
    }

    @Override
    void parseData(String jsonData, IMediaCallback appUpdateCallback) {
        CS.log.d("TMS_MEDIA", "AppUpdateMedia : is request MULTI plan -> " + this.requestMultiPlan);
        if (this.requestMultiPlan) {
            this.parseMultiPlanData(jsonData, appUpdateCallback);
        } else {
            this.parseSinglePlanData(jsonData, appUpdateCallback);
        }
    }

    private void parseMultiPlanData(String jsonData, IMediaCallback appUpdateCallback) {
        block24: {
            try {
                if (!TextUtils.isEmpty((CharSequence)jsonData)) {
                    AppUpdateResBean response = (AppUpdateResBean)Tson.fromJson((String)jsonData, AppUpdateResBean.class);
                    if (response != null && response.getPlan() != null && !response.getPlan().isEmpty()) {
                        CS.log.d("TMS_MEDIA", "AppUpdateMedia  parseData  success ================================");
                        ArrayList<Bundle> trackAppList = new ArrayList<Bundle>();
                        ArrayList<AppDownLoadTask> newTaskList = new ArrayList<AppDownLoadTask>();
                        for (AppUpdateBean appUpdateRes : response.getPlan()) {
                            List<AppDetailInfo> recommendAppList;
                            List<AppDetailInfo> normalAppList;
                            DownloadTask task;
                            AppUpdateData appUpdateData;
                            Object info;
                            List<AppDetailInfo> silentAppList;
                            Object appInfo2;
                            if (appUpdateRes == null) continue;
                            CS.log.v("TMS_MEDIA", "AppUpdateMedia PlanID : " + appUpdateRes.getPlanId());
                            ArrayList<AppDetailInfo> appList = new ArrayList<AppDetailInfo>();
                            if (null != appUpdateRes.getUninstallAppList() && appUpdateRes.getUninstallAppList().size() > 0) {
                                for (Object appInfo2 : appUpdateRes.getUninstallAppList()) {
                                    AppUpdateUninstallData appUpdateUninstallData = new AppUpdateUninstallData();
                                    appUpdateUninstallData.setPkgName(appInfo2.getPkgName());
                                    appUpdateUninstallData.setVersionCode(appInfo2.getVersionCode());
                                    trackAppList.add(appUpdateUninstallData.getBundle());
                                    if (!PackageUtil.checkApkExist(CoreUtil.getContext(), appInfo2.getPkgName(), appInfo2.getVersionCode())) continue;
                                    InstallUtil.pmuninstall(CoreUtil.getContext(), appInfo2.getPkgName());
                                }
                            }
                            if (appUpdateRes.getSilentAppList() != null && (silentAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getSilentAppList(), 1)) != null) {
                                appInfo2 = appUpdateRes.getSilentAppList().iterator();
                                while (appInfo2.hasNext()) {
                                    info = (AppDetailInfo)appInfo2.next();
                                    appUpdateData = new AppUpdateData();
                                    appUpdateData.setAppId(info.getAppId());
                                    appUpdateData.setPkgName(info.getPkgName());
                                    appUpdateData.setVersionCode(info.getVersionCode());
                                    appUpdateData.setDescVersion(info.getDescVersion());
                                    appUpdateData.setType(1);
                                    trackAppList.add(appUpdateData.getBundle());
                                    task = new AppSilentDownLoadTask(info.getDownloadUrl(), info.getMd5(), info.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), info.getDownloadUrl()), DownloadState.INITIAL, info.getPkgName(), true, info.getAppId(), info.getVersionName(), info.getVersionCode(), ConfigInfoManager.getInstance().getApkDownloadRetryTimes());
                                    DownloadHelper.getInstance().addSilentDownLoad((AppSilentDownLoadTask)task);
                                }
                                appList.addAll(silentAppList);
                            }
                            if (null != (normalAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getUpgradeAppList(), 2)) && normalAppList.size() > 0) {
                                appInfo2 = normalAppList.iterator();
                                while (appInfo2.hasNext()) {
                                    info = (AppDetailInfo)appInfo2.next();
                                    appUpdateData = new AppUpdateData();
                                    appUpdateData.setAppId(info.getAppId());
                                    appUpdateData.setPkgName(info.getPkgName());
                                    appUpdateData.setVersionCode(info.getVersionCode());
                                    appUpdateData.setDescVersion(info.getDescVersion());
                                    appUpdateData.setType(2);
                                    trackAppList.add(appUpdateData.getBundle());
                                    task = new AppDownLoadTask(info.getDownloadUrl(), info.getMd5(), info.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), info.getDownloadUrl()), DownloadState.INITIAL, info.getPkgName(), info.getIcon().getUrl(), info.getTitle(), info.getAppId(), true, info.getVersionName(), info.getVersionCode(), 1, info.getDescription(), this.getImgUrl((AppDetailInfo)info));
                                    newTaskList.add((AppDownLoadTask)task);
                                }
                                appList.addAll(normalAppList);
                            }
                            if (null != (recommendAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getRecommendAppList(), 3)) && recommendAppList.size() > 0) {
                                for (AppDetailInfo info2 : recommendAppList) {
                                    AppUpdateData appUpdateData2 = new AppUpdateData();
                                    appUpdateData2.setAppId(info2.getAppId());
                                    appUpdateData2.setPkgName(info2.getPkgName());
                                    appUpdateData2.setVersionCode(info2.getVersionCode());
                                    appUpdateData2.setDescVersion(info2.getDescVersion());
                                    appUpdateData2.setType(3);
                                    trackAppList.add(appUpdateData2.getBundle());
                                    AppDownLoadTask task2 = new AppDownLoadTask(info2.getDownloadUrl(), info2.getMd5(), info2.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), info2.getDownloadUrl()), DownloadState.INITIAL, info2.getPkgName(), info2.getIcon().getUrl(), info2.getTitle(), info2.getAppId(), true, info2.getVersionName(), info2.getVersionCode(), 2, info2.getDescription(), this.getImgUrl(info2));
                                    newTaskList.add(task2);
                                }
                                appList.addAll(recommendAppList);
                            }
                            DBManager.getInstance().saveOrUpdateAppDetailList(appList, appUpdateRes.getValidEndTime());
                            List planIDList = SpUtil.getSP().getIntList("APP_UPDATE_PLAN_LIST", new ArrayList());
                            planIDList.add(appUpdateRes.getPlanId());
                            SpUtil.getSP().putString("APP_UPDATE_PLAN_LIST", Tson.toJson((Object)planIDList));
                        }
                        AppSilentJobService.startJob(CoreUtil.getContext());
                        if (null != appUpdateCallback) {
                            if (newTaskList.isEmpty()) {
                                appUpdateCallback.onRequestFailed("DATA IS NULL");
                            } else {
                                String newTaskListJson = Tson.toJson(newTaskList);
                                appUpdateCallback.onRequestSuccess(newTaskListJson);
                            }
                        } else {
                            this.saveNewTaskList(newTaskList);
                        }
                        if (appUpdateCallback == null) {
                            int totalCount = newTaskList.size();
                            CS.log.d("TMS_MEDIA", "update settings badge, count = " + totalCount);
                            if (totalCount > 0) {
                                this.updateAppUpdateSettingsBadge(totalCount);
                            }
                        }
                        Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(3, 0).getBundle());
                        if (trackAppList.size() > 0) {
                            Tracker.trackList(Tracker.TID.TMS_UPDATE_GET, trackAppList);
                        }
                        CS.log.d("TMS_MEDIA", "AppUpdateMedia  parseData  success ================================");
                    } else if (appUpdateCallback != null) {
                        appUpdateCallback.onRequestFailed("DATA IS NULL");
                    }
                } else if (appUpdateCallback != null) {
                    appUpdateCallback.onRequestFailed("DATA IS NULL");
                }
            }
            catch (Exception e) {
                Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(3, -3).getBundle());
                if (appUpdateCallback == null) break block24;
                appUpdateCallback.onRequestFailed("DATA IS NULL");
            }
        }
    }

    private void parseSinglePlanData(String jsonData, IMediaCallback appUpdateCallback) {
        try {
            if (!TextUtils.isEmpty((CharSequence)jsonData)) {
                JSONObject response = new JSONObject(jsonData);
                String data = response.optString("plan");
                AppUpdateBean appUpdateRes = (AppUpdateBean)Tson.fromJson((String)data, AppUpdateBean.class);
                if (appUpdateRes != null) {
                    List<AppDetailInfo> recommendAppList;
                    List<AppDetailInfo> normalAppList;
                    DownloadTask task;
                    AppUpdateData appUpdateData;
                    List<AppDetailInfo> silentAppList;
                    CS.log.d("TMS_MEDIA", "AppUpdateMedia  parseData  success ================================");
                    CS.log.v("TMS_MEDIA", "AppUpdateMedia PlanID : " + appUpdateRes.getPlanId());
                    ArrayList<Bundle> trackAppList = new ArrayList<Bundle>();
                    ArrayList<AppDownLoadTask> newTaskList = new ArrayList<AppDownLoadTask>();
                    if (null != appUpdateRes.getUninstallAppList() && appUpdateRes.getUninstallAppList().size() > 0) {
                        for (AppInfo appInfo : appUpdateRes.getUninstallAppList()) {
                            Iterator<AppDetailInfo> appUpdateUninstallData = new AppUpdateUninstallData();
                            ((AppUpdateUninstallData)((Object)appUpdateUninstallData)).setPkgName(appInfo.getPkgName());
                            ((AppUpdateUninstallData)((Object)appUpdateUninstallData)).setVersionCode(appInfo.getVersionCode());
                            trackAppList.add(((AppUpdateUninstallData)((Object)appUpdateUninstallData)).getBundle());
                            if (!PackageUtil.checkApkExist(CoreUtil.getContext(), appInfo.getPkgName(), appInfo.getVersionCode())) continue;
                            InstallUtil.pmuninstall(CoreUtil.getContext(), appInfo.getPkgName());
                        }
                    }
                    ArrayList<AppDetailInfo> appList = new ArrayList<AppDetailInfo>();
                    if (appUpdateRes.getSilentAppList() != null && (silentAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getSilentAppList(), 1)) != null) {
                        for (AppDetailInfo appDetailInfo : appUpdateRes.getSilentAppList()) {
                            appUpdateData = new AppUpdateData();
                            appUpdateData.setAppId(appDetailInfo.getAppId());
                            appUpdateData.setPkgName(appDetailInfo.getPkgName());
                            appUpdateData.setVersionCode(appDetailInfo.getVersionCode());
                            appUpdateData.setDescVersion(appDetailInfo.getDescVersion());
                            appUpdateData.setType(1);
                            trackAppList.add(appUpdateData.getBundle());
                            task = new AppSilentDownLoadTask(appDetailInfo.getDownloadUrl(), appDetailInfo.getMd5(), appDetailInfo.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), appDetailInfo.getDownloadUrl()), DownloadState.INITIAL, appDetailInfo.getPkgName(), true, appDetailInfo.getAppId(), appDetailInfo.getVersionName(), appDetailInfo.getVersionCode(), ConfigInfoManager.getInstance().getApkDownloadRetryTimes());
                            DownloadHelper.getInstance().addSilentDownLoad((AppSilentDownLoadTask)task);
                            AppSilentJobService.startJob(CoreUtil.getContext());
                        }
                        appList.addAll(silentAppList);
                    }
                    if (null != (normalAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getUpgradeAppList(), 2)) && normalAppList.size() > 0) {
                        for (AppDetailInfo appDetailInfo : normalAppList) {
                            appUpdateData = new AppUpdateData();
                            appUpdateData.setAppId(appDetailInfo.getAppId());
                            appUpdateData.setPkgName(appDetailInfo.getPkgName());
                            appUpdateData.setVersionCode(appDetailInfo.getVersionCode());
                            appUpdateData.setDescVersion(appDetailInfo.getDescVersion());
                            appUpdateData.setType(2);
                            trackAppList.add(appUpdateData.getBundle());
                            task = new AppDownLoadTask(appDetailInfo.getDownloadUrl(), appDetailInfo.getMd5(), appDetailInfo.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), appDetailInfo.getDownloadUrl()), DownloadState.INITIAL, appDetailInfo.getPkgName(), appDetailInfo.getIcon().getUrl(), appDetailInfo.getTitle(), appDetailInfo.getAppId(), true, appDetailInfo.getVersionName(), appDetailInfo.getVersionCode(), 1, appDetailInfo.getDescription(), this.getImgUrl(appDetailInfo));
                            newTaskList.add((AppDownLoadTask)task);
                        }
                        appList.addAll(normalAppList);
                    }
                    if (null != (recommendAppList = this.checkEffectiveAppDetailInfo(appUpdateRes.getRecommendAppList(), 3)) && recommendAppList.size() > 0) {
                        for (AppDetailInfo info : recommendAppList) {
                            AppUpdateData appUpdateData2 = new AppUpdateData();
                            appUpdateData2.setAppId(info.getAppId());
                            appUpdateData2.setPkgName(info.getPkgName());
                            appUpdateData2.setVersionCode(info.getVersionCode());
                            appUpdateData2.setDescVersion(info.getDescVersion());
                            appUpdateData2.setType(3);
                            trackAppList.add(appUpdateData2.getBundle());
                            AppDownLoadTask task2 = new AppDownLoadTask(info.getDownloadUrl(), info.getMd5(), info.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), info.getDownloadUrl()), DownloadState.INITIAL, info.getPkgName(), info.getIcon().getUrl(), info.getTitle(), info.getAppId(), true, info.getVersionName(), info.getVersionCode(), 2, info.getDescription(), this.getImgUrl(info));
                            newTaskList.add(task2);
                        }
                        appList.addAll(recommendAppList);
                    }
                    DBManager.getInstance().saveOrUpdateAppDetailList(appList, appUpdateRes.getValidEndTime());
                    List list = SpUtil.getSP().getIntList("APP_UPDATE_PLAN_LIST", new ArrayList());
                    list.add(appUpdateRes.getPlanId());
                    SpUtil.getSP().putString("APP_UPDATE_PLAN_LIST", Tson.toJson((Object)list));
                    CS.log.d("TMS_MEDIA", "AppUpdateMedia  parseData  success ================================");
                    if (null != appUpdateCallback) {
                        String newTaskListJson = Tson.toJson(newTaskList);
                        appUpdateCallback.onRequestSuccess(newTaskListJson);
                    } else {
                        this.saveNewTaskList(newTaskList);
                    }
                    if (appUpdateCallback == null) {
                        int updateCount = normalAppList == null ? 0 : normalAppList.size();
                        int recommendCount = recommendAppList == null ? 0 : recommendAppList.size();
                        CS.log.d("TMS_MEDIA", "update settings badge, count = " + (updateCount + recommendCount));
                        if (updateCount + recommendCount > 0) {
                            this.updateAppUpdateSettingsBadge(updateCount + recommendCount);
                        }
                    }
                    Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(3, 0).getBundle());
                    if (trackAppList.size() > 0) {
                        Tracker.trackList(Tracker.TID.TMS_UPDATE_GET, trackAppList);
                    }
                } else if (null != appUpdateCallback) {
                    appUpdateCallback.onRequestFailed("DATA IS NULL");
                }
            }
        }
        catch (Exception e) {
            Tracker.track(Tracker.TID.TMS_SYNC, new SyncAction(3, -3).getBundle());
        }
    }

    private List<AppDetailInfo> checkEffectiveAppDetailInfo(List<AppDetailInfo> appDetailInfoList, int appType) {
        ArrayList<AppDetailInfo> replaceAppList = new ArrayList<AppDetailInfo>();
        if (appDetailInfoList == null || 0 == appDetailInfoList.size()) {
            return replaceAppList;
        }
        ArrayList<String> appIdList = new ArrayList<String>();
        Iterator<AppDetailInfo> iterator = appDetailInfoList.iterator();
        while (iterator.hasNext()) {
            AppDetailInfo app = iterator.next();
            if (app == null) {
                iterator.remove();
                continue;
            }
            if (app.getAppId() <= 0 || TextUtils.isEmpty((CharSequence)app.getPkgName()) || TextUtils.isEmpty((CharSequence)app.getDownloadUrl()) || TextUtils.isEmpty((CharSequence)app.getMd5()) || TextUtils.isEmpty((CharSequence)app.getTitle()) || app.getIcon() == null || app.getApkScreenshotImgList() == null || app.getApkScreenshotImgList().size() == 0 || app.getImages() == null || app.getImages().size() == 0) {
                iterator.remove();
                continue;
            }
            if (2 == appType && !PackageUtil.checkApkUpdate(CoreUtil.getContext(), app.getPkgName(), app.getVersionCode())) {
                iterator.remove();
                continue;
            }
            if (PackageUtil.checkApkExist(CoreUtil.getContext(), app.getPkgName(), app.getVersionCode())) {
                iterator.remove();
                continue;
            }
            appIdList.add(String.valueOf(app.getAppId()));
        }
        if (0 == appIdList.size()) {
            return replaceAppList;
        }
        List<AppDetailInfo> dbAppList = DBManager.getInstance().getAppDetailListByAppIdList(appIdList);
        SparseArray dbAppMap = null;
        if (dbAppList != null && dbAppList.size() > 0) {
            dbAppMap = new SparseArray();
            for (AppDetailInfo appDetailInfo : dbAppList) {
                dbAppMap.put(appDetailInfo.getAppId(), (Object)appDetailInfo);
            }
        }
        for (AppDetailInfo appDetailInfo : appDetailInfoList) {
            if (dbAppMap != null) {
                AppDetailInfo dbApp = (AppDetailInfo)dbAppMap.get(appDetailInfo.getAppId());
                if (dbApp != null) {
                    if (appDetailInfo.getVersionCode() > dbApp.getVersionCode()) {
                        replaceAppList.add(appDetailInfo);
                        continue;
                    }
                    if (1 == appType || appDetailInfo.getVersionCode() != dbApp.getVersionCode() || appDetailInfo.getDescVersion() <= dbApp.getDescVersion()) continue;
                    replaceAppList.add(appDetailInfo);
                    continue;
                }
                replaceAppList.add(appDetailInfo);
                continue;
            }
            replaceAppList.add(appDetailInfo);
        }
        return replaceAppList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNewTaskList(List<AppDownLoadTask> newTaskList) {
        if (newTaskList != null && !newTaskList.isEmpty()) {
            ArrayList<AppDownLoadTask> appList = new ArrayList<AppDownLoadTask>(newTaskList);
            String newTaskListJson = DataSyncUtil.getNewTaskListJson("APP_UPDATE_NEW_TASK_LIST");
            if (!TextUtils.isEmpty((CharSequence)newTaskListJson)) {
                try {
                    AppDownloadTaskData appTaskData = (AppDownloadTaskData)Tson.fromJson((String)newTaskListJson, AppDownloadTaskData.class);
                    if (appTaskData != null && appTaskData.getTaskList() != null && !appTaskData.getTaskList().isEmpty()) {
                        appList.addAll(appTaskData.getTaskList());
                    }
                }
                catch (Exception e) {
                    CS.log.e("TMS_MEDIA", e.getMessage());
                }
                finally {
                    DataSyncUtil.clearNewTaskList("APP_UPDATE_NEW_TASK_LIST");
                }
            }
            AppDownloadTaskData data = new AppDownloadTaskData();
            data.setTaskList(appList);
            String jsonData = Tson.toJson((Object)data);
            Context context = CoreUtil.getContext();
            Intent intent = new Intent(context, DataSyncService.class);
            intent.putExtra("media", 2);
            intent.putExtra("taskList", jsonData);
            try {
                context.startService(intent);
            }
            catch (Exception e) {
                DataSyncUtil.saveNewTaskList(newTaskList, "APP_UPDATE_NEW_TASK_LIST");
            }
        }
    }

    private String getImgUrl(AppDetailInfo info) {
        if (info == null || info.getImages() == null || info.getImages().size() <= 0) {
            return null;
        }
        return ((ImgInfo)info.getImages().get(0)).getUrl();
    }

    private void updateAppUpdateSettingsBadge(int appCount) {
        Context context = CoreUtil.getContext();
        if (context == null) {
            return;
        }
        int totalCount = 0;
        RecordStateData recordStateData = FileUtil.readRecordStateData(CoreUtil.getContext());
        if (recordStateData != null) {
            totalCount = recordStateData.getSettingBadgeCount() >= 0 ? recordStateData.getSettingBadgeCount() : 0;
        } else {
            recordStateData = new RecordStateData();
        }
        recordStateData.setSettingBadgeCount(totalCount += appCount);
        FileUtil.saveRecordStateData(context, recordStateData);
        if (totalCount <= 0) {
            AiMessageUtil.setChangeBudge(context, context.getPackageName(), AppUpdateActivity.class.getName(), 0);
            AiMessageUtil.setTipBudge(context, context.getPackageName(), AppUpdateActivity.class.getName(), 0);
        } else {
            AiMessageUtil.setChangeBudge(context, context.getPackageName(), AppUpdateActivity.class.getName(), totalCount);
            AiMessageUtil.setTipBudge(context, context.getPackageName(), AppUpdateActivity.class.getName(), 1);
        }
        CS.log.d("TMS_MEDIA", "AppUpdate Settings Badge: INCREASE COUNT = " + appCount);
        CS.log.d("TMS_MEDIA", "AppUpdate Settings Badge: UPDATE TO " + totalCount);
    }

    private static class AppSyncTask
    extends AsyncTask<String, Integer, List<AppInfo>> {
        IMediaCallback iMediaCallback = null;

        AppSyncTask(IMediaCallback callback) {
            this.iMediaCallback = callback;
        }

        protected List<AppInfo> doInBackground(String ... params) {
            List<AppInfo> appInfoList = PackageUtil.initAppList(CoreUtil.getContext());
            if (null != appInfoList && appInfoList.size() > 0) {
                return appInfoList;
            }
            return null;
        }

        protected void onPostExecute(List<AppInfo> appInfoList) {
            if (null != configMedia) {
                PhoneInfo phoneInfo = PhoneInfoManager.getInstance().getPhoneInfo();
                List planIDList = SpUtil.getSP().getIntList("APP_UPDATE_PLAN_LIST", null);
                configMedia.syncDataInternal(phoneInfo, planIDList, appInfoList, 0, this.iMediaCallback);
            }
        }
    }
}

