/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.receiver;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.text.TextUtils;
import com.transsion.appupdate.R;
import com.transsion.appupdate.service.AppUpdateJobService;
import com.transsion.appupdate.utils.NotifyUtils;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.common.bean.ConfigInfo;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.json.Tson;

public class PresenterReceiverAdapter {
    public static void onReceive(Context context, Intent intent) {
        if (intent != null && (TextUtils.equals((CharSequence)"android.intent.action.SCREEN_ON", (CharSequence)intent.getAction()) || TextUtils.equals((CharSequence)"android.intent.action.SCREEN_OFF", (CharSequence)intent.getAction()) || TextUtils.equals((CharSequence)"android.intent.action.USER_PRESENT", (CharSequence)intent.getAction()))) {
            if (context == null) {
                return;
            }
            int oobeState = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"oobe_has_run", (int)-1);
            if (oobeState != 1) {
                return;
            }
            if (!PrivacyPolicyUtil.isUserPrivacyPolicyAgreed()) {
                long lastNoticeTime = SpUtil.getSP().getLong("APP_UPDATE_LAST_INVITE_NOTICE_TIME", 0L);
                long period = System.currentTimeMillis() - lastNoticeTime;
                CS.log.d("TMS_APP", "privacy policy notice period = " + period);
                String configInfoJson = SpUtil.getSP().getString("APP_CONFIG_INFO", "null");
                ConfigInfo configInfo = (ConfigInfo)Tson.fromJson((String)configInfoJson, ConfigInfo.class);
                long noticePeriod = 432000000L;
                if (configInfo != null && configInfo.getPrivacyPolicyInterval() > 0) {
                    noticePeriod = (long)(configInfo.getPrivacyPolicyInterval() * 24 * 60 * 60) * 1000L;
                }
                if (period >= noticePeriod) {
                    PresenterReceiverAdapter.sendInviteNotification(context);
                    SpUtil.getSP().putLong("APP_UPDATE_LAST_INVITE_NOTICE_TIME", System.currentTimeMillis());
                }
            }
            if (CSLib.OS_UPDATE) {
                CS.log.v("TMS_OS_UPDATE", "PresenterReceiver");
                AppUpdateJobService.startOSDownLoadService(context);
            }
        }
    }

    private static void sendInviteNotification(Context context) {
        if (context == null) {
            return;
        }
        String title = context.getString(R.string.app_name);
        String text = context.getString(R.string.notification_privacy_policy_content);
        NotifyUtils.sendBigTextNotification(context, title, text, 12);
    }
}

