/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.transsion.appupdate.reportBean.OSUpdateAppDownloadEvent;
import com.transsion.appupdate.utils.AiMessageUtil;
import com.transsion.appupdate.utils.InstallUtil;
import com.transsion.osupdate.Logger;
import com.transsion.osupdate.Tracker;
import com.transsion.osupdate.util.OSFileUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class UpdateBroadcastReceiver
extends BroadcastReceiver {
    private AtomicInteger count = new AtomicInteger(0);

    public void onReceive(Context context, Intent intent) {
        String parentFile;
        List files;
        Logger.d((String)"TMS_OS_UPDATE", (String)("\u63a5\u6536\u5230\u4e86\u5e7f\u64ad" + intent.getAction()));
        if ("INSTALL_ACTION_OS".equals(intent.getAction()) && (files = OSFileUtil.listFilesInDir((String)(parentFile = OSFileUtil.getParentFile((Context)context)), (boolean)true)) != null && files.size() > 0) {
            new Thread(() -> {
                for (int i = 0; i < files.size(); ++i) {
                    File file = (File)files.get(i);
                    String absolutePath = file.getAbsolutePath();
                    if (!absolutePath.endsWith("apk")) {
                        Logger.d((String)"TMS_OS_UPDATE", (String)("\u4e0d\u662fapk\u6587\u4ef6\uff0c\u4e0d\u5b89\u88c5\uff0c path:" + absolutePath));
                        this.count.getAndIncrement();
                        Logger.d((String)"TMS_OS_UPDATE", (String)("count = " + this.count.get() + "files.size() =" + files.size()));
                        if (files.size() != this.count.get()) continue;
                        this.sendbroadcast(context, intent);
                        this.count.set(0);
                        continue;
                    }
                    Logger.d((String)"TMS_OS_UPDATE", (String)("\u662fapk\u6587\u4ef6\uff0c\u51c6\u5907\u5b89\u88c5\uff0c path:" + absolutePath));
                    InstallUtil.tryInstall(absolutePath, success -> {
                        if (success) {
                            Logger.d((String)"TMS_OS_UPDATE", (String)("\u5b89\u88c5\u6210\u529f" + absolutePath));
                        } else {
                            Logger.d((String)"TMS_OS_UPDATE", (String)("\u5b89\u88c5\u5931\u8d25" + absolutePath));
                        }
                        this.count.getAndIncrement();
                        PackageManager pm = context.getPackageManager();
                        PackageInfo info = pm.getPackageArchiveInfo(absolutePath, 1);
                        String packageName = null;
                        int version = 0;
                        if (info != null) {
                            packageName = info.packageName;
                            version = info.versionCode;
                        }
                        OSUpdateAppDownloadEvent eventData = new OSUpdateAppDownloadEvent();
                        eventData.setAppPkg(packageName);
                        eventData.setAppVersion(version);
                        eventData.setStatus(success ? 2 : -4);
                        Tracker.track((Tracker.TID)Tracker.TID.TMS_OSUPDATE_INSTALL_EVENT, (Bundle)eventData.getBundle());
                        Logger.d((String)"TMS_OS_UPDATE", (String)("count = " + this.count.get() + "files.size() =" + files.size()));
                        if (files.size() == this.count.get()) {
                            this.sendbroadcast(context, intent);
                            this.count.set(0);
                        }
                    });
                }
            }).start();
        }
    }

    private void sendbroadcast(Context context, Intent intent) {
        OSFileUtil.deleteAllInDir((String)OSFileUtil.getParentFile((Context)context));
        Intent intent1 = new Intent();
        intent1.setAction("INSTALL_ACTION");
        intent1.setPackage("com.transsion.systemupdate");
        intent1.putExtra("SUCCESSVERSION", intent.getStringExtra("SUCCESSVERSION"));
        intent1.putExtra("CURRENTDOWNLOADURL", intent.getStringExtra("CURRENTDOWNLOADURL"));
        context.sendBroadcast(intent1);
        Intent intentSelf = new Intent();
        intentSelf.setAction("INSTALL_ACTION_SELF");
        intentSelf.putExtra("SUCCESSVERSION", intent.getStringExtra("SUCCESSVERSION"));
        intentSelf.putExtra("CURRENTDOWNLOADURL", intent.getStringExtra("CURRENTDOWNLOADURL"));
        context.sendBroadcast(intentSelf);
        AiMessageUtil.setChangeBudge(context, "com.transsion.systemupdate", "com.transsion.systemupdate.SystemUpdateActivity", 0);
        AiMessageUtil.setTipBudge(context, "com.transsion.systemupdate", "com.transsion.systemupdate.SystemUpdateActivity", 0);
    }
}

