/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.media.IMediaCallback;
import com.transsion.appupdate.media.MediaManager;
import com.transsion.appupdate.service.ICoreAidl;
import com.transsion.appupdate.service.ICoreDataCallback;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;

public class CoreService
extends Service {
    private ICoreAidl.Stub coreInterface = new ICoreAidl.Stub(){

        @Override
        public void requestAppUpdateData(final ICoreDataCallback callback) throws RemoteException {
            MediaManager.getInstance().forceSyncAppUpdate(new IMediaCallback(){

                public void onRequestSuccess(Object mediaCallBack) {
                    try {
                        if (mediaCallBack instanceof String) {
                            String result = (String)mediaCallBack;
                            callback.onSuccess(result);
                        } else {
                            callback.onSuccess(null);
                        }
                    }
                    catch (RemoteException e) {
                        CS.log.e("TMS_APP", e.getMessage());
                    }
                }

                @Override
                public void onRequestFailed(String msg) {
                    try {
                        callback.onFail(msg);
                    }
                    catch (RemoteException e) {
                        CS.log.e("TMS_APP", e.getMessage());
                    }
                }
            });
        }

        @Override
        public void requestOslabAppUpdateData(final ICoreDataCallback callback) throws RemoteException {
            MediaManager.getInstance().forceSyncOsLabAppUpdate(new IMediaCallback(){

                public void onRequestSuccess(Object mediaCallBack) {
                    try {
                        if (mediaCallBack instanceof String) {
                            String result = (String)mediaCallBack;
                            callback.onSuccess(result);
                        } else {
                            callback.onSuccess(null);
                        }
                    }
                    catch (RemoteException e) {
                        CS.log.e("TMS_APP", e.getMessage());
                    }
                }

                @Override
                public void onRequestFailed(String msg) {
                    try {
                        callback.onFail(msg);
                    }
                    catch (RemoteException e) {
                        CS.log.e("TMS_APP", e.getMessage());
                    }
                }
            });
        }

        @Override
        public void getPrivacyPolicyState(ICoreDataCallback callback) throws RemoteException {
            boolean isAgreed = PrivacyPolicyUtil.isUserPrivacyPolicyAgreed();
            callback.onSuccess(String.valueOf(isAgreed));
        }

        @Override
        public void setPrivacyPolicyState(boolean isAgreed) throws RemoteException {
            if (isAgreed) {
                SpUtil.getSP().putInt("APP_UPDATE_PRIVACY_POLICY_STATE", 1);
                Tracker.enableTrackData();
            }
        }
    };

    public IBinder onBind(Intent intent) {
        return this.coreInterface;
    }
}

