/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.reportBean.AppInfoReport;
import com.transsion.appupdate.reportBean.PhoneInfoReportData;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.List;

public class DataCenterReportJobService
extends JobService {
    public static final int ENFORCE_JOB_ID = 353;
    public static final long DEFAULT_INTERVAL = CSLib.TEST_MODE ? 180000L : 3600000L;

    public static void startJob(Context context) {
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        if (js != null) {
            CS.log.d("TMS_APP", " ---> call startJob  DataCenterReportJobService ...");
            js.schedule(new JobInfo.Builder(353, new ComponentName(context, DataCenterReportJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(DEFAULT_INTERVAL * 2L).build());
        }
    }

    public boolean onStopJob(JobParameters params) {
        CS.log.d("TMS_UPDATE", "onStopJob Id: " + params.getJobId());
        return false;
    }

    public boolean onStartJob(JobParameters params) {
        long interval = ConfigInfoManager.getInstance().getDataCenterReportInterval();
        if (0L != interval) {
            this.trackerJob();
            if ((interval *= 1000L) < DEFAULT_INTERVAL && !CSLib.TEST_MODE) {
                interval = DEFAULT_INTERVAL;
            }
        } else {
            interval = DEFAULT_INTERVAL;
        }
        CS.log.d("TMS_APP", "===== onStartJob  DataCenterReportJobService ...  INTERVAL->" + interval);
        JobScheduler js = (JobScheduler)this.getSystemService("jobscheduler");
        if (js != null) {
            js.schedule(new JobInfo.Builder(353, new ComponentName((Context)this, DataCenterReportJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(interval * 2L).setPersisted(true).setMinimumLatency(interval).build());
        }
        return false;
    }

    void trackerJob() {
        Bundle bundle = new PhoneInfoReportData().getBundle();
        Tracker.track(Tracker.TID.TMS_APP_DATA_REPORT_PHONE, bundle);
        try {
            List packageInfoList = CoreUtil.getContext().getPackageManager().getInstalledPackages(0);
            if (packageInfoList != null) {
                ArrayList<Bundle> appInfoReportList = new ArrayList<Bundle>();
                for (PackageInfo info : packageInfoList) {
                    if (info.packageName.contains("keyboard") || info.packageName.contains("inputmethod") || info.packageName.contains("com.mediatek") || info.packageName.contains("com.google") || TextUtils.isEmpty((CharSequence)info.packageName)) continue;
                    boolean isSystem = (info.applicationInfo.flags & 1) > 0 || (info.applicationInfo.flags & 0x80) > 0;
                    AppInfoReport appInfo = new AppInfoReport(info.packageName, info.versionName, info.versionCode, isSystem);
                    appInfoReportList.add(appInfo.getBundle());
                }
                Tracker.trackList(Tracker.TID.TMS_APP_DATA_REPORT_PKG, appInfoReportList, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

