/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.detail;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.ui.detail.AppUpdateDetailContract;
import com.transsion.appupdate.ui.detail.AppUpdateDetailPresenter;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.widgets.DownloadProgressBar;
import com.transsion.common.log.CS;

public class AppUpdateDetailActivity
extends Activity
implements AppUpdateDetailContract.View {
    private ImageView mIvDownloadAppImage;
    private ImageView mIvDownloadAppIcon;
    private TextView mTvDownloadAppName;
    private TextView mTvDownloadAppVersion;
    private TextView mTvAppSize;
    private TextView mTvDownloadAppIntro;
    private DownloadProgressBar mPbDownloadButton;
    private ImageView mIvDownloadAnimWave;
    private Animation mDownloadAnim;
    private TextView mBtnCancel;
    private float mProgress;
    private AppUpdateDetailContract.Presenter mPresenter;
    private AppItem appItem;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_app_update_detail);
        this.initView();
        this.initData(this.getIntent());
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.initData(intent);
    }

    private void initView() {
        this.mIvDownloadAppImage = (ImageView)this.findViewById(R.id.iv_download_app_image);
        this.mIvDownloadAppIcon = (ImageView)this.findViewById(R.id.iv_download_app_icon);
        this.mTvDownloadAppName = (TextView)this.findViewById(R.id.tv_download_app_name);
        this.mTvDownloadAppVersion = (TextView)this.findViewById(R.id.tv_download_app_version);
        this.mTvAppSize = (TextView)this.findViewById(R.id.tv_app_size);
        this.mTvDownloadAppIntro = (TextView)this.findViewById(R.id.tv_download_app_intro);
        this.mPbDownloadButton = (DownloadProgressBar)this.findViewById(R.id.pb_download_button);
        this.mIvDownloadAnimWave = (ImageView)this.findViewById(R.id.iv_download_anim_wave);
        this.mBtnCancel = (TextView)this.findViewById(R.id.cancel_but);
        this.mBtnCancel.getPaint().setFlags(8);
    }

    private void initData(Intent intent) {
        if (intent != null) {
            this.mPresenter = new AppUpdateDetailPresenter(this);
            this.appItem = (AppItem)intent.getParcelableExtra("item_info");
            if (this.appItem == null) {
                this.finish();
                return;
            }
            if (intent.getBooleanExtra("from_tms_service", false)) {
                this.mPresenter.checkDownload(this.appItem);
            }
            this.mPresenter.registerDownloadListener();
            this.mTvDownloadAppName.setText((CharSequence)this.appItem.appName);
            String version = this.getString(R.string.download_app_version) + this.appItem.appVersionName;
            this.mTvDownloadAppVersion.setText((CharSequence)version);
            String size = this.getString(R.string.download_app_size) + StorageUtils.convertFromByte(this.appItem.allSize);
            this.mTvAppSize.setText((CharSequence)size);
            this.mTvDownloadAppIntro.setText((CharSequence)this.appItem.description);
            this.updateDownloadProgress(this.appItem.downloadSize, this.appItem.allSize);
            this.updateDownloadStatus(DownloadState.valueOf(this.appItem.state));
            this.mPresenter.loadAppIcon(this.appItem.appIconUrl, this.mIvDownloadAppIcon);
            this.mPresenter.loadAppImage(this.appItem.imgUrl, this.mIvDownloadAppImage);
            this.mPbDownloadButton.setOnClickListener(v -> this.mPresenter.requestDownload(this.appItem));
            this.mBtnCancel.setOnClickListener(v -> this.mPresenter.cancelDownload(this.appItem));
            this.mBtnCancel.setClickable(true);
            this.setCancelVisibility(DownloadState.valueOf(this.appItem.state));
            this.mPresenter.trackDetailEvent(Tracker.TID.TMS_DETAIL_OPEN, this.appItem);
        }
    }

    private void setCancelVisibility(DownloadState state) {
        this.mBtnCancel.setVisibility(8);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mPresenter != null) {
            this.mPresenter.unregisterDownloadListener();
            this.mPresenter = null;
        }
        this.mIvDownloadAnimWave.setVisibility(4);
        if (this.mDownloadAnim != null) {
            this.mDownloadAnim.cancel();
            this.mDownloadAnim = null;
        }
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void updateDownloadStatus(DownloadState status) {
        CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u8be6\u60c5\u72b6\u6001\uff1a" + (Object)((Object)status));
        this.appItem.state = status.name();
        this.mPbDownloadButton.setDownloadState(status);
        this.setCancelVisibility(status);
    }

    @Override
    public void updateDownloadProgress(long downloadSize, long allSize) {
        if (allSize <= 0L) {
            return;
        }
        this.appItem.downloadSize = (int)downloadSize;
        this.appItem.allSize = (int)allSize;
        int progress = (int)(downloadSize * 100L / allSize);
        CS.log.d("TMS_UPDATE", "\u4e0b\u8f7d\u8be6\u60c5\u8fdb\u5ea6\uff1a" + progress);
        this.mPbDownloadButton.setDownloadProgress(progress);
    }

    @Override
    public void startDownloadAnim() {
        float progressPercent = this.mProgress / 100.0f;
        float startX = (float)(0 - this.mIvDownloadAnimWave.getWidth()) + progressPercent * (float)this.mPbDownloadButton.getWidth();
        float endX = this.mPbDownloadButton.getWidth();
        this.mDownloadAnim = new TranslateAnimation(startX, endX, 0.0f, 0.0f);
        this.mDownloadAnim.setRepeatCount(0);
        this.mDownloadAnim.setDuration(2000L);
        this.mDownloadAnim.setStartOffset(500L);
        this.mDownloadAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                AppUpdateDetailActivity.this.mIvDownloadAnimWave.setVisibility(0);
            }

            public void onAnimationEnd(Animation animation) {
                AppUpdateDetailActivity.this.mIvDownloadAnimWave.setVisibility(4);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mIvDownloadAnimWave.startAnimation(this.mDownloadAnim);
    }

    @Override
    public void stopDownloadAnim() {
        if (this.mDownloadAnim != null) {
            this.mDownloadAnim.cancel();
        }
    }

    @Override
    public String getDetailUrl() {
        return this.appItem != null ? this.appItem.apkUrl : null;
    }

    @Override
    public void finishDetail() {
        this.setResult(0);
        this.finish();
    }
}

